/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.multicastjms;

import com.evermind.server.multicastjms.EvermindMessage;
import com.evermind.server.multicastjms.EvermindQueue;
import com.evermind.server.multicastjms.EvermindQueueConnection;
import com.evermind.server.multicastjms.EvermindQueueReceiver;
import com.evermind.server.multicastjms.EvermindQueueSender;
import com.evermind.server.multicastjms.EvermindSession;
import com.evermind.server.multicastjms.EvermindTemporaryQueue;
import com.evermind.server.multicastjms.EvermindTemporaryQueueBrowser;
import com.evermind.server.multicastjms.MessageSelector;
import java.util.List;
import javax.jms.Destination;
import javax.jms.IllegalStateException;
import javax.jms.InvalidDestinationException;
import javax.jms.InvalidSelectorException;
import javax.jms.JMSException;
import javax.jms.Queue;
import javax.jms.QueueBrowser;
import javax.jms.QueueReceiver;
import javax.jms.QueueSender;
import javax.jms.QueueSession;
import javax.jms.TemporaryQueue;

public class EvermindQueueSession
extends EvermindSession
implements QueueSession {
    EvermindQueueConnection connection;

    public void run() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void commit() throws JMSException {
        if (this.transactionMessages != null) {
            try {
                this.connection.acknowledgeMessages(this.transactionAcknowledgedMessages, 0, this.transactionAcknowledgedMessagesCount, true);
            }
            finally {
                this.transactionAcknowledgedMessagesCount = 0;
            }
            if (this.unacknowledgedMessagesCount > 0) {
                try {
                    this.connection.acknowledgeMessages(this.unacknowledgedMessages, 0, this.unacknowledgedMessagesCount, false);
                }
                finally {
                    this.unacknowledgedMessagesCount = 0;
                }
            }
            try {
                this.send(this.transactionMessages);
            }
            finally {
                this.transactionMessages.clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void rollback() throws JMSException {
        if (this.transactionMessages != null) {
            this.transactionMessages.clear();
        }
        try {
            this.connection.acknowledgeMessages(this.transactionAcknowledgedMessages, 0, this.transactionAcknowledgedMessagesCount, false);
        }
        finally {
            this.transactionAcknowledgedMessagesCount = 0;
        }
        if (this.unacknowledgedMessagesCount > 0) {
            try {
                this.connection.acknowledgeMessages(this.unacknowledgedMessages, 0, this.unacknowledgedMessagesCount, false);
            }
            finally {
                this.unacknowledgedMessagesCount = 0;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void close() throws JMSException {
        try {
            this.rollback();
        }
        finally {
            super.close();
        }
    }

    protected void send(List messages) throws JMSException {
        for (int i = 0; i < messages.size(); ++i) {
            EvermindMessage message = (EvermindMessage)messages.get(i);
            this.connection.send(((Queue)message.getJMSDestination()).getQueueName(), message, true);
        }
    }

    synchronized void send(Queue queue, EvermindMessage message) throws JMSException {
        message.setJMSDestination((Destination)queue);
        if (this.getTransacted()) {
            this.addTransactionMessage(message);
        } else {
            this.connection.send(queue.getQueueName(), message, true);
        }
    }

    protected void addTransactionMessage(EvermindMessage message) {
        this.transactionMessages.add(message);
    }

    public EvermindQueueSession(EvermindQueueConnection connection, boolean transacted, int acknowledgeMode) {
        super(transacted, acknowledgeMode);
        this.connection = connection;
    }

    public QueueReceiver createReceiver(Queue queue) throws InvalidDestinationException {
        return this.createReceiver(queue, null);
    }

    public QueueReceiver createReceiver(Queue queue, String selector) throws InvalidDestinationException {
        try {
            return new EvermindQueueReceiver(this, (EvermindQueue)queue, selector);
        }
        catch (ClassCastException e) {
            throw new InvalidDestinationException("Invalid queue");
        }
    }

    public Queue createQueue(String name) throws JMSException {
        this.connection.createQueue(name);
        return new EvermindQueue(name);
    }

    public QueueSender createSender(Queue queue) throws InvalidDestinationException {
        if (queue == null) {
            throw new NullPointerException("queue was null");
        }
        try {
            return new EvermindQueueSender(this, (EvermindQueue)queue);
        }
        catch (ClassCastException e) {
            throw new InvalidDestinationException("Invalid queue");
        }
    }

    public QueueBrowser createBrowser(Queue queue) throws InvalidDestinationException {
        if (queue instanceof EvermindTemporaryQueue) {
            return new EvermindTemporaryQueueBrowser((EvermindTemporaryQueue)queue, null);
        }
        try {
            return this.connection.createBrowser(this, (EvermindQueue)queue, null);
        }
        catch (ClassCastException e) {
            throw new InvalidDestinationException("Invalid queue");
        }
    }

    public QueueBrowser createBrowser(Queue queue, String selector) throws InvalidDestinationException, InvalidSelectorException {
        if (queue instanceof EvermindTemporaryQueue) {
            return new EvermindTemporaryQueueBrowser((EvermindTemporaryQueue)queue, MessageSelector.getSelector(selector));
        }
        try {
            return this.connection.createBrowser(this, (EvermindQueue)queue, MessageSelector.getSelector(selector));
        }
        catch (ClassCastException e) {
            throw new InvalidDestinationException("Invalid queue");
        }
    }

    public TemporaryQueue createTemporaryQueue() {
        return new EvermindTemporaryQueue(this);
    }

    public synchronized void acknowledgeMessage(EvermindMessage message) throws JMSException {
        for (int i = 0; i < this.unacknowledgedMessagesCount; ++i) {
            EvermindMessage comparison = this.unacknowledgedMessages[i];
            if (comparison.sender != message.sender || comparison.id != message.id) continue;
            if (this.getTransacted()) {
                this.addTransactionAcknowledgedMessage(message);
            } else {
                this.connection.acknowledgeMessages(this.unacknowledgedMessages, 0, i, true);
            }
            System.arraycopy(this.unacknowledgedMessages, i + 1, this.unacknowledgedMessages, 0, this.unacknowledgedMessagesCount - (i + 1));
            this.unacknowledgedMessagesCount -= i + 1;
            break;
        }
    }

    public EvermindMessage receive(String destination, String selector, long timeout) throws JMSException {
        EvermindMessage message;
        int acknowledgeMode = this.acknowledgeMode;
        if (this.getTransacted() && this.acknowledgeMode == 1) {
            acknowledgeMode = 2;
        }
        if ((message = this.connection.receive(destination, selector, timeout, (byte)acknowledgeMode)) != null) {
            message.receivedSession = this;
            if (this.acknowledgeMode == 2) {
                this.addUnacknowledgedMessage(message);
            } else if (this.getTransacted()) {
                this.addTransactionAcknowledgedMessage(message);
            }
        }
        return message;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recover() throws JMSException {
        if (this.transactionMessages != null) {
            throw new IllegalStateException("Illlegal to call recover() for sessions in transacted mode");
        }
        EvermindQueueSession evermindQueueSession = this;
        synchronized (evermindQueueSession) {
            for (int i = 0; i < this.unacknowledgedMessagesCount; ++i) {
                this.unacknowledgedMessages[i].setJMSRedelivered(true);
                this.send((Queue)this.unacknowledgedMessages[i].destination, this.unacknowledgedMessages[i]);
            }
        }
    }
}

