/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.jms.filter;

import com.evermind.server.jms.filter.AssertException;
import com.evermind.server.jms.filter.CorrID_fa;
import com.evermind.server.jms.filter.DeliveryMode_fa;
import com.evermind.server.jms.filter.FieldAccess;
import com.evermind.server.jms.filter.FormatField;
import com.evermind.server.jms.filter.MessageFormat;
import com.evermind.server.jms.filter.MessageID_fa;
import com.evermind.server.jms.filter.NoSuchFieldException;
import com.evermind.server.jms.filter.Priority_fa;
import com.evermind.server.jms.filter.Prop_fa;
import com.evermind.server.jms.filter.Timestamp_fa;
import com.evermind.server.jms.filter.Type_fa;
import com.evermind.server.jms.filter.UnsupportedFieldException;
import java.util.Hashtable;

public class MercuryMessage
implements MessageFormat {
    private String formatName;
    private static FormatField prop_ff;
    private static Hashtable format_ht;
    private static Hashtable access_ht;
    static boolean init;

    public MercuryMessage(String formatName) throws AssertException {
        if (!init) {
            throw new AssertException("static initializers failed", null);
        }
        this.formatName = formatName;
        if (formatName == null) {
            throw new AssertException("null name", null);
        }
    }

    public FieldAccess getFieldAccess(String fieldName) throws NoSuchFieldException, UnsupportedFieldException {
        if (fieldName == null) {
            throw new NoSuchFieldException(fieldName);
        }
        FieldAccess fa = (FieldAccess)access_ht.get(fieldName);
        if (fa != null) {
            return fa;
        }
        if (fieldName.startsWith("JMS")) {
            throw new UnsupportedFieldException(fieldName);
        }
        fa = new Prop_fa(fieldName);
        access_ht.put(fieldName, fa);
        return fa;
    }

    public FormatField lookupField(String fieldName) {
        if (fieldName == null) {
            return null;
        }
        FormatField ff = (FormatField)format_ht.get(fieldName);
        if (ff != null) {
            return ff;
        }
        if (fieldName.startsWith("JMS")) {
            return null;
        }
        format_ht.put(fieldName, prop_ff);
        return prop_ff;
    }

    static {
        init = false;
        try {
            FormatField deliveryMode_ff = new FormatField("JMSDeliveryMode", 3);
            FormatField priority_ff = new FormatField("JMSPriority", 2);
            FormatField messageID_ff = new FormatField("JMSMessageID", 3);
            FormatField timestamp_ff = new FormatField("JMSTimestamp", 4);
            FormatField corrID_ff = new FormatField("JMSCorrelationID", 3);
            FormatField type_ff = new FormatField("JMSType", 3);
            prop_ff = new FormatField("JMSProp", 7);
            access_ht = new Hashtable();
            access_ht.put("JMSDeliveryMode", new DeliveryMode_fa());
            access_ht.put("JMSPriority", new Priority_fa());
            access_ht.put("JMSMessageID", new MessageID_fa());
            access_ht.put("JMSTimestamp", new Timestamp_fa());
            access_ht.put("JMSCorrelationID", new CorrID_fa());
            access_ht.put("JMSType", new Type_fa());
            access_ht.put("JMSXUserID", new Prop_fa("JMSXUserID"));
            access_ht.put("JMSXAppID", new Prop_fa("JMSXAppID"));
            access_ht.put("JMSXDeliveryCount", new Prop_fa("JMSXDeliveryCount"));
            access_ht.put("JMSXGroupID", new Prop_fa("JMSXGroupID"));
            access_ht.put("JMSXGroupSeq", new Prop_fa("JMSXGroupSeq"));
            access_ht.put("JMSXProducerTXID", new Prop_fa("JMSXProducerTXID"));
            access_ht.put("JMSXConsumerTXID", new Prop_fa("JMSXConsumerTXID"));
            access_ht.put("JMSXRcvTimestamp", new Prop_fa("JMSXRcvTimestamp"));
            access_ht.put("JMSXState", new Prop_fa("JMSXState"));
            format_ht = new Hashtable();
            format_ht.put("JMSDeliveryMode", deliveryMode_ff);
            format_ht.put("JMSPriority", priority_ff);
            format_ht.put("JMSMessageID", messageID_ff);
            format_ht.put("JMSTimestamp", timestamp_ff);
            format_ht.put("JMSCorrelationID", corrID_ff);
            format_ht.put("JMSType", type_ff);
            format_ht.put("JMSXUserID", prop_ff);
            format_ht.put("JMSXAppID", prop_ff);
            format_ht.put("JMSXDeliveryCount", prop_ff);
            format_ht.put("JMSXGroupID", prop_ff);
            format_ht.put("JMSXGroupSeq", prop_ff);
            format_ht.put("JMSXProducerTXID", prop_ff);
            format_ht.put("JMSXConsumerTXID", prop_ff);
            format_ht.put("JMSXRcvTimestamp", prop_ff);
            format_ht.put("JMSXState", prop_ff);
            init = true;
        }
        catch (AssertException assEx) {
            assEx.printStackTrace();
        }
    }
}

