/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.jms.filter;

import com.evermind.server.jms.filter.AssertException;
import com.evermind.server.jms.filter.ExpressionVector;
import com.evermind.server.jms.filter.Filter;
import com.evermind.server.jms.filter.GeneralException;
import com.evermind.server.jms.filter.IBooleanExpression;
import com.evermind.server.jms.filter.MessageFormat;
import com.evermind.server.jms.filter.Query;
import com.evermind.server.jms.filter.QuerySemanticException;
import com.evermind.server.jms.filter.QuerySyntaxException;
import com.evermind.server.jms.filter.QueryVector;
import java.util.Vector;
import javax.jms.Message;

public class EventRules {
    private ExpressionVector m_exprs;
    private QueryVector m_queries;
    private MessageFormat m_format;
    private String m_eventName;
    private boolean m_idempotent;

    public EventRules(String name, MessageFormat fmt) throws AssertException {
        if (name == null || fmt == null) {
            throw new AssertException("null arguments", null);
        }
        this.m_eventName = name;
        this.m_exprs = new ExpressionVector();
        this.m_queries = new QueryVector();
        this.m_format = fmt;
        this.m_idempotent = true;
    }

    public synchronized Filter addQuery(String queryExpr, Object obj) throws QuerySyntaxException, QuerySemanticException, GeneralException {
        IBooleanExpression root = (IBooleanExpression)Query.parseFilter(queryExpr, this.m_format, this);
        IBooleanExpression sharedRoot = this.m_exprs.addNewExpr(root);
        try {
            this.m_queries.addQuery(sharedRoot, obj);
            return sharedRoot;
        }
        catch (AssertException ae) {
            this.m_exprs.removeExpr(sharedRoot);
            throw ae;
        }
    }

    public synchronized boolean removeQuery(Object so) throws GeneralException {
        return this.m_queries.removeQuery(so, this.m_exprs);
    }

    public synchronized void setIdempotent(boolean val) {
        this.m_idempotent = val;
    }

    public synchronized boolean isIdempotent() {
        return this.m_idempotent;
    }

    public synchronized void evalEvent(Message formattedMessage, Vector results) throws AssertException {
        this.m_exprs.evaluate(formattedMessage);
        this.m_queries.eval(results);
    }

    public synchronized String toString() {
        return "    \nRule for " + this.m_eventName + "\n    Expressions: " + this.m_exprs.toString() + "\n    Queries: " + this.m_queries.toString();
    }
}

