/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.jms;

import com.evermind.security.User;
import com.evermind.server.ThreadState;
import com.evermind.server.jms.DummyXMLConfigElement;
import com.evermind.server.jms.JMSServerMessages;
import com.evermind.server.jms.JMSTraceLogger;
import com.evermind.server.jms.JMXSupport;
import com.evermind.server.jms.config.XMLConfigElement;
import com.evermind.server.jms.config.XMLConfigElementFactory;
import com.evermind.server.jms.config.XMLConfigEvent;
import com.evermind.server.jms.config.XMLConfigException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.security.PrivilegedExceptionAction;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import org.w3c.dom.Node;

public class XMLConfigBroadcaster {
    private static XMLConfigBroadcaster s_broadcaster = null;
    private static final JMSTraceLogger s_traceLogger = new JMSTraceLogger(XMLConfigBroadcaster.class);
    private final HashSet m_outdated = new HashSet();
    private final HashMap m_factories = new HashMap();
    private final HashMap m_listeners = new HashMap();
    private final HashMap m_nodes;
    private final HashMap m_users = new HashMap();

    private XMLConfigBroadcaster() {
        this.m_nodes = new HashMap();
    }

    public static XMLConfigBroadcaster getBroadcaster() {
        if (s_broadcaster == null) {
            s_broadcaster = new XMLConfigBroadcaster();
        }
        return s_broadcaster;
    }

    private void fireEvent(ObjectName objectName, XMLConfigEvent event, User user) throws InstanceNotFoundException, MBeanException, ReflectionException {
        FireEvent fe = new FireEvent();
        fe.objectName = objectName;
        fe.event = event;
        ThreadState state = ThreadState.getCurrentState();
        User oldUser = state.runAsUser;
        state.runAsUser = user;
        try {
            state.runAs(fe);
        }
        catch (Throwable t) {
            if (t instanceof InstanceNotFoundException) {
                throw (InstanceNotFoundException)t;
            }
            if (t instanceof MBeanException) {
                throw (MBeanException)t;
            }
            if (t instanceof ReflectionException) {
                throw (ReflectionException)t;
            }
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            throw new RuntimeException(t);
        }
        finally {
            state.runAsUser = oldUser;
        }
    }

    public void addXMLConfigListener(ObjectName cbObjectName, XMLConfigElementFactory xceFact) throws XMLConfigException {
        s_traceLogger.entering("addXMLConfigListener", new Object[]{cbObjectName, xceFact});
        String rootTag = xceFact.getRootElementTag();
        boolean added = false;
        try {
            s_traceLogger.finer("addXMLConfigListener::rootTag={0}", new Object[]{rootTag});
            if (this.m_listeners.containsKey(rootTag)) {
                throw JMSServerMessages.warningDuplicateListener(this.m_listeners.get(rootTag).toString(), rootTag);
            }
            User user = ThreadState.getCurrentState().getUser();
            this.m_factories.put(rootTag, xceFact);
            this.m_listeners.put(rootTag, cbObjectName);
            this.m_users.put(rootTag, user);
            added = true;
            XMLConfigElement elem = this.getStoredElement(rootTag);
            s_traceLogger.finer("existing element: {0}", new Object[]{elem});
            XMLConfigEvent event = new XMLConfigEvent(cbObjectName, "regcom", elem);
            this.fireEvent(cbObjectName, event, user);
        }
        catch (Throwable ex) {
            if (added) {
                this.removeXMLConfigListener(rootTag);
            }
            s_traceLogger.throwing("addXMLConfigListener", ex);
            if (ex instanceof XMLConfigException) {
                throw (XMLConfigException)ex;
            }
            throw new XMLConfigException(ex);
        }
        s_traceLogger.exiting("addXMLConfigListener");
    }

    public void removeXMLConfigListener(ObjectName cbObjectName, XMLConfigElementFactory xceFact) throws XMLConfigException {
        s_traceLogger.entering("removeXMLConfigListener", new Object[]{cbObjectName, xceFact});
        try {
            String rootTag = xceFact.getRootElementTag();
            s_traceLogger.finer("removeXMLConfigListener::rootTag={0}", new Object[]{rootTag});
            Object listener = this.m_listeners.get(rootTag);
            if (listener == null || !listener.equals(cbObjectName)) {
                throw JMSServerMessages.warningListenerNotRegistered(cbObjectName.toString(), rootTag);
            }
            this.removeXMLConfigListener(rootTag);
        }
        catch (Throwable ex) {
            s_traceLogger.throwing("removeXMLConfigListener", ex);
            if (ex instanceof XMLConfigException) {
                throw (XMLConfigException)ex;
            }
            throw new XMLConfigException(ex);
        }
        s_traceLogger.exiting("removeXMLConfigListener");
    }

    private XMLConfigElement getStoredElement(String rootTag) {
        Object obj = this.m_nodes.get(rootTag);
        if (!(obj instanceof Node)) {
            return (XMLConfigElement)obj;
        }
        Object fact = this.m_factories.get(rootTag);
        return fact != null ? ((XMLConfigElementFactory)fact).createXMLConfigElement((Node)obj) : new DummyXMLConfigElement((Node)obj);
    }

    private void storeElement(String rootTag, XMLConfigElement elem) {
        this.m_nodes.put(rootTag, elem);
    }

    private void storeNode(String rootTag, Node node) {
        this.m_nodes.put(rootTag, node);
    }

    private Iterator getRootTagIterator() {
        return this.m_nodes.keySet().iterator();
    }

    private void removeXMLConfigListener(String rootTag) {
        s_traceLogger.entering("removeXMLConfigListener", new Object[]{rootTag});
        this.m_factories.remove(rootTag);
        this.m_listeners.remove(rootTag);
        this.m_users.remove(rootTag);
        s_traceLogger.exiting("removeXMLConfigListener");
    }

    public void broadcastUpdate(Object source, Node node) {
        s_traceLogger.entering("broadcastUpdate", new Object[]{source, node});
        if (node.getNodeType() != 1) {
            throw new IllegalArgumentException("Expected Node of type 1, but got type " + node.getNodeType());
        }
        String rootTag = node.getNodeName();
        s_traceLogger.finer("broadcastUpdate::rootTag={0}", new Object[]{rootTag});
        XMLConfigElement oldElem = this.getStoredElement(rootTag);
        s_traceLogger.finer("oldElem={0}", new Object[]{oldElem});
        this.storeNode(rootTag, node);
        this.m_outdated.remove(rootTag);
        if (!this.m_listeners.containsKey(rootTag)) {
            s_traceLogger.finer("no listener to broadcast to.");
            return;
        }
        XMLConfigElementFactory fact = (XMLConfigElementFactory)this.m_factories.get(rootTag);
        ObjectName objName = (ObjectName)this.m_listeners.get(rootTag);
        s_traceLogger.finer("fire to {0}?", new Object[]{objName});
        XMLConfigElement elem = fact.createXMLConfigElement(node);
        if (oldElem != null && elem.equals(oldElem)) {
            s_traceLogger.finer("not firing because elem is same");
        }
        XMLConfigEvent event = new XMLConfigEvent(source, "confup", elem);
        try {
            s_traceLogger.finer("firing event: {0}", new Object[]{event});
            this.fireEvent(objName, event, (User)this.m_users.get(rootTag));
        }
        catch (Throwable ex) {
            JMSServerMessages.warningInstanceNotFound(objName);
            this.removeXMLConfigListener(rootTag);
        }
        s_traceLogger.exiting("broadcastUpdate");
    }

    public void setXMLConfigElement(XMLConfigElement elem) throws XMLConfigException {
        try {
            String rootTag = null;
            StringWriter stringWriter = new StringWriter();
            PrintWriter out = new PrintWriter(stringWriter);
            elem.writeXML(out, "");
            out.flush();
            String xml = stringWriter.toString();
            int startTagIdx = -1;
            for (int index = 0; index < xml.length(); ++index) {
                char curr = xml.charAt(index);
                if (startTagIdx == -1 && curr == '<') {
                    if (xml.charAt(++index) == '!') continue;
                    startTagIdx = index;
                    continue;
                }
                if (startTagIdx == -1 || curr != '>' && curr != '/' && !Character.isWhitespace(curr)) continue;
                rootTag = xml.substring(startTagIdx, index);
                break;
            }
            this.storeElement(rootTag, elem);
        }
        catch (Throwable ex) {
            throw new XMLConfigException(ex);
        }
    }

    public void writeConfigElements(PrintWriter out, String indent) {
        Iterator rootTags = this.getRootTagIterator();
        while (rootTags.hasNext()) {
            String rootTag = (String)rootTags.next();
            XMLConfigElement elem = this.getStoredElement(rootTag);
            try {
                elem.writeXML(out, indent);
                out.println("");
            }
            catch (Throwable ex) {
                JMSServerMessages.severeConfigUpdate(null, ex);
            }
        }
    }

    public void prepareForRefresh() {
        this.m_outdated.addAll(this.m_nodes.keySet());
    }

    public void commitRefresh() {
        Iterator iter = this.m_outdated.iterator();
        while (iter.hasNext()) {
            this.m_nodes.remove(iter.next());
        }
        this.m_outdated.clear();
    }

    private static class FireEvent
    implements PrivilegedExceptionAction {
        public ObjectName objectName;
        public XMLConfigEvent event;

        private FireEvent() {
        }

        public Object run() throws InstanceNotFoundException, MBeanException, ReflectionException {
            JMXSupport.invoke(this.objectName, "fireXMLConfigEvent", new Object[]{this.event}, new String[]{"com.evermind.server.jms.config.XMLConfigEvent"});
            return null;
        }
    }
}

