/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.jms;

import java.util.Iterator;
import java.util.NoSuchElementException;

final class NList {
    private final Node list = new Node(this);

    NList() {
    }

    void add(Node node) {
        Node prev = this.list.prev;
        node.prev = prev;
        node.next = this.list;
        prev.next = node;
        this.list.prev = node;
    }

    void clear() {
        Node next;
        Node ptr = this.list.next;
        do {
            next = ptr.next;
            ptr.prev = ptr;
            ptr.next = ptr;
        } while ((ptr = next) != this.list);
    }

    Iterator iterator() {
        return new Iter(this.list);
    }

    private static class Iter
    implements Iterator {
        private Node ptr;
        private final Node list;

        Iter(Node list) {
            this.list = list;
            this.ptr = this.list.next;
        }

        public boolean hasNext() {
            return this.ptr != this.list;
        }

        public Object next() {
            if (this.ptr == this.list) {
                throw new NoSuchElementException();
            }
            Object result = this.ptr.object;
            this.ptr = this.ptr.next;
            return result;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    static class Node {
        private Node next = this;
        private Node prev = this;
        private final Object object;

        Node(Object object) {
            this.object = object;
        }

        void remove() {
            this.prev.next = this.next;
            this.next.prev = this.prev;
            this.prev = this;
            this.next = this;
        }
    }
}

