/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.jms;

import com.evermind.server.jms.JMSMessages;
import com.evermind.server.jms.JMSTraceLogger;
import com.evermind.server.jms.JMSUtils;
import com.evermind.server.jms.Pool;
import com.evermind.server.jms.Poolable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public final class LRUPool
implements Pool {
    private long m_count = 0L;
    private int m_size;
    private final String m_name;
    private final Map m_objs = new HashMap();
    private final Set m_idle = new HashSet();
    private final Set m_active = new HashSet();
    private static final JMSTraceLogger s_traceLogger = new JMSTraceLogger(LRUPool.class);
    private static final long WAIT_TIME = 1000L;

    public LRUPool(int size, String name) {
        this.m_size = size;
        String string = this.m_name = JMSUtils.isNull(name) ? "@" + this.hashCode() : name;
        if (this.m_size <= 0) {
            JMSUtils.toRuntimeException(JMSMessages.getMessage("J2EE JMS-02650", new Integer(this.m_size)));
        }
    }

    public String toString() {
        return "LRUPool[" + this.m_name + ",size=" + this.m_size + ",objects=" + this.m_objs.size() + ",idle=" + this.m_idle.size() + ",active=" + this.m_active.size() + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSize(int newSize) {
        this.m_size = newSize;
        if (this.m_size <= 0) {
            JMSUtils.toRuntimeException(JMSMessages.getMessage("J2EE JMS-02650", new Integer(this.m_size)));
        }
        if (this.m_objs.size() <= this.m_size) {
            return;
        }
        Map map = this.m_objs;
        synchronized (map) {
            this.invariant();
            Iterator idleIter = this.m_idle.iterator();
            ArrayList<Throwable> exList = new ArrayList<Throwable>();
            while (this.m_objs.size() > this.m_size && idleIter.hasNext()) {
                try {
                    Poolable p = (Poolable)idleIter.next();
                    this.m_active.remove(p);
                    this.m_idle.remove(p);
                    this.m_objs.remove(p);
                    p.passivate();
                }
                catch (Throwable ex) {
                    exList.add(ex);
                }
            }
            if (exList.size() > 0) {
                s_traceLogger.fine("setSize", JMSUtils.makeRuntimeException("setSize", exList));
            }
            this.invariant();
            this.m_objs.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(Poolable p) throws Exception {
        this.checkNull(p);
        Map map = this.m_objs;
        synchronized (map) {
            this.invariant();
            try {
                if (this.m_objs.containsKey(p)) {
                    JMSUtils.toRuntimeException(JMSMessages.getMessage("J2EE JMS-02651", this, p));
                }
                this.m_objs.put(p, new Long(++this.m_count));
            }
            finally {
                this.invariant();
                this.m_objs.notify();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(Poolable p) throws Exception {
        this.checkNull(p);
        Map map = this.m_objs;
        synchronized (map) {
            this.invariant();
            try {
                if (!this.m_objs.containsKey(p)) {
                    JMSUtils.toRuntimeException(JMSMessages.getMessage("J2EE JMS-02652", this, p));
                }
                if (this.m_active.contains(p)) {
                    JMSUtils.toRuntimeException(JMSMessages.getMessage("J2EE JMS-02653", this, p));
                }
                boolean doPassivate = this.m_idle.contains(p);
                this.m_active.remove(p);
                this.m_idle.remove(p);
                this.m_objs.remove(p);
                if (doPassivate) {
                    p.passivate();
                }
            }
            finally {
                this.invariant();
                this.m_objs.notify();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void get(Poolable p) throws Exception {
        this.checkNull(p);
        Map map = this.m_objs;
        synchronized (map) {
            this.invariant();
            try {
                if (!this.m_objs.containsKey(p)) {
                    JMSUtils.toRuntimeException(JMSMessages.getMessage("J2EE JMS-02652", this, p));
                }
                if (this.m_active.contains(p)) {
                    JMSUtils.toRuntimeException(JMSMessages.getMessage("J2EE JMS-02654", this, p));
                }
                Poolable v = null;
                boolean doActivate = false;
                if (this.m_idle.contains(p)) {
                    this.m_idle.remove(p);
                } else {
                    v = this.waitForPool(p);
                    doActivate = true;
                }
                this.m_active.add(p);
                try {
                    if (v != null) {
                        v.passivate();
                    }
                }
                finally {
                    if (doActivate) {
                        p.activate();
                    }
                }
            }
            finally {
                this.invariant();
                this.m_objs.notify();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(Poolable p) throws Exception {
        this.checkNull(p);
        Map map = this.m_objs;
        synchronized (map) {
            this.invariant();
            try {
                if (!this.m_objs.containsKey(p)) {
                    JMSUtils.toRuntimeException(JMSMessages.getMessage("J2EE JMS-02652", this, p));
                }
                if (!this.m_active.contains(p)) {
                    JMSUtils.toRuntimeException(JMSMessages.getMessage("J2EE JMS-02655", this, p));
                }
                this.m_active.remove(p);
                this.m_idle.add(p);
                this.m_objs.put(p, new Long(++this.m_count));
            }
            finally {
                this.invariant();
                this.m_objs.notify();
            }
        }
    }

    private void checkNull(Poolable p) {
        if (p == null) {
            JMSUtils.toRuntimeException(JMSMessages.getMessage("J2EE JMS-02600", this, "p"));
        }
    }

    private Poolable waitForPool(Poolable forp) throws Exception {
        while (this.m_active.size() >= this.m_size) {
            this.m_objs.wait(1000L);
        }
        if (this.m_active.size() + this.m_idle.size() < this.m_size) {
            return null;
        }
        this.invariant();
        Poolable v = null;
        long min = Long.MAX_VALUE;
        Iterator iter = this.m_idle.iterator();
        while (iter.hasNext()) {
            Poolable p = (Poolable)iter.next();
            long c = (Long)this.m_objs.get(p);
            if (c >= min) continue;
            min = c;
            v = p;
        }
        if (v == null) {
            JMSUtils.toRuntimeException(JMSMessages.getMessage("J2EE JMS-02656", this, forp));
        }
        this.m_idle.remove(v);
        this.invariant();
        return v;
    }

    private void invariant() {
    }
}

