/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.jms;

import com.evermind.net.NetworkConnection;
import com.evermind.server.jms.DummyStats;
import com.evermind.server.jms.EvermindMessage;
import com.evermind.server.jms.JMSCommands;
import com.evermind.server.jms.JMSMessages;
import com.evermind.server.jms.JMSServerProxy;
import com.evermind.server.jms.JMSTraceLogger;
import com.evermind.server.jms.JMSUtils;
import com.evermind.server.jms.SessionID;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.Serializable;
import java.net.InetAddress;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.jms.JMSException;
import javax.jms.TransactionRolledBackException;

abstract class JMSRemoteServer
implements JMSCommands {
    protected int connectionState;
    protected static final int CS_NEW = 0;
    protected static final int CS_REGISTERED = 1;
    protected static final int CS_CLOSED = 2;
    protected InetAddress m_addr;
    protected int m_port;
    protected String m_user;
    protected String m_pass;
    protected String m_connID = null;
    protected String m_clientID = null;
    protected String m_cuser = null;
    protected NetworkConnection m_conn = null;
    protected String m_name = null;
    protected DummyStats m_jstats;
    protected DataInputStream m_dinp = null;
    protected DataOutputStream m_dout = null;
    protected boolean pingDone;
    protected boolean pingInProgress;
    protected JMSException pingLastException;
    protected int m_protocol = -559038734;
    protected final Map m_cons = new HashMap();
    protected final Map m_consMap = new HashMap();
    protected final Set m_sess = new HashSet();
    protected final Set m_badSess = new HashSet();
    protected static final JMSTraceLogger s_traceLogger = new JMSTraceLogger(JMSRemoteServer.class);

    JMSRemoteServer() {
    }

    public String toString() {
        return "JMSRemoteServer[" + this.m_name + "]";
    }

    public abstract void closeConnection();

    public String getJMSProviderName() {
        return this.m_name;
    }

    public synchronized void registerConnection(String clientID, String connID, String user) throws JMSException {
        this.assertNew();
        this.m_clientID = clientID;
        this.m_connID = connID;
        this.m_cuser = user;
        this.execute(this.registerConnectionOp(clientID, connID, user));
        this.m_jstats.state("clientID", this.m_clientID, true);
        this.m_jstats.state("connectionID", this.m_connID, true);
        this.m_jstats.state("currentUser", this.m_user, true);
    }

    protected Op registerConnectionOp(final String clientID, final String connID, final String user) {
        return new Op(){

            public String name() {
                return "registerConnection";
            }

            public void sendRequest() throws Throwable {
                JMSRemoteServer.this.m_dout.writeInt(1000);
                JMSRemoteServer.this.m_dout.writeUTF(JMSUtils.fold(clientID));
                JMSRemoteServer.this.m_dout.writeUTF(connID);
                JMSRemoteServer.this.m_dout.writeUTF(JMSUtils.fold(user));
            }

            public Object getReply() throws Throwable {
                JMSRemoteServer.this.processFlag(this);
                JMSRemoteServer.this.connectionState = 1;
                return null;
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized JMSException ping() {
        if (!this.pingDone) {
            this.pingInProgress = true;
            try {
                JMSException jMSException = (JMSException)((Object)this.execute(new Op(){

                    public String name() {
                        return "ping";
                    }

                    public void sendRequest() throws Throwable {
                        JMSRemoteServer.this.assertRegistered();
                        JMSRemoteServer.this.m_dout.writeInt(1001);
                    }

                    public Object getReply() throws Throwable {
                        JMSRemoteServer.this.processFlag(this);
                        return null;
                    }
                }));
                return jMSException;
            }
            catch (JMSException jMSException) {
            }
            finally {
                this.pingInProgress = false;
            }
        }
        return this.pingLastException;
    }

    public synchronized String getKnobs() throws JMSException {
        this.assertRegistered();
        return (String)this.execute(new Op(){

            public String name() {
                return "getKnobs";
            }

            public void sendRequest() throws Throwable {
                JMSRemoteServer.this.m_dout.writeInt(1003);
            }

            public Object getReply() throws Throwable {
                return JMSRemoteServer.this.getObject(this);
            }
        });
    }

    public synchronized String getStats() throws JMSException {
        this.assertRegistered();
        return (String)this.execute(new Op(){

            public String name() {
                return "getStats";
            }

            public void sendRequest() throws Throwable {
                JMSRemoteServer.this.m_dout.writeInt(1004);
            }

            public Object getReply() throws Throwable {
                return JMSRemoteServer.this.getObject(this);
            }
        });
    }

    public synchronized List getDestinations(final boolean forAPI) throws JMSException {
        this.assertRegistered();
        return (List)this.execute(new Op(){

            public String name() {
                return "getDestinations";
            }

            public void sendRequest() throws Throwable {
                JMSRemoteServer.this.m_dout.writeInt(2000);
                JMSRemoteServer.this.m_dout.writeBoolean(forAPI);
            }

            public Object getReply() throws Throwable {
                return JMSRemoteServer.this.getObject(this);
            }
        });
    }

    public synchronized List getDurables() throws JMSException {
        this.assertRegistered();
        return (List)this.execute(new Op(){

            public String name() {
                return "getDurables";
            }

            public void sendRequest() throws Throwable {
                JMSRemoteServer.this.m_dout.writeInt(2001);
            }

            public Object getReply() throws Throwable {
                return JMSRemoteServer.this.getObject(this);
            }
        });
    }

    public synchronized void createTemporary(final String dName, final boolean isQ, final int domain) throws JMSException {
        this.assertRegistered();
        this.execute(new Op(){

            public String name() {
                return "createTemporary";
            }

            public void sendRequest() throws Throwable {
                JMSRemoteServer.this.m_dout.writeInt(2002);
                JMSRemoteServer.this.m_dout.writeUTF(dName);
                JMSRemoteServer.this.m_dout.writeBoolean(isQ);
                JMSRemoteServer.this.m_dout.writeInt(domain);
            }

            public Object getReply() throws Throwable {
                JMSRemoteServer.this.processFlag(this);
                return null;
            }
        });
    }

    public synchronized void deleteTemporary(final String dName) throws JMSException {
        this.assertRegistered();
        this.execute(new Op(){

            public String name() {
                return "deleteTemporary";
            }

            public void sendRequest() throws Throwable {
                JMSRemoteServer.this.m_dout.writeInt(2003);
                JMSRemoteServer.this.m_dout.writeUTF(dName);
            }

            public Object getReply() throws Throwable {
                JMSRemoteServer.this.processFlag(this);
                return null;
            }
        });
    }

    public synchronized void commit(final SessionID sessionID) throws JMSException {
        this.assertRegistered();
        this.execute(new Op(){
            boolean commitAttempted;
            Op txnRollback;

            public String name() {
                return "commit";
            }

            public void sendRequest() throws Throwable {
                if (!sessionID.isXA() && (JMSRemoteServer.this.m_badSess.contains(sessionID) || this.commitAttempted) && this.txnRollback == null) {
                    this.txnRollback = JMSRemoteServer.this.rollbackOp(sessionID);
                }
                this.commitAttempted = true;
                if (this.txnRollback != null) {
                    JMSRemoteServer.this.m_sess.remove(sessionID);
                    JMSRemoteServer.this.m_badSess.remove(sessionID);
                    try {
                        this.txnRollback.sendRequest();
                    }
                    catch (Throwable ex) {
                        s_traceLogger.throwing("doRollbackOnly", ex);
                    }
                } else {
                    JMSRemoteServer.this.m_dout.writeInt(3000);
                    sessionID.writeTo(JMSRemoteServer.this.m_protocol, JMSRemoteServer.this.m_dout);
                    JMSRemoteServer.this.m_sess.remove(sessionID);
                    JMSRemoteServer.this.m_badSess.remove(sessionID);
                }
            }

            public Object getReply() throws Throwable {
                if (this.txnRollback != null) {
                    try {
                        this.txnRollback.getReply();
                    }
                    catch (Throwable ex) {
                        s_traceLogger.throwing("doRollbackOnly", ex);
                    }
                    throw new TransactionRolledBackException(JMSMessages.getMessage("J2EE JMS-02405", this, sessionID));
                }
                JMSRemoteServer.this.processFlag(this);
                return null;
            }
        });
    }

    public synchronized void rollback(SessionID sessionID) throws JMSException {
        this.assertRegistered();
        this.m_sess.remove(sessionID);
        this.m_badSess.remove(sessionID);
        this.execute(this.rollbackOp(sessionID));
    }

    private Op rollbackOp(final SessionID sessionID) {
        return new Op(){

            public String name() {
                return "rollback";
            }

            public void sendRequest() throws Throwable {
                JMSRemoteServer.this.m_dout.writeInt(3001);
                sessionID.writeTo(JMSRemoteServer.this.m_protocol, JMSRemoteServer.this.m_dout);
            }

            public Object getReply() throws Throwable {
                JMSRemoteServer.this.processFlag(this);
                return null;
            }
        };
    }

    public synchronized void prepareX(final SessionID sessionID) throws JMSException {
        this.assertRegistered();
        this.execute(new Op(){

            public String name() {
                return "prepareX";
            }

            public void sendRequest() throws Throwable {
                JMSRemoteServer.this.m_dout.writeInt(3002);
                sessionID.writeTo(JMSRemoteServer.this.m_protocol, JMSRemoteServer.this.m_dout);
            }

            public Object getReply() throws Throwable {
                JMSRemoteServer.this.processFlag(this);
                return null;
            }
        });
    }

    public synchronized SessionID[] recoverX() throws JMSException {
        this.assertRegistered();
        return (SessionID[])this.execute(new Op(){

            public String name() {
                return "recoverX";
            }

            public void sendRequest() throws Throwable {
                JMSRemoteServer.this.m_dout.writeInt(3003);
            }

            public Object getReply() throws Throwable {
                return JMSRemoteServer.this.getObject(this);
            }
        });
    }

    public synchronized int createConsumer(String dName, String name, String selector, boolean noLocal) throws JMSException {
        this.assertRegistered();
        Integer ret = (Integer)this.execute(this.createConsumerOp(dName, name, selector, noLocal));
        this.m_cons.put(ret, new Consumer(dName, name, selector, noLocal));
        this.m_consMap.remove(ret);
        return ret;
    }

    protected Op createConsumerOp(final String dName, final String name, final String selector, final boolean noLocal) {
        return new Op(){

            public String name() {
                return "createConsumer";
            }

            public void sendRequest() throws Throwable {
                JMSRemoteServer.this.m_dout.writeInt(4000);
                JMSRemoteServer.this.m_dout.writeUTF(dName);
                JMSRemoteServer.this.m_dout.writeUTF(JMSUtils.fold(name));
                JMSRemoteServer.this.m_dout.writeUTF(JMSUtils.fold(selector));
                JMSRemoteServer.this.m_dout.writeBoolean(noLocal);
            }

            public Object getReply() throws Throwable {
                JMSRemoteServer.this.processFlag(this);
                return new Integer(JMSRemoteServer.this.m_dinp.readInt());
            }
        };
    }

    public synchronized void closeConsumer(final int consID) throws JMSException {
        this.assertRegistered();
        this.execute(new Op(){

            public String name() {
                return "closeConsumer";
            }

            public void sendRequest() throws Throwable {
                Integer mapping = (Integer)JMSRemoteServer.this.m_consMap.get(new Integer(consID));
                int actualConsID = mapping == null ? consID : mapping;
                JMSRemoteServer.this.m_dout.writeInt(4001);
                JMSRemoteServer.this.m_dout.writeInt(actualConsID);
            }

            public Object getReply() throws Throwable {
                JMSRemoteServer.this.processFlag(this);
                return null;
            }
        });
        Integer id = new Integer(consID);
        this.m_cons.remove(id);
        this.m_consMap.remove(id);
    }

    public synchronized void unsubscribe(final String name) throws JMSException {
        this.assertRegistered();
        this.execute(new Op(){

            public String name() {
                return "unsubscribe";
            }

            public void sendRequest() throws Throwable {
                JMSRemoteServer.this.m_dout.writeInt(4002);
                JMSRemoteServer.this.m_dout.writeUTF(name);
            }

            public Object getReply() throws Throwable {
                JMSRemoteServer.this.processFlag(this);
                return null;
            }
        });
    }

    public synchronized List listMessages(final String dName, final String name, final SessionID sessionID, final String selector) throws JMSException {
        this.assertRegistered();
        return (List)this.execute(new Op(){

            public String name() {
                return "listMessages";
            }

            public void sendRequest() throws Throwable {
                JMSRemoteServer.this.m_dout.writeInt(5000);
                JMSRemoteServer.this.m_dout.writeUTF(dName);
                JMSRemoteServer.this.m_dout.writeUTF(JMSUtils.fold(name));
                sessionID.writeTo(JMSRemoteServer.this.m_protocol, JMSRemoteServer.this.m_dout);
                JMSRemoteServer.this.m_dout.writeUTF(JMSUtils.fold(selector));
            }

            public Object getReply() throws Throwable {
                return JMSRemoteServer.this.getObject(this);
            }
        });
    }

    public synchronized EvermindMessage peekMessage(final String dName, final String name, final String msgID) throws JMSException {
        this.assertRegistered();
        return (EvermindMessage)this.execute(new Op(){

            public String name() {
                return "peekMessage";
            }

            public void sendRequest() throws Throwable {
                JMSRemoteServer.this.m_dout.writeInt(5001);
                JMSRemoteServer.this.m_dout.writeUTF(dName);
                JMSRemoteServer.this.m_dout.writeUTF(JMSUtils.fold(name));
                JMSRemoteServer.this.m_dout.writeUTF(msgID);
            }

            public Object getReply() throws Throwable {
                return JMSRemoteServer.this.getMessage(this);
            }
        });
    }

    public synchronized void enqMessage(final String dName, final SessionID sessionID, final boolean keepState, final EvermindMessage msg, final boolean isXA) throws JMSException {
        this.assertRegistered();
        this.execute(new Op(){

            public String name() {
                return "enqMessage";
            }

            public void sendRequest() throws Throwable {
                JMSRemoteServer.this.m_dout.writeInt(6000);
                JMSRemoteServer.this.m_dout.writeUTF(dName);
                sessionID.writeTo(JMSRemoteServer.this.m_protocol, JMSRemoteServer.this.m_dout);
                JMSRemoteServer.this.m_dout.writeBoolean(keepState);
                msg.writeTo(JMSRemoteServer.this.m_dout);
                JMSRemoteServer.this.m_dout.writeBoolean(isXA);
            }

            public Object getReply() throws Throwable {
                JMSRemoteServer.this.processFlag(this);
                return null;
            }
        });
        if (keepState && !isXA) {
            this.m_sess.add(sessionID);
        }
    }

    public synchronized EvermindMessage deqMessage(final int consID, final SessionID sessionID, final String txid, final boolean keepState, final boolean isXA) throws JMSException {
        this.assertRegistered();
        EvermindMessage ret = (EvermindMessage)this.execute(new Op(){

            public String name() {
                return "deqMessage";
            }

            public void sendRequest() throws Throwable {
                Integer mapping = (Integer)JMSRemoteServer.this.m_consMap.get(new Integer(consID));
                int actualConsID = mapping == null ? consID : mapping;
                JMSRemoteServer.this.m_dout.writeInt(6001);
                JMSRemoteServer.this.m_dout.writeInt(actualConsID);
                sessionID.writeTo(JMSRemoteServer.this.m_protocol, JMSRemoteServer.this.m_dout);
                JMSRemoteServer.this.m_dout.writeUTF(JMSUtils.fold(txid));
                JMSRemoteServer.this.m_dout.writeBoolean(keepState);
                JMSRemoteServer.this.m_dout.writeBoolean(isXA);
            }

            public Object getReply() throws Throwable {
                return JMSRemoteServer.this.getMessage(this);
            }
        });
        if (keepState && !isXA) {
            this.m_sess.add(sessionID);
        }
        return ret;
    }

    protected static JMSServerProxy getProxy() {
        return JMSServerProxy.getProxy();
    }

    protected void processFlag(Op op) throws Throwable {
        int status = this.m_dinp.readInt();
        if (status != 1234) {
            if (status == 4321) {
                JMSException remoteEx = (JMSException)((Object)JMSUtils.read(this.m_dinp));
                JMSUtils.initCause(remoteEx, (Throwable)JMSUtils.clone((Serializable)((Object)remoteEx)));
                throw remoteEx.fillInStackTrace();
            }
            JMSUtils.toIOException(JMSMessages.getMessage("J2EE JMS-02404", this, op.name(), new Integer(status)));
        }
    }

    private Object getObject(Op op) throws Throwable {
        this.processFlag(op);
        if (this.m_dinp.readBoolean()) {
            return JMSUtils.read(this.m_dinp);
        }
        return null;
    }

    private Object getMessage(Op op) throws Throwable {
        this.processFlag(op);
        if (this.m_dinp.readBoolean()) {
            return EvermindMessage.readMessage(this.m_dinp);
        }
        return null;
    }

    protected abstract Object execute(Op var1) throws JMSException;

    protected void sendRequest(Op op) throws Throwable {
        op.sendRequest();
        this.m_dout.flush();
    }

    protected Object readResponse(Op op) throws Throwable {
        return op.getReply();
    }

    private void assertNew() throws JMSException {
        if (this.connectionState != 0) {
            JMSUtils.toJMSException(JMSMessages.getMessage("J2EE JMS-02400", this));
        }
    }

    private void assertRegistered() throws JMSException {
        if (this.connectionState != 1) {
            JMSUtils.toJMSException(JMSMessages.getMessage("J2EE JMS-02401", this));
        }
    }

    private void readCheck(String what, int val) throws Throwable {
        this.readCheck(what, val, 0);
    }

    private void readCheck(String what, int val, int base) throws Throwable {
        int ret = this.m_dinp.readInt();
        if (ret != val) {
            JMSUtils.toJMSException(JMSMessages.getMessage("J2EE JMS-02402", this, what, new Integer(3), new Integer(3)));
        }
    }

    protected void sendProtocol(int protocol) throws Throwable {
        this.m_dout.writeInt(protocol);
        this.m_dout.writeInt(1);
        this.m_dout.writeInt(0);
        this.m_dout.flush();
    }

    protected void readProtocol(int protocol) throws Throwable {
        this.readCheck("OC4J JMS protocol", protocol, -559038737);
        this.readCheck("JMS major version", 1);
        this.readCheck("JMS minor version", 0);
    }

    protected void sendLogin(String user, String pass) throws Throwable {
        this.m_dout.writeUTF(JMSUtils.fold(user));
        this.m_dout.writeUTF(JMSUtils.fold(pass));
        this.m_dout.flush();
    }

    protected void readLogin(String user) throws Throwable {
        int ok = this.m_dinp.readInt();
        if (ok != -1161901314) {
            JMSUtils.toJMSSecurityException(JMSMessages.getMessage("J2EE JMS-02403", this, user));
        }
    }

    protected static final class Consumer {
        private final String m_dName;
        private final String m_name;
        private final String m_selector;
        private final boolean m_noLocal;

        Consumer(String dName, String name, String selector, boolean noLocal) {
            this.m_dName = dName;
            this.m_name = name;
            this.m_selector = selector;
            this.m_noLocal = noLocal;
        }

        String getDestination() {
            return this.m_dName;
        }

        String getName() {
            return this.m_name;
        }

        String getSelector() {
            return this.m_selector;
        }

        boolean getNoLocal() {
            return this.m_noLocal;
        }
    }

    protected static abstract class Op {
        protected Op() {
        }

        public abstract String name();

        public abstract void sendRequest() throws Throwable;

        public abstract Object getReply() throws Throwable;
    }
}

