/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.jms;

import com.evermind.server.jms.JMSMessages;
import com.evermind.server.jms.JMSUtils;
import java.security.Permission;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;

public final class JMSPermission
extends Permission {
    private final Set m_dest;
    private final boolean m_enqueue;
    private final boolean m_dequeue;
    private final boolean m_browse;
    private final boolean m_subscribe;
    public static final String ENQUEUE = "enqueue";
    public static final String DEQUEUE = "dequeue";
    public static final String BROWSE = "browse";
    public static final String SUBSCRIBE = "subscribe";
    public static final String ALL = "all";
    public static final String STAR = "*";
    static final long serialVersionUID = -1214512935906846999L;

    public JMSPermission(String destination, String actions) {
        super(destination);
        if (JMSUtils.isNull(destination)) {
            JMSUtils.toRuntimeException(JMSMessages.getMessage("J2EE JMS-02250", destination));
        }
        this.m_dest = JMSPermission.tokenizeDestinations(destination);
        if (this.m_dest.contains(STAR)) {
            this.m_dest.clear();
            this.m_dest.add(STAR);
        }
        Set s = JMSPermission.tokenizeActions(actions);
        this.m_enqueue = s.contains(ENQUEUE);
        this.m_dequeue = s.contains(DEQUEUE);
        this.m_browse = s.contains(BROWSE);
        this.m_subscribe = s.contains(SUBSCRIBE);
    }

    public String toString() {
        return "JMSPermission[" + this.getDestinations() + "/" + this.getActions() + "]";
    }

    public boolean equals(Object o) {
        return o != null && o instanceof JMSPermission && this.compare((JMSPermission)o);
    }

    public String getActions() {
        return JMSPermission.pp(this.m_enqueue, ENQUEUE, JMSPermission.pp(this.m_dequeue, DEQUEUE, JMSPermission.pp(this.m_browse, BROWSE, JMSPermission.pp(this.m_subscribe, SUBSCRIBE, ""))));
    }

    public int hashCode() {
        return ((Object)this.m_dest).hashCode() + 3 * JMSPermission.toInt(this.m_enqueue) + 5 * JMSPermission.toInt(this.m_dequeue) + 7 * JMSPermission.toInt(this.m_browse) + 11 * JMSPermission.toInt(this.m_subscribe);
    }

    public boolean implies(Permission p) {
        return p != null && p instanceof JMSPermission && this.check((JMSPermission)p);
    }

    private static Set tokenizeDestinations(String dest) {
        HashSet<String> s = new HashSet<String>();
        StringTokenizer tok = new StringTokenizer(dest, ",");
        while (tok.hasMoreTokens()) {
            s.add(tok.nextToken());
        }
        return s;
    }

    private static Set tokenizeActions(String actions) {
        actions = JMSUtils.fold(actions).trim().toLowerCase();
        HashSet<String> s = new HashSet<String>();
        StringTokenizer tok = new StringTokenizer(actions, ",");
        while (tok.hasMoreTokens()) {
            String op = tok.nextToken().trim();
            if (ENQUEUE.equals(op) || DEQUEUE.equals(op) || BROWSE.equals(op) || SUBSCRIBE.equals(op)) {
                s.add(op);
                continue;
            }
            if (ALL.equals(op)) {
                s.add(ENQUEUE);
                s.add(DEQUEUE);
                s.add(BROWSE);
                s.add(SUBSCRIBE);
                continue;
            }
            JMSUtils.toRuntimeException(JMSMessages.getMessage("J2EE JMS-02251", actions, op));
        }
        return s;
    }

    private String getDestinations() {
        Object[] s = this.m_dest.toArray(new String[0]);
        Arrays.sort(s);
        Object ret = s[0];
        for (int i = 1; i < s.length; ++i) {
            ret = (String)ret + "," + (String)s[i];
        }
        return ret;
    }

    private static int toInt(boolean b) {
        return b ? 1 : 0;
    }

    private static String pp(boolean b, String msg, String s) {
        return b ? (JMSUtils.isNull(s) ? msg : msg + "," + s) : s;
    }

    private boolean compare(JMSPermission p) {
        return ((Object)this.m_dest).equals(p.m_dest) && this.m_enqueue == p.m_enqueue && this.m_dequeue == p.m_dequeue && this.m_browse == p.m_browse && this.m_subscribe == p.m_subscribe;
    }

    private boolean check(JMSPermission p) {
        return this.checkDestination(p.m_dest) && JMSPermission.checkP(this.m_enqueue, p.m_enqueue) && JMSPermission.checkP(this.m_dequeue, p.m_dequeue) && JMSPermission.checkP(this.m_browse, p.m_browse) && JMSPermission.checkP(this.m_subscribe, p.m_subscribe);
    }

    private static boolean checkP(boolean myP, boolean reqP) {
        return reqP ? myP : true;
    }

    private boolean checkDestination(Set d) {
        return this.m_dest.contains(STAR) || this.m_dest.containsAll(d);
    }
}

