/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.jms;

import com.evermind.server.jms.EvermindMessageProducer;
import com.evermind.server.jms.EvermindSession;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Topic;
import javax.jms.TopicPublisher;

public final class EvermindTopicPublisher
extends EvermindMessageProducer
implements TopicPublisher {
    EvermindTopicPublisher(EvermindSession sess, Topic t) throws JMSException {
        super(sess, (Destination)t, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Topic getTopic() throws JMSException {
        this.lock("getTopic");
        try {
            Topic topic = (Topic)this.getDestination();
            return topic;
        }
        finally {
            this.unlock();
        }
    }

    public synchronized void publish(Message msg) throws JMSException {
        this.send(msg);
    }

    public synchronized void publish(Message msg, int deliveryMode, int priority, long ttl) throws JMSException {
        this.send(msg, deliveryMode, priority, ttl);
    }

    public synchronized void publish(Topic t, Message msg) throws JMSException {
        this.send((Destination)t, msg);
    }

    public synchronized void publish(Topic t, Message msg, int deliveryMode, int priority, long ttl) throws JMSException {
        this.send((Destination)t, msg, deliveryMode, priority, ttl);
    }
}

