/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.jms;

import com.evermind.server.jms.ConnectInfo;
import com.evermind.server.jms.EvermindConnection;
import com.evermind.server.jms.JMSDomain;
import com.evermind.server.jms.JMSUtils;
import com.evermind.server.jms.SecureOperation;
import java.io.Serializable;
import java.net.InetAddress;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.JMSException;

public class EvermindConnectionFactory
extends ConnectInfo
implements Serializable,
ConnectionFactory,
JMSDomain {
    private final boolean m_isXA;
    private final int m_domain;
    static final long serialVersionUID = 2549357885827492329L;

    EvermindConnectionFactory(InetAddress addr, int port, String tunnel, String keystore, String keystorePassword, String truststore, String truststorePassword, String provider, String user, String pass, String clientID, boolean isXA) {
        this(addr, port, tunnel, keystore, keystorePassword, truststore, truststorePassword, provider, user, pass, clientID, isXA, 2);
    }

    EvermindConnectionFactory(InetAddress addr, int port, String tunnel, String keystore, String keystorePassword, String truststore, String truststorePassword, String provider, String user, String pass, String clientID, boolean isXA, int domain) {
        super(addr, port, tunnel, keystore, keystorePassword, truststore, truststorePassword, provider, user, pass, clientID);
        this.m_isXA = isXA;
        this.m_domain = domain;
    }

    public String toString() {
        return JMSUtils.pp(this.m_isXA, this.m_domain) + "ConnectionFactory" + "[" + this.getAddr() + "," + this.getPort() + "," + this.getUser() + "," + this.getClientID() + "]";
    }

    public final synchronized Connection createConnection() throws JMSException {
        return this.createConnection(this.getUser(), this.getPass());
    }

    public final synchronized Connection createConnection(final String user, final String pass) throws JMSException {
        Connection conn = null;
        try {
            conn = (Connection)this.getProxy().doSecureOp(new SecureOperation(){

                public Object execute() throws Exception {
                    return EvermindConnectionFactory.this.unprivileged_createConnection(user, pass);
                }
            });
        }
        catch (JMSException jex) {
            throw jex;
        }
        catch (RuntimeException rex) {
            throw rex;
        }
        catch (Exception ex) {
            JMSUtils.toJMSSecurityException(ex.getMessage());
        }
        return conn;
    }

    private Connection unprivileged_createConnection(String user, String pass) throws JMSException {
        return new EvermindConnection(this.getAddr(), this.getPort(), this.getTunnel(), this.getKeystore(), this.getKeystorePassword(), this.getTruststore(), this.getTruststorePassword(), this.getProvider(), user, pass, this.getClientID(), false, 2);
    }

    public final synchronized boolean isXA() {
        return this.m_isXA;
    }

    public final synchronized int getDomain() {
        return this.m_domain;
    }
}

