/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.jms;

import com.evermind.server.jms.EvermindConnection;
import com.evermind.server.jms.EvermindDestination;
import com.evermind.server.jms.EvermindMessageConsumer;
import com.evermind.server.jms.EvermindSession;
import com.evermind.server.jms.JMSMessages;
import com.evermind.server.jms.JMSObject;
import com.evermind.server.jms.JMSUtils;
import com.evermind.server.jms.MessageSelector;
import javax.jms.ConnectionConsumer;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.ServerSession;
import javax.jms.ServerSessionPool;
import javax.jms.Session;
import javax.jms.Topic;

public final class EvermindConnectionConsumer
extends JMSObject
implements ConnectionConsumer,
Runnable {
    private final EvermindConnection m_conn;
    private final Destination m_dest;
    private final String m_name;
    private final String m_selector;
    private final ServerSessionPool m_pool;
    private final int m_msgs;
    private final Thread m_thr;
    private ServerSession m_svrSess = null;
    private EvermindSession m_sess = null;
    private EvermindMessageConsumer m_cons = null;
    private int m_totMsgs = 0;

    EvermindConnectionConsumer(EvermindConnection conn, Destination dest, String name, String selector, ServerSessionPool pool, int maxMessages) throws JMSException {
        super("ConnectionConsumer", conn);
        EvermindDestination.checkDestination(dest);
        if (!JMSUtils.isNull(selector)) {
            MessageSelector.getSelector(selector);
        }
        this.m_conn = conn;
        this.m_dest = dest;
        this.m_name = name;
        this.m_selector = selector;
        this.m_pool = pool;
        this.m_msgs = maxMessages;
        this.m_conn.attach(this);
        this.m_thr = new Thread(this);
        this.m_thr.setDaemon(true);
        this.m_thr.start();
        this.state("destination", JMSUtils.getName(this.m_dest), true);
        this.state("name", JMSUtils.fold(this.m_name), true);
        this.state("selector", JMSUtils.fold(this.m_selector), true);
        this.state("maxMessages", new Integer(this.m_msgs), true);
        this.state("totalMessages", new Integer(this.m_totMsgs));
        EvermindConnectionConsumer.getProxy().setJMSConnectionConsumerMBean(this.getJMSStats(), this, this.m_conn, JMSUtils.getName(this.m_dest), JMSUtils.fold(this.m_name), JMSUtils.fold(this.m_selector), this.m_msgs);
    }

    public String toString() {
        String n = JMSUtils.isNull(this.m_name) ? "" : "," + this.m_name;
        return "ConnectionConsumer[" + this.m_dest + n + "]";
    }

    protected void localClose() throws JMSException {
        JMSUtils.closeIt(this.m_cons);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Thread.currentThread().setName(this.toString());
        long delay = 1L;
        while (true) {
            boolean ok = false;
            EvermindConnectionConsumer evermindConnectionConsumer = this;
            synchronized (evermindConnectionConsumer) {
                if (!this.isOpen()) {
                    break;
                }
                try {
                    this.beforeDelivery();
                    ok = this.loadMessages();
                    this.afterDelivery(ok);
                }
                catch (Throwable ex) {
                    JMSMessages.severeConnectionConsumerRunError(this, ex);
                }
            }
            delay = JMSUtils.delaySome(delay, ok);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized ServerSessionPool getServerSessionPool() throws JMSException {
        this.lock("getServerSessionPool");
        try {
            ServerSessionPool serverSessionPool = this.m_pool;
            return serverSessionPool;
        }
        finally {
            this.unlock();
        }
    }

    private void beforeDelivery() throws JMSException {
        this.getServerSession();
        this.getSession();
        this.getConsumer();
    }

    private void afterDelivery(boolean ok) throws JMSException {
        if (ok) {
            JMSUtils.closeIt(this.m_cons);
            ServerSession svrSess = this.m_svrSess;
            this.m_cons = null;
            this.m_sess = null;
            this.m_svrSess = null;
            if (svrSess != null) {
                svrSess.start();
            }
        }
    }

    private void getServerSession() throws JMSException {
        if (this.m_svrSess != null) {
            return;
        }
        this.m_svrSess = this.m_pool.getServerSession();
    }

    private void getSession() {
        if (this.m_sess != null || this.m_svrSess == null) {
            return;
        }
        try {
            Session s = this.m_svrSess.getSession();
            if (!(s instanceof EvermindSession)) {
                JMSMessages.severeAlienSessionType(this, s);
                return;
            }
            EvermindSession sess = (EvermindSession)s;
            if (sess.getConnection() != this.m_conn) {
                JMSMessages.severeConnectionMismatch(this, this.m_conn, sess, sess.getConnection());
                return;
            }
            this.m_sess = sess;
        }
        catch (Throwable ex) {
            JMSMessages.severeCannotGetSession(this.m_svrSess, ex);
        }
    }

    private void getConsumer() {
        if (this.m_cons != null || this.m_sess == null) {
            return;
        }
        try {
            this.m_cons = JMSUtils.isNull(this.m_name) ? (EvermindMessageConsumer)this.m_sess.createConsumer(this.m_dest, this.m_selector) : (EvermindMessageConsumer)this.m_sess.createDurableSubscriber((Topic)this.m_dest, this.m_name, this.m_selector, false);
        }
        catch (Throwable ex) {
            JMSMessages.severeCannotCreateConsumer(this.m_dest, this.m_selector, ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean loadMessages() {
        if (this.m_sess == null) return true;
        if (this.m_cons == null) {
            return true;
        }
        try {
            this.lock("loadMessages");
            try {
                EvermindSession evermindSession = this.m_sess;
                synchronized (evermindSession) {
                    boolean bl = this.load();
                    return bl;
                }
            }
            finally {
                this.unlock();
            }
        }
        catch (Throwable ex) {
            JMSMessages.severeCannotLoadMessage(this.m_cons, this.m_sess, ex);
            return true;
        }
    }

    private boolean load() throws JMSException {
        Message msg;
        if (this.m_sess.getMessageListener() == null) {
            JMSUtils.toJMSException(JMSMessages.getMessage("J2EE JMS-01302", this, this.m_sess));
            return true;
        }
        int nmsgs = 0;
        while (nmsgs < this.m_msgs && (msg = this.m_cons.receive(JMSUtils.getMessagePoll())) != null) {
            this.m_sess.loadMessage(msg);
            ++nmsgs;
            ++this.m_totMsgs;
        }
        this.state("totalMessages", new Integer(this.m_totMsgs));
        return nmsgs > 0;
    }

    public int getTotalMessages() {
        return this.m_totMsgs;
    }
}

