/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.http.deployment;

import com.evermind.server.deployment.IconDescriptor;
import com.evermind.util.AbstractDescribable;
import com.evermind.util.ConfigUtils;
import com.evermind.util.OrderedSet;
import com.evermind.util.PropertyContainer;
import com.evermind.xml.XMLUtils;
import com.evermind.xml.XMLizable;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class WebComponentDescriptor
extends AbstractDescribable
implements XMLizable,
PropertyContainer {
    private String className;
    private IconDescriptor icon;
    private Properties parameters;
    private Properties parameterDescriptions;
    private String canonicalName;
    private String implFile = "";
    private boolean isServlet = true;
    private Set urlPatterns;
    private Method postConstructMethod = null;
    private Method preDestroyMethod = null;

    public void setPostConstructMethod(Method method) {
        this.postConstructMethod = method;
    }

    public Method getPostConstructMethod() {
        return this.postConstructMethod;
    }

    public void setPreDestroyMethod(Method method) {
        this.preDestroyMethod = method;
    }

    public Method getPreDestroyMethod() {
        return this.preDestroyMethod;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public String getClassName() {
        return this.className;
    }

    public void setIcon(IconDescriptor icon) {
        this.icon = icon;
    }

    public IconDescriptor getIcon() {
        return this.icon;
    }

    public Properties getInitParameters() {
        if (this.parameters == null) {
            this.parameters = new Properties();
        }
        return this.parameters;
    }

    public boolean hasInitParameters() {
        return this.parameters != null && !this.parameters.isEmpty();
    }

    public int getPropertyCount() {
        return this.parameters == null ? 0 : this.parameters.size();
    }

    public Iterator getPropertyNames() {
        return this.parameters == null ? Collections.EMPTY_LIST.iterator() : this.parameters.keySet().iterator();
    }

    public String getProperty(String name) {
        return this.parameters == null ? null : this.parameters.getProperty(name);
    }

    public void setProperty(String name, String value) {
        this.getInitParameters().setProperty(name, value);
        this.firePropertyChangeEvent("properties", value, value);
    }

    public void writeInitParams(PrintWriter out, String indention) {
        if (this.hasInitParameters()) {
            Iterator<Map.Entry<Object, Object>> iterator = this.getInitParameters().entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<Object, Object> entry = iterator.next();
                String description = this.getInitParamDescriptions().getProperty(entry.getKey().toString());
                out.println(indention + "<init-param>");
                out.println(indention + "\t<param-name>" + XMLUtils.encode(entry.getKey().toString()) + "</param-name>");
                out.println(indention + "\t<param-value>" + XMLUtils.encode(entry.getValue().toString()) + "</param-value>");
                if (description != null) {
                    out.println(indention + "\t<description>" + XMLUtils.encode(description) + "</description>");
                }
                out.println(indention + "</init-param>");
            }
        }
    }

    public void writeWebAppInitParams(PrintWriter out, String indention) {
        if (this.hasInitParameters()) {
            Iterator<Map.Entry<Object, Object>> iterator = this.getInitParameters().entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<Object, Object> entry = iterator.next();
                out.println(indention + "<init-param>");
                String description = this.getInitParamDescriptions().getProperty(entry.getKey().toString());
                this.writeXMLElement(out, indention, "description", description);
                this.writeXMLElement(out, indention, "param-name", entry.getKey().toString());
                this.writeXMLElement(out, indention, "param-value", entry.getValue().toString());
                out.println(indention + "</init-param>");
            }
        }
    }

    public void remove(String name) {
        this.getInitParameters().remove(name);
        this.firePropertyChangeEvent("properties", name, null);
    }

    public void addInitParameter(String name, String value) {
        this.getInitParameters().put(name, value);
        this.firePropertyChangeEvent("initParameters", null, name);
    }

    protected void parseInitParameter(Node node, URL url, boolean relative) throws InstantiationException {
        String paramDescription;
        String paramValue;
        String paramName;
        block15: {
            NodeList nodes = node.getChildNodes();
            paramName = null;
            paramValue = null;
            paramDescription = null;
            for (int i = 0; i < nodes.getLength(); ++i) {
                String name = nodes.item(i).getNodeName();
                if (name.startsWith("#")) continue;
                if (name.equals("param-name")) {
                    if (paramName != null) {
                        throw new InstantiationException("Duplicate param-name subtag in init-param tag");
                    }
                    paramName = XMLUtils.getStringValue(nodes.item(i));
                    continue;
                }
                if (name.equals("param-value")) {
                    if (paramValue != null) {
                        throw new InstantiationException("Duplicate param-value subtag in init-param tag");
                    }
                    paramValue = XMLUtils.getStringValue(nodes.item(i));
                    continue;
                }
                if (name.equals("description")) {
                    if (paramDescription != null) {
                        throw new InstantiationException("Duplicate description subtag in init-param tag");
                    }
                    paramDescription = XMLUtils.getStringValue(nodes.item(i));
                    continue;
                }
                throw new InstantiationException("Unknown init-param subtag: " + name);
            }
            if (relative && paramValue != null) {
                try {
                    URL paramURL = ConfigUtils.getURL(url, paramValue);
                    if (paramURL.getProtocol().equalsIgnoreCase("file")) {
                        File file = new File(paramURL.getFile());
                        try {
                            file = file.getCanonicalFile();
                        }
                        catch (IOException e) {
                            // empty catch block
                        }
                        paramValue = file.getPath();
                        break block15;
                    }
                    paramValue = paramURL.toExternalForm();
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
        if (paramName != null && paramValue != null) {
            this.getInitParameters().put(paramName, paramValue);
            if (paramDescription != null) {
                this.getInitParamDescriptions().put(paramName, paramDescription);
            }
        }
    }

    public Set getKnownKeys() {
        return new HashSet();
    }

    public Properties getInitParamDescriptions() {
        if (this.parameterDescriptions == null) {
            this.parameterDescriptions = new Properties();
        }
        return this.parameterDescriptions;
    }

    public void writeXML(PrintWriter out, String indention) throws IOException {
    }

    public String getCanonicalName() {
        if (this.canonicalName == null) {
            this.canonicalName = this.getName();
        }
        return this.canonicalName;
    }

    public void setCanonicalName(String canonicalName) {
        this.canonicalName = canonicalName;
    }

    public void setWebComponentImplementation(String implFile) {
        if (!this.isServlet && !implFile.startsWith("/")) {
            implFile = "/" + implFile;
        }
        this.implFile = implFile;
    }

    public String getWebComponentImplementation() {
        return this.implFile;
    }

    public boolean isServlet() {
        return this.isServlet;
    }

    public void setServlet(boolean isServlet) {
        this.isServlet = isServlet;
    }

    public Set getUrlPatternsSet() {
        if (this.urlPatterns == null) {
            this.urlPatterns = new OrderedSet();
        }
        return this.urlPatterns;
    }

    protected void writeXMLElement(PrintWriter out, String indention, String tag, String value) {
        if (value != null) {
            out.println(indention + "\t<" + tag + ">" + XMLUtils.encode(value) + "</" + tag + ">");
        }
    }
}

