/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.http.deployment;

import com.evermind.server.http.deployment.HttpApplicationDescriptor;
import com.evermind.server.http.deployment.ServletMapping;
import com.evermind.server.http.deployment.TagLibraryUse;
import com.evermind.xml.XMLUtils;
import com.evermind.xml.XMLizable;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class JspConfigDescriptor
implements XMLizable {
    private static final String CR = System.getProperty("line.separator", "\n");
    HttpApplicationDescriptor config;
    List taglibs;
    List properties;

    public JspConfigDescriptor(HttpApplicationDescriptor config) {
        this.config = config;
        this.taglibs = new ArrayList();
        this.properties = new ArrayList();
    }

    public JspConfigDescriptor(HttpApplicationDescriptor config, Node node) {
        this(config);
        this.parseJspConfig(node);
    }

    public List getTaglibs() {
        return this.taglibs;
    }

    public List getProperties() {
        return this.properties;
    }

    public void addImplicitTagLibrary(String uri, String location) {
        this.config.addTagLibrary(new JspConfigImplicitTagLibrary(uri, location));
    }

    public void addImplicitServletMapping(String servletName, String urlPattern, JspPropertyGroup propgroup) {
        if (servletName != null) {
            this.config.addServletMapping(new JspConfigImplicitServletMapping(servletName, urlPattern, propgroup));
        }
    }

    public void writeXML(PrintWriter out, String indention) throws IOException {
        out.println(indention + "<jsp-config>");
        Iterator i = this.taglibs.iterator();
        while (i.hasNext()) {
            TagLibrary taglib = (TagLibrary)i.next();
            out.println(taglib.toXML(indention + "\t"));
        }
        i = this.properties.iterator();
        while (i.hasNext()) {
            JspPropertyGroup propgroup = (JspPropertyGroup)i.next();
            out.println(propgroup.toXML(indention + "\t"));
        }
        out.println(indention + "</jsp-config>");
    }

    private void parseJspConfig(Node parent) {
        int parse_order = 0;
        NodeList nodes = parent.getChildNodes();
        String jspServletName = null;
        Iterator i = this.config.getServletMappings().iterator();
        while (i.hasNext()) {
            ServletMapping mapping = (ServletMapping)i.next();
            if (!mapping.getURLPattern().equals("*.jsp")) continue;
            jspServletName = mapping.getServletName();
            break;
        }
        String publicId = "";
        if (this.config != null && this.config.getDoctype() != null) {
            publicId = this.config.getDoctype().getPublicId();
        }
        if (nodes != null) {
            for (int i2 = 0; i2 < nodes.getLength(); ++i2) {
                String subNodeValue;
                String subNodeName;
                Node subNode;
                NodeList subNodes;
                Node node = nodes.item(i2);
                String name = node.getNodeName();
                if (name.charAt(0) == '#') continue;
                if (name.equals("taglib")) {
                    subNodes = node.getChildNodes();
                    if (subNodes == null) continue;
                    TagLibrary taglib = new TagLibrary();
                    for (int x = 0; x < subNodes.getLength(); ++x) {
                        subNode = subNodes.item(x);
                        subNodeName = subNode.getNodeName();
                        subNodeValue = XMLUtils.getStringValue(subNode);
                        if (subNodeName.charAt(0) == '#') continue;
                        if (subNodeName.equals("taglib-uri")) {
                            taglib.uri = subNodeValue;
                            continue;
                        }
                        if (!subNodeName.equals("taglib-location")) continue;
                        taglib.location = subNodeValue;
                    }
                    if (!taglib.isValid()) continue;
                    this.taglibs.add(taglib);
                    this.addImplicitTagLibrary(taglib.uri, taglib.location);
                    continue;
                }
                if (!name.equals("jsp-property-group") || (subNodes = node.getChildNodes()) == null) continue;
                JspPropertyGroup propgroup = new JspPropertyGroup();
                propgroup.elIgnored = publicId.equals("-//Sun Microsystems, Inc.//DTD Web Application 2.2//EN") || publicId.equals("-//Sun Microsystems, Inc.//DTD Web Application 2.3//EN");
                for (int x = 0; x < subNodes.getLength(); ++x) {
                    subNode = subNodes.item(x);
                    subNodeName = subNode.getNodeName();
                    subNodeValue = XMLUtils.getStringValue(subNode);
                    if (subNodeName.charAt(0) == '#') continue;
                    if (subNodeName.equals("url-pattern")) {
                        propgroup.urlPatterns.add(subNodeValue);
                        continue;
                    }
                    if (subNodeName.equals("el-ignored")) {
                        propgroup.elIgnored = Boolean.valueOf(subNodeValue);
                        continue;
                    }
                    if (subNodeName.equals("page-encoding")) {
                        propgroup.pageEncoding = subNodeValue;
                        continue;
                    }
                    if (subNodeName.equals("scripting-invalid")) {
                        propgroup.scriptingInvalid = Boolean.valueOf(subNodeValue);
                        continue;
                    }
                    if (subNodeName.equals("is-xml")) {
                        propgroup.isXML = Boolean.valueOf(subNodeValue);
                        continue;
                    }
                    if (subNodeName.equals("include-prelude")) {
                        propgroup.includePrelude.add(subNodeValue);
                        continue;
                    }
                    if (!subNodeName.equals("include-coda")) continue;
                    propgroup.includeCoda.add(subNodeValue);
                }
                if (!propgroup.isValid()) continue;
                propgroup.order = parse_order++;
                this.properties.add(propgroup);
                Iterator j = propgroup.urlPatterns.iterator();
                while (j.hasNext()) {
                    this.addImplicitServletMapping(jspServletName, (String)j.next(), propgroup);
                }
            }
        }
    }

    public static class JspConfigImplicitServletMapping
    extends ServletMapping {
        protected JspPropertyGroup propgroup;

        public JspConfigImplicitServletMapping(String servletName, String urlPattern, JspPropertyGroup propgroup) {
            this.servletName = servletName;
            this.urlPattern = urlPattern;
            this.propgroup = propgroup;
        }

        public JspPropertyGroup getJspPropertyGroup() {
            return this.propgroup;
        }

        public void writeXML(PrintWriter out, String indention) {
        }
    }

    public static class JspConfigImplicitTagLibrary
    extends TagLibraryUse {
        public JspConfigImplicitTagLibrary(String uri, String location) {
            this.uri = uri;
            this.location = location;
        }

        public void writeXML(PrintWriter out, String indention) {
        }
    }

    public static class TagLibrary {
        public String uri = null;
        public String location = null;

        public TagLibrary() {
        }

        public TagLibrary(String uri, String location) {
            this.uri = uri;
            this.location = location;
        }

        public boolean isValid() {
            return this.uri != null && this.location != null;
        }

        public String toXML(String indent) {
            StringBuffer buffer = new StringBuffer();
            buffer.append(indent + "<taglib>" + CR);
            buffer.append(indent + "\t<taglib-uri>" + this.uri + "</taglib-uri>" + CR);
            buffer.append(indent + "\t<taglib-location>" + this.location + "</taglib-location>" + CR);
            buffer.append(indent + "</taglib>");
            return buffer.toString();
        }
    }

    public static class JspPropertyGroup
    implements Comparable,
    Serializable {
        public List urlPatterns = new ArrayList();
        public boolean elIgnored = false;
        public String pageEncoding = "";
        public boolean scriptingInvalid = false;
        public List includePrelude = new ArrayList();
        public List includeCoda = new ArrayList();
        public Boolean isXML = null;
        public int order = 0;

        public boolean isValid() {
            return true;
        }

        public int compareTo(Object o) {
            JspPropertyGroup other = (JspPropertyGroup)o;
            return this.order > other.order ? 1 : -1;
        }

        public String toXML(String indent) {
            StringBuffer buffer = new StringBuffer();
            buffer.append(indent + "<jsp-property-group>" + CR);
            Iterator i = this.urlPatterns.iterator();
            while (i.hasNext()) {
                buffer.append(indent + "\t<url-pattern>" + (String)i.next() + "</url-pattern>" + CR);
            }
            buffer.append(indent + "\t<el-ignored>" + this.elIgnored + "</el-ignored>" + CR);
            if (!this.pageEncoding.equals("")) {
                buffer.append(indent + "\t<page-encoding>" + this.pageEncoding + "</page-encoding>" + CR);
            }
            if (this.scriptingInvalid) {
                buffer.append(indent + "\t<scripting-invalid>" + this.scriptingInvalid + "</scripting-invalid>" + CR);
            }
            if (this.isXML != null) {
                buffer.append(indent + "\t<is-xml>" + this.isXML + "</is-xml>" + CR);
            }
            i = this.includePrelude.iterator();
            while (i.hasNext()) {
                buffer.append(indent + "\t<include-prelude>" + (String)i.next() + "</include-prelude>" + CR);
            }
            i = this.includeCoda.iterator();
            while (i.hasNext()) {
                buffer.append(indent + "\t<include-coda>" + (String)i.next() + "</include-coda>" + CR);
            }
            buffer.append(indent + "</jsp-property-group>");
            return buffer.toString();
        }
    }
}

