/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.http.deployment;

import com.evermind.xml.XMLUtils;
import com.evermind.xml.XMLizable;
import java.io.PrintWriter;
import java.io.Serializable;

public class ErrorPage
implements Serializable,
XMLizable {
    protected int errorCode = -1;
    protected String exceptionType;
    protected String location;

    public ErrorPage() {
    }

    public ErrorPage(int errorCode, String exceptionType, String location) {
        this.errorCode = errorCode;
        this.exceptionType = exceptionType;
        this.location = location;
    }

    public int getErrorCode() {
        return this.errorCode;
    }

    public String getExceptionType() {
        return this.exceptionType;
    }

    public String getLocation() {
        return this.location;
    }

    public void writeXML(PrintWriter out, String indention) {
        out.println(indention + "<error-page>");
        if (this.exceptionType != null) {
            out.println(indention + "\t<exception-type>" + XMLUtils.encode(this.exceptionType) + "</exception-type>");
        } else if (this.errorCode != 0) {
            out.println(indention + "\t<error-code>" + this.errorCode + "</error-code>");
        } else {
            out.println(indention + "\t<error-code>501</error-code>");
        }
        if (this.location != null) {
            out.println(indention + "\t<location>" + XMLUtils.encode(this.location) + "</location>");
        }
        out.println(indention + "</error-page>");
    }

    public void setErrorCode(int code) {
        this.exceptionType = null;
        this.errorCode = code;
    }

    public void setExceptionType(String type) {
        this.errorCode = -1;
        this.exceptionType = type;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("error-page: ");
        buf.append("\n");
        buf.append("  errorCode: ");
        buf.append(this.getErrorCode());
        buf.append("\n");
        buf.append("  exception-type: ");
        buf.append(this.getExceptionType());
        buf.append("\n");
        buf.append("  location: ");
        buf.append(this.getLocation());
        buf.append("\n");
        return buf.toString();
    }
}

