/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.http;

import com.evermind.io.IOUtils;
import com.evermind.server.ApplicationServerThread;
import com.evermind.server.http.EvermindHttpServletRequest;
import com.evermind.server.http.EvermindHttpServletResponse;
import com.evermind.server.http.HttpRequestHandler;
import com.evermind.util.ByteString;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.Socket;
import java.net.URL;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class TunnelServlet
extends HttpServlet {
    private static final byte[] closeString = "Connection: Close\r\n".getBytes();
    private String host;
    private int port;
    private String root;

    public void init() {
        try {
            URL url = new URL(this.getInitParameter("targetRoot"));
            this.host = url.getHost();
            this.port = url.getPort();
            if (this.port == -1) {
                this.port = 80;
            }
            this.root = url.getFile();
        }
        catch (MalformedURLException e) {
            this.log("TunnelServlet: targetRoot property not pointing to a valid URL", e);
        }
    }

    public void service(HttpServletRequest genericRequest, HttpServletResponse genericResponse) throws IOException {
        EvermindHttpServletRequest request = this.getThreadRequest();
        EvermindHttpServletResponse response = this.getThreadResponse();
        if (request.defaultRequestURI.endsWith(HttpRequestHandler.FORM_LOGIN_STRING)) {
            ByteString referer = request.getByteHeader(EvermindHttpServletRequest.REFERER_HEADER);
            response.sendRedirect(referer.toString());
        } else {
            Socket socket = new Socket(InetAddress.getByName(this.host), this.port);
            OutputStream socketOut = socket.getOutputStream();
            BufferedOutputStream bufferOut = new BufferedOutputStream(socketOut);
            this.writeOut(request, bufferOut);
            bufferOut.flush();
            socketOut.flush();
            IOUtils.pipe(socket.getInputStream(), response.getBasicOut());
            socket.getInputStream().close();
            socketOut.close();
        }
        response.committed = true;
        response.getBasicOut().flush();
    }

    private final void writeOut(EvermindHttpServletRequest request, OutputStream out) throws IOException {
        try {
            out.write(request.getInput(), request.headerStartPos, request.headerLineRealLength);
            out.write(13);
            out.write(10);
            int lineStart = request.headerLineLength;
            int pos = lineStart + 2;
            byte[] input = request.getInput();
            while (true) {
                int lineLength;
                if ((lineLength = ((char)input[lineStart] & 0xFF) + input[lineStart + 1] * 256) == 0) {
                    out.write(closeString);
                    out.write(13);
                    out.write(10);
                    return;
                }
                out.write(input, pos, lineLength - 2);
                out.write(13);
                out.write(10);
                pos = (lineStart += lineLength) + 2;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return;
        }
    }

    protected EvermindHttpServletRequest getThreadRequest() {
        return ((ApplicationServerThread)Thread.currentThread()).httpHandler.request;
    }

    protected EvermindHttpServletResponse getThreadResponse() {
        return ((ApplicationServerThread)Thread.currentThread()).httpHandler.response;
    }
}

