/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.http;

import com.evermind.server.http.JSPPageCompilation;
import java.util.ArrayList;
import java.util.List;

public class JSPStaticInclude {
    public JSPPageCompilation compilation;
    public String path;
    public int start;
    public int end;
    public List children;

    public JSPStaticInclude(JSPPageCompilation compilation, String path, int start, int end) {
        this.compilation = compilation;
        this.path = path;
        this.start = start;
        this.end = end;
    }

    public void allocateChildren(List children) {
        for (int i = 0; i < children.size(); ++i) {
            JSPStaticInclude child = (JSPStaticInclude)children.get(i);
            if (child.start < this.start || child.end >= this.end) continue;
            children.remove(i);
            --i;
            if (this.children == null) {
                this.children = new ArrayList();
            }
            this.children.add(child);
            child.allocateChildren(children);
        }
    }

    public JSPStaticInclude getInclude(int pos) {
        if (this.children == null) {
            return this;
        }
        for (int i = 0; i < this.children.size(); ++i) {
            JSPStaticInclude child = (JSPStaticInclude)this.children.get(i);
            if (child.start > pos || child.end <= pos) continue;
            return child.getInclude(pos);
        }
        return this;
    }

    public int getLineNumber(int pos) {
        if (this.children == null) {
            return JSPPageCompilation.getOccurances(this.compilation.getSource(), this.start, pos, '\n') + 1;
        }
        int count = 0;
        JSPStaticInclude previous = null;
        for (int i = 0; i < this.children.size(); ++i) {
            JSPStaticInclude include = (JSPStaticInclude)this.children.get(i);
            if (include.start >= pos) continue;
            count += JSPPageCompilation.getOccurances(this.compilation.getSource(), previous == null ? this.start : previous.end, include.start, '\n');
            previous = include;
        }
        return (count += JSPPageCompilation.getOccurances(this.compilation.getSource(), previous == null ? this.start : previous.end, pos, '\n')) + 1;
    }

    public String toString() {
        return "include " + this.path + ", " + this.start + "-" + this.end;
    }
}

