/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.http;

import com.evermind.io.IOUtils;
import com.evermind.server.http.EvermindHttpServletRequest;
import com.evermind.server.http.HttpIOException;
import com.evermind.server.http.ParameterMap;
import com.evermind.util.ByteString;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.Iterator;
import java.util.Map;

public class HttpQueryParser {
    public ParameterMap parseQueryString(byte[] data, int pos, int end, String charset, ParameterMap parameters) throws UnsupportedEncodingException {
        if (charset == null) {
            charset = "ISO-8859-1";
        }
        if (parameters == null) {
            throw new IllegalArgumentException("ParameterMap is null");
        }
        boolean parameterCount = false;
        String key = null;
        byte[] buffer = new byte[4096];
        int bufferLength = buffer.length;
        int bufferPos = 0;
        Object myCharsetsCache = null;
        ByteString lookupString = new ByteString();
        while (pos < end) {
            if (bufferPos >= bufferLength) {
                byte[] newBuffer = new byte[buffer.length * 2];
                System.arraycopy(buffer, 0, newBuffer, 0, bufferPos);
                buffer = newBuffer;
                bufferLength = buffer.length;
            }
            byte b = data[pos++];
            switch (b) {
                case 37: {
                    byte higher;
                    if (pos >= end - 1) break;
                    if ((higher = data[pos++]) == 117) {
                        buffer[bufferPos++] = b;
                        --pos;
                        break;
                    }
                    byte lower = data[pos++];
                    int value = higher >= 48 && higher <= 57 ? (higher - 48) * 16 : (higher >= 97 && higher <= 102 ? (higher - 97 + 10) * 16 : (higher >= 65 && higher <= 70 ? (higher - 65 + 10) * 16 : 0));
                    if (lower >= 48 && lower <= 57) {
                        value += lower - 48;
                    } else if (lower >= 97 && lower <= 102) {
                        value += lower - 97 + 10;
                    } else if (lower >= 65 && lower <= 70) {
                        value += lower - 65 + 10;
                    }
                    buffer[bufferPos++] = (byte)value;
                    break;
                }
                case 43: {
                    buffer[bufferPos++] = 32;
                    break;
                }
                case 61: {
                    if (key != null) {
                        buffer[bufferPos++] = b;
                        break;
                    }
                    key = new String(buffer, 0, bufferPos, charset);
                    bufferPos = 0;
                    break;
                }
                case 38: {
                    if (key == null) {
                        bufferPos = 0;
                        break;
                    }
                    String value = new String(buffer, 0, bufferPos, charset);
                    parameters.add(key, value);
                    key = null;
                    bufferPos = 0;
                    break;
                }
                default: {
                    buffer[bufferPos++] = b;
                }
            }
        }
        if (key != null) {
            String value = new String(buffer, 0, bufferPos, charset);
            parameters.add(key, value);
            key = null;
            bufferPos = 0;
        }
        return parameters;
    }

    public static void main(String[] args) throws UnsupportedEncodingException {
        HttpQueryParser parser = new HttpQueryParser();
        ByteString firstParams = new ByteString("a=b&cdef%20=hoho+");
        ByteString secondParams = new ByteString("ahotdog=50kr&meatballs=25kr&d=e&f=");
        ByteString dynamicParams = new ByteString(args[0]);
    }

    public static void addQueryParameters(Map destination, Map source) {
        if (source == null) {
            return;
        }
        Iterator i = source.entrySet().iterator();
        while (i.hasNext()) {
            String[] mergedValue;
            Map.Entry e = i.next();
            Object key = e.getKey();
            Object sourceValue = e.getValue();
            Object destValue = destination.get(key);
            if (destValue == null) {
                destination.put(key, sourceValue);
                continue;
            }
            boolean destIsArray = destValue.getClass().isArray();
            boolean sourceIsArray = sourceValue.getClass().isArray();
            if (destIsArray) {
                String[] destArray = (String[])destValue;
                int destLen = destArray.length;
                if (sourceIsArray) {
                    String[] sourceArray = (String[])sourceValue;
                    int sourceLen = sourceArray.length;
                    mergedValue = new String[sourceLen + destLen];
                    System.arraycopy(destArray, 0, mergedValue, 0, destLen);
                    System.arraycopy(sourceArray, 0, mergedValue, destLen, sourceLen);
                } else {
                    mergedValue = new String[destLen + 1];
                    System.arraycopy(destArray, 0, mergedValue, 0, destLen);
                    mergedValue[destLen] = (String)sourceValue;
                }
            } else if (sourceIsArray) {
                String[] sourceArray = (String[])sourceValue;
                int sourceLen = sourceArray.length;
                mergedValue = new String[sourceLen + 1];
                mergedValue[0] = (String)destValue;
                System.arraycopy(sourceArray, 0, mergedValue, 1, sourceLen);
            } else {
                mergedValue = new String[]{(String)destValue, (String)sourceValue};
            }
            destination.put(key, mergedValue);
        }
    }

    static ParameterMap parsePostBody(ParameterMap map, EvermindHttpServletRequest request) throws IOException {
        boolean isPost;
        boolean bl = isPost = request.method == "POST";
        if (isPost) {
            String contentType = request.getHeader(EvermindHttpServletRequest.CONTENT_TYPE_HEADER);
            if (contentType == null || contentType.indexOf("application/x-www-form-urlencoded") < 0) {
                isPost = false;
            }
        }
        if (isPost) {
            int contentLength;
            if (map == null) {
                throw new IllegalArgumentException("ParameterMap is null");
            }
            if (request.servletIn == null) {
                request.createServletInputStream();
            }
            if ((contentLength = request.getContentLength()) > 0 && request.servletIn.bytesRead == (long)contentLength) {
                return map;
            }
            if (contentLength >= 0 && request.inputStartPos + contentLength <= request.inputEndPos && request.servletIn.bytesRead == 0L) {
                request.servletIn.bytesRead += (long)contentLength;
                int start = request.inputStartPos;
                request.inputStartPos += contentLength;
                request.application.getQueryParser().parseQueryString(request.input, start, start + contentLength, request.getInternalCharacterEncoding(), map);
                return map;
            }
            if (contentLength >= 0) {
                int readThisTurn;
                byte[] target = new byte[contentLength];
                for (int readSoFar = 0; readSoFar < contentLength; readSoFar += readThisTurn) {
                    readThisTurn = request.servletIn.read(target, readSoFar, contentLength - readSoFar);
                    if (readThisTurn >= 0) continue;
                    throw new HttpIOException("Premature end of POST data");
                }
                request.application.getQueryParser().parseQueryString(target, 0, contentLength, request.getInternalCharacterEncoding(), map);
                return map;
            }
            byte[] target = IOUtils.getContent((InputStream)((Object)request.servletIn));
            request.application.getQueryParser().parseQueryString(target, 0, target.length, request.getInternalCharacterEncoding(), map);
            return map;
        }
        return map;
    }

    static ParameterMap parseQueryString(ParameterMap map, EvermindHttpServletRequest request, ByteString qString, String charset) throws UnsupportedEncodingException {
        if (map == null) {
            throw new IllegalArgumentException("map is null");
        }
        if (qString != null) {
            request.application.getQueryParser().parseQueryString(qString.data, qString.offset, qString.offset + qString.length, charset, map);
        }
        return map;
    }

    static ParameterMap parseQueryString(ParameterMap map, EvermindHttpServletRequest request, ByteString qString) throws UnsupportedEncodingException {
        return HttpQueryParser.parseQueryString(map, request, qString, request.getInternalCharacterEncoding());
    }
}

