/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.http;

import java.io.File;
import java.io.FilenameFilter;

class FileInformation
implements FilenameFilter {
    public static final int FILEINFORMATION_FLAG_USED = 1;
    public static final int FILEINFORMATION_FLAG_LOCALIZED_FILES_CHECKED = 2;
    public long modifiedDate;
    public long lastModifiedCheckExpires;
    public byte[] data;
    public byte[] eTag;
    public byte[] lastModifiedHeader;
    public byte[] contentLengthHeader;
    public int expires;
    public byte[] eTagHeader;
    public byte flags;
    public File[] localizedFiles;
    public int[] localeIDs;
    public File file;
    private static String prefix;
    private static String suffix;
    private static FileInformation filter;

    public String toString() {
        return this.file.toString();
    }

    private FileInformation() {
    }

    public boolean accept(File file, String name) {
        if (name.length() != prefix.length() + 3 + (suffix == null ? 0 : suffix.length())) {
            return false;
        }
        if (!name.startsWith(prefix)) {
            return false;
        }
        if (suffix != null && !name.endsWith(suffix)) {
            return false;
        }
        int pos = name.length() - 3 - (suffix == null ? 0 : suffix.length());
        return name.charAt(pos) == '_';
    }

    public FileInformation(long modifiedDate, byte[] data, byte[] lastModifiedHeader, byte[] contentLengthHeader, byte[] eTagHeader, byte[] eTag, File file, int expires) {
        this.lastModifiedHeader = lastModifiedHeader;
        this.contentLengthHeader = contentLengthHeader;
        this.eTagHeader = eTagHeader;
        this.modifiedDate = modifiedDate;
        this.data = data;
        this.eTag = eTag;
        this.file = file;
        this.expires = expires;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File getLocalizedVersion(int localeID) {
        if ((this.flags & 2) == 0) {
            this.flags = (byte)(this.flags | 2);
            String filePath = this.file.getPath();
            FileInformation fileInformation = filter;
            synchronized (fileInformation) {
                int fileDotPos = filePath.lastIndexOf(46);
                if (fileDotPos < 0) {
                    prefix = filePath.substring(filePath.lastIndexOf(File.separatorChar) + 1);
                    suffix = null;
                } else {
                    prefix = filePath.substring(filePath.lastIndexOf(File.separatorChar) + 1, fileDotPos);
                    suffix = filePath.substring(fileDotPos);
                }
                this.localizedFiles = this.file.getParentFile().listFiles(filter);
            }
            if (this.localizedFiles == null || this.localizedFiles.length == 0) {
                this.localizedFiles = null;
                return null;
            }
            this.localeIDs = new int[this.localizedFiles.length];
            for (int i = 0; i < this.localizedFiles.length; ++i) {
                String path = this.localizedFiles[i].getPath();
                int pathLength = path.length();
                int dotPos = path.lastIndexOf(46);
                if (dotPos < 0) {
                    if (pathLength < 3 || path.charAt(pathLength - 3) != '_') {
                        this.localeIDs[i] = -1;
                        continue;
                    }
                    this.localeIDs[i] = (path.charAt(pathLength - 2) << 8) + path.charAt(pathLength - 1);
                    continue;
                }
                this.localeIDs[i] = dotPos < 3 || path.charAt(dotPos - 3) != '_' ? -1 : (path.charAt(dotPos - 2) << 8) + path.charAt(dotPos - 1);
            }
        }
        if (this.localizedFiles == null) {
            return null;
        }
        for (int i = 0; i < this.localizedFiles.length; ++i) {
            if (this.localeIDs[i] != localeID) continue;
            return this.localizedFiles[i];
        }
        return null;
    }

    static {
        filter = new FileInformation();
    }
}

