/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.http;

import com.evermind.io.IOUtils;
import com.evermind.io.SingleReadBufferInputStream;
import com.evermind.server.ApplicationServer;
import com.evermind.server.ApplicationServerThread;
import com.evermind.server.ApplicationStateStopped;
import com.evermind.server.ThreadState;
import com.evermind.server.http.AJPBodyInputStream;
import com.evermind.server.http.AJPConnectionListener;
import com.evermind.server.http.AJPHttpServletRequest;
import com.evermind.server.http.AJPHttpServletResponse;
import com.evermind.server.http.AJPOutputStream;
import com.evermind.server.http.HttpException;
import com.evermind.server.http.HttpIOException;
import com.evermind.server.http.HttpMessages;
import com.evermind.server.http.HttpRequestHandler;
import com.evermind.server.http.HttpServer;
import com.evermind.server.http.HttpSite;
import com.evermind.util.ByteString;
import com.evermind.util.HTTPProperties;
import com.evermind.util.ObjectUtils;
import com.evermind.util.ReleasableResource;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.Socket;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dms.console.DMSConsole;
import oracle.dms.instrument.PhaseEvent;
import oracle.dms.instrument.PhaseEventIntf;
import oracle.dms.instrument.TransTraceIntf;
import oracle.j2ee.util.TraceLogger;

public class AJPRequestHandler
extends HttpRequestHandler
implements ReleasableResource {
    private static final int METHODCODE_ARBITRARY = 19;
    private static final String[] METHODS = new String[]{null, "OPTIONS", "GET", "HEAD", "POST", "PUT", "DELETE", "TRACE", "CONNECT", "PATCH", "PROPFIND", "PROPPATCH", "MKCOL", "COPY", "MOVE", "LOCK", "UNLOCK", "LOGOUT", "GETTOKENCRED", "ARBITRARY"};
    private static final int AJP_PACKET_SIZE = 8192;
    private static final int AJP_EOS = -1;
    private int inputPos;
    private AJPConnectionListener listener;
    private byte[] m_buffer = new byte[8192];
    private byte[] outBuffer = new byte[10];
    private byte[] readBuffer = new byte[4096];
    private byte[] inBuffer = new byte[AJPBodyInputStream.MAX_READ_SIZE];
    private InputStream socketIn;
    SingleReadBufferInputStream bufferIn;
    private OutputStream socketOut;
    private AJPBodyInputStream in;
    private AJPOutputStream out;
    private ByteString tempURIString = new ByteString(1);
    private ByteString tempByteString = new ByteString(1);
    private ByteString tempJVMRouteString = new ByteString(1);
    private boolean keepAlive = HTTPProperties.getAjpKeepAlive();
    private int soTimeout = HTTPProperties.getAjpSoTimeout();
    private static final byte AJP13_FORWARD_REQUEST = 2;
    private static final byte AJP13_SHUTDOWN = 7;
    private static final byte AJP13_MORE_HEADER = 8;
    private static final byte AJP13_PING = 9;
    int m_ajpCommand;
    private static final byte SC_A_CONTEXT = 1;
    private static final byte SC_A_SERVLET_PATH = 2;
    private static final byte SC_A_REMOTE_USER = 3;
    private static final byte SC_A_AUTH_TYPE = 4;
    private static final byte SC_A_QUERY_STRING = 5;
    private static final byte SC_A_JVM_ROUTE = 6;
    private static final byte SC_A_SSL_CERT = 7;
    private static final byte SC_A_SSL_CIPHER = 8;
    private static final byte SC_A_SSL_SESSION = 9;
    private static final byte SC_A_REQ_ATTRIBUTE = 10;
    private static final byte SC_A_ARE_DONE = -1;
    private static final String ENV_UNPARSED_URI_V = "OC4J_UNPARSED_URI_V";
    private static final String ENV_UNPARSED_URI = "OC4J_UNPARSED_URI";
    private static Logger m_traceLogger = TraceLogger.getLogger(AJPRequestHandler.class);
    static boolean AJP_IO_DEBUG = false;
    static boolean AJP_DEBUG = false;
    static final String JVMROUTE = "jvmRoute";
    boolean firstRequest = true;

    public AJPRequestHandler(HttpServer server) {
        super(server);
        this.request = new AJPHttpServletRequest();
        this.request.response = this.response = new AJPHttpServletResponse();
        this.response.request = this.request;
        ((AJPHttpServletResponse)this.response).ajpRequest = (AJPHttpServletRequest)this.request;
    }

    public void bindSocket() throws Exception {
        Socket socket = this.getSocket();
        socket.setTcpNoDelay(true);
        socket.setKeepAlive(this.keepAlive);
        socket.setSoTimeout(this.soTimeout);
        this.setSendBufferSize();
        this.setRecvBufferSize();
    }

    public void unbindSocket() {
    }

    public void bindThread() throws Exception {
        ApplicationServerThread thread = (ApplicationServerThread)Thread.currentThread();
        thread.httpHandler = this;
    }

    public void run() {
        Thread thread = Thread.currentThread();
        String threadName = thread.getName();
        thread.setName("AJPRequestHandler-" + threadName);
        this.run(Thread.currentThread());
        thread.setName(threadName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void run(Thread genericThread) {
        block64: {
            block62: {
                block61: {
                    _reuseSocket = true;
                    thread = (ApplicationServerThread)genericThread;
                    currentThreadState = ThreadState.getCurrentState();
                    out = null;
                    in = null;
                    endrun_invoked = false;
                    try {
                        block58: {
                            block59: {
                                block51: {
                                    block53: {
                                        block54: {
                                            block52: {
                                                currentThreadState.setInheritable(true);
                                                out = this.getSocketOutputStream(this.getSocket());
                                                in = this.getSocketInputStream(this.getSocket());
                                                ((AJPHttpServletResponse)this.response).socketOut = this.socketOut;
                                                ((AJPHttpServletResponse)this.response).ajpOut = this.out;
                                                request = (AJPHttpServletRequest)this.request;
                                                response = this.response;
                                                processedRequest = false;
                                                if (ApplicationServer.DMS_GATE) {
                                                    processedRequest = false;
                                                    request.AJPRequest = true;
                                                    this.processRequest = null;
                                                    this.contextProcessRequest = null;
                                                }
                                                if (!this.firstRequest) {
                                                    response.resetState();
                                                    request.reset();
                                                    ((AJPBodyInputStream)in).resetState();
                                                    this.out.setCloseBuffer(false);
                                                }
                                                if (request.socket == null) {
                                                    request.preset(this.getSocket());
                                                    response.preset(out);
                                                }
                                                if (request.application != null) ** GOTO lbl84
                                                if (this.initRequest(request, in, out, this.site, this.oldStartPos, this.oldEndPos)) break block51;
                                                if (endrun_invoked) break block52;
                                                endrun_invoked = true;
                                                this.endRun(false);
                                            }
                                            var18_15 = null;
                                            if (!ApplicationServer.DMS_GATE || processedRequest) break block53;
                                            if (this.contextProcessRequest == null) break block54;
                                            ((PhaseEvent)this.contextProcessRequest).abort(request.startParseToken);
                                        }
                                        if (this.processRequest != null) {
                                            ((PhaseEvent)this.processRequest).abort(request.startParseToken);
                                        }
                                        if (this.parseRequest != null) {
                                            ((PhaseEvent)this.parseRequest).abort(request.startParseToken);
                                        }
                                        cons = ApplicationServer.dmsConsole;
                                        ttFactory = cons.getTransTrace();
                                        ttFactory.requestStop();
                                    }
                                    if (request.application != null && request.application.getComponentState() == 2 && request.application.getHttpReqCount() == 0) {
                                        AJPRequestHandler.m_traceLogger.log(Level.FINE, "This is the last request thread for app, Calling stopCleanUp");
                                        request.application.stopCleanUp(request.application.application.getAppComponentList());
                                    }
                                    if (!(_reuseSocket || request.method != "POST" && request.method != "PUT")) {
                                        try {
                                            out.close();
                                            in.read(request.getInput(), 0, 2);
                                        }
                                        catch (IOException e) {
                                            // empty catch block
                                        }
                                    }
                                    response.resetState();
                                    request.reset();
                                    request.resetSocket();
                                    var22_24 = null;
                                    in = null;
                                    out = null;
                                    currentThreadState.setInheritable(false);
                                    return;
                                }
                                try {
                                    block57: {
                                        block56: {
                                            if (request.site != null) {
                                                currentSite = request.site;
                                                currentURI = request.getRequestURI();
                                                request.application = currentSite.getApplication(new ByteString(currentURI.toCharArray()));
                                            }
                                            if (ApplicationServer.DMS_GATE) {
                                                this.parseRequest.stop(request.startParseToken);
                                                this.parseRequest = null;
                                            }
lbl84:
                                            // 4 sources

                                            ++request.site.hitsLastMinute;
                                            request.application.responseBufferSize = AJPBodyInputStream.MAX_READ_SIZE;
                                            if (!this.processRequest(thread, request, response, in, out, false)) {
                                                _reuseSocket = false;
                                            }
                                            ((AJPOutputStream)out).endRequest();
                                            if (ApplicationServer.DMS_GATE) {
                                                this.contextProcessRequest.stop(request.startParseToken);
                                                this.processRequest.stop(request.startParseToken);
                                                cons = ApplicationServer.dmsConsole;
                                                ttFactory = cons.getTransTrace();
                                                ttFactory.requestStop();
                                                this.processRequest = null;
                                                this.contextProcessRequest = null;
                                                processedRequest = true;
                                            }
                                            if (request.application.getComponentState() != 2) break block56;
                                            AJPRequestHandler.m_traceLogger.log(Level.FINE, "Application marked to stop");
                                            _reuseSocket = false;
                                            break block57;
                                            {
                                                catch (HttpException e) {
                                                    _reuseSocket = false;
                                                    if (HTTPProperties.getHttpErrorDebug()) {
                                                        AJPRequestHandler.m_traceLogger.log(Level.FINE, "Internal Error", e);
                                                    }
                                                    this.handleHttpException(request, response, e);
                                                    this.currentDispatcher = null;
                                                    break block57;
                                                }
                                                catch (ApplicationStateStopped.ApplicationStoppedException iae) {
                                                    _reuseSocket = false;
                                                    errorWriter = new PrintWriter((Writer)new OutputStreamWriter(out), false);
                                                    errorWriter.println("HTTP/1.1 404 Not Found");
                                                    errorWriter.println("Content-Type: text/html");
                                                    errorWriter.println();
                                                    errorWriter.println("<html><head><title>The web application being accesses has beenstopped</title></head><body><h1>web-application has been stopped</h1>");
                                                    errorWriter.flush();
                                                    errorWriter.close();
                                                    out.close();
                                                    throw new IOException();
                                                }
                                                catch (Throwable t) {
                                                    _reuseSocket = false;
                                                    AJPRequestHandler.m_traceLogger.log(Level.FINE, "Internal Error", t);
                                                    response.handleException(t);
                                                    this.currentDispatcher = null;
                                                    break block57;
                                                }
                                            }
                                        }
                                        this.firstRequest = false;
                                        request.resetSocket();
                                    }
                                    var18_16 = null;
                                    if (!ApplicationServer.DMS_GATE || processedRequest) break block58;
                                    if (this.contextProcessRequest == null) break block59;
                                }
                                catch (Throwable var17_36) {
                                    var18_17 = null;
                                    if (ApplicationServer.DMS_GATE && !processedRequest) {
                                        if (this.contextProcessRequest != null) {
                                            ((PhaseEvent)this.contextProcessRequest).abort(request.startParseToken);
                                        }
                                        if (this.processRequest != null) {
                                            ((PhaseEvent)this.processRequest).abort(request.startParseToken);
                                        }
                                        if (this.parseRequest != null) {
                                            ((PhaseEvent)this.parseRequest).abort(request.startParseToken);
                                        }
                                        cons = ApplicationServer.dmsConsole;
                                        ttFactory = cons.getTransTrace();
                                        ttFactory.requestStop();
                                    }
                                    if (request.application != null && request.application.getComponentState() == 2 && request.application.getHttpReqCount() == 0) {
                                        AJPRequestHandler.m_traceLogger.log(Level.FINE, "This is the last request thread for app, Calling stopCleanUp");
                                        request.application.stopCleanUp(request.application.application.getAppComponentList());
                                    }
                                    if (!(_reuseSocket || request.method != "POST" && request.method != "PUT")) {
                                        try {
                                            out.close();
                                            in.read(request.getInput(), 0, 2);
                                        }
                                        catch (IOException e) {
                                            // empty catch block
                                        }
                                    }
                                    response.resetState();
                                    request.reset();
                                    request.resetSocket();
                                    throw var17_36;
                                }
                                ((PhaseEvent)this.contextProcessRequest).abort(request.startParseToken);
                            }
                            if (this.processRequest != null) {
                                ((PhaseEvent)this.processRequest).abort(request.startParseToken);
                            }
                            if (this.parseRequest != null) {
                                ((PhaseEvent)this.parseRequest).abort(request.startParseToken);
                            }
                            cons = ApplicationServer.dmsConsole;
                            ttFactory = cons.getTransTrace();
                            ttFactory.requestStop();
                        }
                        if (request.application != null && request.application.getComponentState() == 2 && request.application.getHttpReqCount() == 0) {
                            AJPRequestHandler.m_traceLogger.log(Level.FINE, "This is the last request thread for app, Calling stopCleanUp");
                            request.application.stopCleanUp(request.application.application.getAppComponentList());
                        }
                        if (!(_reuseSocket || request.method != "POST" && request.method != "PUT")) {
                            try {
                                out.close();
                                in.read(request.getInput(), 0, 2);
                            }
                            catch (IOException e) {
                                // empty catch block
                            }
                        }
                        response.resetState();
                        request.reset();
                        request.resetSocket();
                        {
                            break block61;
                            catch (IOException e) {
                                _reuseSocket = false;
                                if (HTTPProperties.getHttpErrorDebug()) {
                                    AJPRequestHandler.m_traceLogger.log(Level.FINE, e.getMessage(), e);
                                }
                                throw e;
                            }
                        }
                    }
                    catch (Throwable var21_37) {
                        var22_28 = null;
                        in = null;
                        out = null;
                        currentThreadState.setInheritable(false);
                        throw var21_37;
                    }
                }
                var22_25 = null;
                in = null;
                out = null;
                currentThreadState.setInheritable(false);
                {
                    break block62;
                    catch (IOException e) {
                        block63: {
                            this.currentDispatcher = null;
                            if (HTTPProperties.getHttpErrorDebug()) {
                                AJPRequestHandler.m_traceLogger.log(Level.FINE, e.getMessage(), e);
                            }
                            try {
                                if (!endrun_invoked) {
                                    endrun_invoked = true;
                                    this.endRun(false);
                                }
                            }
                            catch (Exception ioe) {
                                if (!HTTPProperties.getHttpErrorDebug()) break block63;
                                AJPRequestHandler.m_traceLogger.log(Level.FINE, ioe.getMessage(), ioe);
                            }
                        }
                        var22_26 = null;
                        in = null;
                        out = null;
                        currentThreadState.setInheritable(false);
                        break block62;
                    }
                    catch (Throwable t) {
                        if (HTTPProperties.getHttpErrorDebug()) {
                            AJPRequestHandler.m_traceLogger.log(Level.FINE, t.getMessage(), t);
                        }
                        this.currentDispatcher = null;
                        if (HTTPProperties.getHttpErrorDebug()) {
                            AJPRequestHandler.m_traceLogger.log(Level.FINE, t.getMessage(), t);
                        }
                        HttpMessages.internalError(t);
                        var22_27 = null;
                        in = null;
                        out = null;
                        currentThreadState.setInheritable(false);
                    }
                }
            }
            thread.httpHandler = null;
            thread.state.reset();
            this.request.resetSocket();
            try {
                if (!endrun_invoked) {
                    endrun_invoked = true;
                    this.endRun(_reuseSocket);
                }
            }
            catch (Throwable t) {
                if (!HTTPProperties.getHttpErrorDebug()) break block64;
                AJPRequestHandler.m_traceLogger.log(Level.FINE, t.getMessage(), t);
            }
        }
    }

    protected OutputStream getSocketOutputStream(Socket socket) throws IOException {
        this.socketIn = null;
        this.socketOut = null;
        this.bufferIn = null;
        this.socketIn = this.getInputStream();
        this.bufferIn = new SingleReadBufferInputStream(this.socketIn, this.readBuffer);
        this.socketOut = this.getOutputStream();
        if (this.out == null) {
            this.out = new AJPOutputStream(this.socketOut, this.outBuffer);
        } else {
            this.out.setNewState(this.socketOut);
        }
        return this.out;
    }

    protected InputStream getSocketInputStream(Socket socket) throws IOException {
        if (this.in == null) {
            this.in = new AJPBodyInputStream(this.request, this.bufferIn, this.socketOut, this.inBuffer);
        } else {
            this.in.setNewState(this.request, this.bufferIn, this.socketOut);
        }
        return this.in;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean initRequest(AJPHttpServletRequest request, InputStream ajpIn, OutputStream out, HttpSite[] site, int oldStartPos, int oldEndPos) throws HttpIOException, HttpException, IOException {
        AJP_DEBUG = HTTPProperties.getAjpDebug();
        AJP_IO_DEBUG = HTTPProperties.getAJPIODebug();
        int length = this.readAJPPackets();
        if (length == -1) {
            return false;
        }
        if (ApplicationServer.DMS_GATE) {
            request.startParseToken = ApplicationServer.phaseEventFactory().getToken();
            DMSConsole cons = ApplicationServer.dmsConsole;
            TransTraceIntf ttFactory = cons.getTransTrace();
            ttFactory.requestStart();
        }
        switch (this.m_ajpCommand) {
            case 2: {
                this.initAJP(request, this.m_buffer, length, site);
                if (site != null) return request.init(this.in, out, site, 0, request.inputEndPos);
                throw new NullPointerException("sites was null");
            }
            case 7: {
                throw new IOException("The AJP shutdown signal is not supported by OC4J");
            }
            case 9: {
                try {
                    if (AJP_IO_DEBUG) {
                        m_traceLogger.log(Level.FINE, "Got PING at " + new Date());
                    }
                    this.socketOut.write(0);
                    this.socketOut.close();
                    return false;
                }
                catch (Exception e) {
                    if (!HTTPProperties.getHttpErrorDebug()) return false;
                    m_traceLogger.log(Level.FINE, e.getMessage(), e);
                }
                return false;
            }
        }
        if (!AJP_IO_DEBUG) throw new IOException("Invalid AJP code: " + this.m_ajpCommand);
        m_traceLogger.log(Level.FINE, "Invalid AJP code: " + this.m_ajpCommand);
        throw new IOException("Invalid AJP code: " + this.m_ajpCommand);
    }

    protected int readAJPPackets() throws IOException {
        int size = 0;
        do {
            int firstByte;
            try {
                firstByte = this.bufferIn.read();
            }
            catch (Exception e) {
                throw new IOException(e.getMessage());
            }
            if (firstByte < 0) {
                return -1;
            }
            if (firstByte != 18 || this.bufferIn.read() != 52) {
                if (AJP_IO_DEBUG) {
                    m_traceLogger.log(Level.FINE, "Invalid packet (signature not found)");
                }
                throw new IOException("Invalid packet header");
            }
            int lengthHigh = this.bufferIn.read();
            int lengthLow = this.bufferIn.read();
            int length = ((lengthHigh & 0xFF) << 8) + (lengthLow & 0xFF);
            this.m_ajpCommand = this.bufferIn.read();
            if (AJP_IO_DEBUG) {
                m_traceLogger.log(Level.FINE, "AJP: Packet size so far: " + size);
                m_traceLogger.log(Level.FINE, "AJP: Input request length is: " + length + "\ncommand is " + this.m_ajpCommand);
            }
            switch (this.m_ajpCommand) {
                case 9: {
                    return 0;
                }
            }
            if (this.m_buffer.length < size + --length) {
                byte[] tempBuffer = new byte[size + length];
                System.arraycopy(this.m_buffer, 0, tempBuffer, 0, size);
                this.m_buffer = tempBuffer;
                if (AJP_IO_DEBUG) {
                    m_traceLogger.log(Level.FINE, "AJP: Resized recv buffer to " + this.m_buffer.length);
                }
            }
            IOUtils.readFully(this.bufferIn, this.m_buffer, size, length);
            size += length;
        } while (this.m_ajpCommand == 8);
        return size;
    }

    protected void initAJP(AJPHttpServletRequest request, byte[] data, int length, HttpSite[] sites) throws IOException {
        int i;
        byte methodCode;
        this.inputPos = 0;
        if ((methodCode = data[this.inputPos++]) <= 0 || methodCode >= METHODS.length) {
            throw new IOException("Invalid method code");
        }
        String method = methodCode == 19 ? this.readString(data, this.tempByteString).toString() : METHODS[methodCode];
        String protocol = null;
        if (data[this.inputPos] == 0 && data[this.inputPos + 1] == 8 && data[this.inputPos + 2] == 72 && data[this.inputPos + 3] == 84 && data[this.inputPos + 4] == 84 && data[this.inputPos + 5] == 80 && data[this.inputPos + 6] == 47 && data[this.inputPos + 7] == 49 && data[this.inputPos + 8] == 46) {
            if (data[this.inputPos + 9] == 49) {
                protocol = "HTTP/1.1";
            } else if (data[this.inputPos + 9] == 48) {
                protocol = "HTTP/1.0";
            }
            this.inputPos += 11;
        }
        if (protocol == null) {
            protocol = this.readString(data, this.tempByteString).toString();
        }
        ByteString requestURI = this.readString(data, this.tempURIString);
        request.remoteAddress = this.readString(data, request.remoteAddress);
        request.remoteHost = this.readString(data, request.remoteHost);
        request.serverName = this.readString(data, request.serverName);
        request.port = this.readInt(data);
        request.secure = data[this.inputPos++] != 0;
        int resultPos = 0;
        byte[] resultData = request.getInput(length);
        if (method == "GET") {
            resultData[resultPos++] = 71;
            resultData[resultPos++] = 69;
            resultData[resultPos++] = 84;
        } else if (method == "POST") {
            resultData[resultPos++] = 80;
            resultData[resultPos++] = 79;
            resultData[resultPos++] = 83;
            resultData[resultPos++] = 84;
        } else {
            for (i = 0; i < method.length(); ++i) {
                resultData[resultPos++] = ObjectUtils.toByte(method.charAt(i));
            }
        }
        resultData[resultPos++] = 32;
        System.arraycopy(requestURI.data, requestURI.offset, resultData, resultPos, requestURI.length);
        resultPos += requestURI.length;
        resultData[resultPos++] = 32;
        if (protocol == "HTTP/1.1") {
            resultData[resultPos++] = 72;
            resultData[resultPos++] = 84;
            resultData[resultPos++] = 84;
            resultData[resultPos++] = 80;
            resultData[resultPos++] = 47;
            resultData[resultPos++] = 49;
            resultData[resultPos++] = 46;
            resultData[resultPos++] = 49;
        } else if (protocol == "HTTP/1.0") {
            resultData[resultPos++] = 72;
            resultData[resultPos++] = 84;
            resultData[resultPos++] = 84;
            resultData[resultPos++] = 80;
            resultData[resultPos++] = 47;
            resultData[resultPos++] = 49;
            resultData[resultPos++] = 46;
            resultData[resultPos++] = 48;
        } else {
            for (i = 0; i < protocol.length(); ++i) {
                resultData[resultPos++] = ObjectUtils.toByte(protocol.charAt(i));
            }
        }
        resultData[resultPos++] = 13;
        resultData[resultPos++] = 10;
        int headerCount = this.readInt(data);
        for (int i2 = 0; i2 < headerCount; ++i2) {
            resultPos = this.readHeaderString(data, resultData, resultPos);
            resultData[resultPos++] = 58;
            resultData[resultPos++] = 32;
            resultPos = this.readHeaderString(data, resultData, resultPos);
            resultData[resultPos++] = 13;
            resultData[resultPos++] = 10;
        }
        resultData[resultPos++] = 13;
        resultData[resultPos++] = 10;
        request.inputStartPos = 0;
        request.inputEndPos = resultPos;
        if (AJP_DEBUG) {
            m_traceLogger.log(Level.FINE, "*********** AJP REQUEST *****************");
            m_traceLogger.log(Level.FINE, new String(resultData, 0, resultPos));
            m_traceLogger.log(Level.FINE, "*********** AJP REQUEST DONE ************");
        }
        if (request.sslCertificate == null) {
            request.sslCertificate = new ArrayList(3);
        } else {
            request.sslCertificate.clear();
        }
        request.sslCipher = null;
        request.sslSession = null;
        long resolveContextToken = 0L;
        if (ApplicationServer.DMS_GATE) {
            resolveContextToken = ApplicationServer.phaseEventFactory().getToken();
        }
        block17: while (true) {
            byte command = data[this.inputPos++];
            if (AJP_DEBUG) {
                m_traceLogger.log(Level.FINE, "AJP: Attribute key: " + command);
            }
            if (command == -1) break;
            switch (command) {
                case 1: {
                    this.tempByteString = this.readString(data, this.tempByteString);
                    break;
                }
                case 2: {
                    request.servletPath = this.readString(data, request.servletPath);
                    break;
                }
                case 6: {
                    request.jvmRoute = this.readString(data, this.tempJVMRouteString);
                    if (AJP_DEBUG) {
                        m_traceLogger.log(Level.FINE, "AJP: jvmRoute: " + request.jvmRoute.toString());
                    }
                    request.setAttribute_oc4j(JVMROUTE, request.jvmRoute.toString());
                    break;
                }
                case 4: {
                    request.authType = this.readString(data, request.authType);
                    if (!AJP_DEBUG) break;
                    m_traceLogger.log(Level.FINE, "AJP: authType: " + request.authType.toString());
                    break;
                }
                case 3: {
                    request.remoteUserString = this.readString(data, request.remoteUserString);
                    if (!AJP_DEBUG) break;
                    m_traceLogger.log(Level.FINE, "AJP: Remote User: " + request.remoteUserString.toString());
                    break;
                }
                case 5: {
                    request.queryString = this.readString(data, request.queryString);
                    if (!AJP_DEBUG || request.queryString == null) continue block17;
                    m_traceLogger.log(Level.FINE, "AJP: Query string: " + request.queryString.toString());
                    break;
                }
                case 7: {
                    request.sslCertificate.add(this.readString(data));
                    if (!AJP_DEBUG || request.sslCertificate == null) continue block17;
                    int i3 = 0;
                    while (true) {
                        if (i3 >= request.sslCertificate.size()) continue block17;
                        if (request.sslCertificate.get(i3) != null) {
                            m_traceLogger.log(Level.FINE, "AJP: SSL Certificate:");
                            m_traceLogger.log(Level.FINE, request.sslCertificate.get(i3).toString());
                        } else {
                            m_traceLogger.log(Level.FINE, "AJP: SSL Certificate at index: " + i3 + " is null");
                        }
                        ++i3;
                    }
                }
                case 8: {
                    request.sslCipher = this.readString(data);
                    if (!AJP_DEBUG || request.sslCipher == null) continue block17;
                    m_traceLogger.log(Level.FINE, "AJP: SSL Cipher: " + request.sslCipher.toString());
                    break;
                }
                case 9: {
                    request.sslSession = this.readString(data);
                    break;
                }
                case 10: {
                    String env = null;
                    String val = null;
                    ByteString t = this.readString(data, this.tempByteString);
                    if (t != null) {
                        env = t.toString();
                    }
                    if ((t = this.readString(data, this.tempByteString)) != null) {
                        val = request.newISOString(t.data, t.offset, t.length);
                    }
                    if (AJP_DEBUG) {
                        m_traceLogger.log(Level.FINE, "Adding (" + env + "," + val + ") (env,val) pair");
                    }
                    if (request.attributes == null) {
                        request.attributes = new HashMap();
                    }
                    if (env == null) break;
                    request.attributes.put(env, val);
                    if ((!env.equals(ENV_UNPARSED_URI) || request.getUnparsedURI() != null) && (!env.equals(ENV_UNPARSED_URI_V) || !HTTPProperties.getAjpUseVirginUri())) continue block17;
                    if (val.startsWith("http://")) {
                        int slashPos = val.indexOf(47, 7);
                        val = val.substring(slashPos);
                    }
                    if (AJP_DEBUG) {
                        m_traceLogger.log(Level.FINE, "Setting the request URI to: " + val);
                    }
                    request.setUnparsedURI(val);
                }
            }
        }
        try {
            if (request.application == null && this.site != null && this.site[0] != null) {
                String requestURIStr = request.getUnparsedURI();
                if (requestURIStr == null) {
                    requestURIStr = requestURI.toString();
                }
                request.application = this.site[0].getApplication(new ByteString(URLDecoder.decode(requestURIStr)));
            }
        }
        catch (Exception e) {
            this.response.sendError(404, e.getMessage());
            HttpMessages.internalErrorWhileTryingToInstantiate(e);
            throw new IOException(e.getMessage());
        }
        if (ApplicationServer.DMS_GATE && request.application != null) {
            PhaseEventIntf resolveContext = request.application.getResolveContextMetric();
            resolveContext.start(resolveContextToken);
            resolveContext.stop(resolveContextToken);
            resolveContext = null;
            this.processRequest = request.application.getProcessRequestMetric();
            this.processRequest.start(request.startParseToken);
            this.contextProcessRequest = request.application.getContextProcessRequestMetric();
            this.contextProcessRequest.start(request.startParseToken);
            this.parseRequest = request.application.getParseRequestMetric();
            this.parseRequest.start(request.startParseToken);
        }
    }

    private ByteString readString(byte[] data) {
        return this.readString(data, null);
    }

    private ByteString readString(byte[] data, ByteString recycled) {
        int lengthHigh = (char)data[this.inputPos++] & 0xFF;
        int lengthLow = (char)data[this.inputPos++] & 0xFF;
        if (lengthHigh == 255) {
            if (recycled != null) {
                recycled.length = 0;
            }
            return null;
        }
        int length = (lengthHigh << 8) + lengthLow;
        ByteString result = null;
        if (recycled == null) {
            result = new ByteString(length);
            result.length = length;
            System.arraycopy(data, this.inputPos, result.data, 0, length);
        } else {
            result = recycled;
            result.data = data;
            result.offset = this.inputPos;
            result.length = length;
        }
        this.inputPos += length + 1;
        return result;
    }

    private int readHeaderString(byte[] data, byte[] result, int pos) throws IOException {
        int lengthHigh = (char)data[this.inputPos++] & 0xFF;
        int lengthLow = (char)data[this.inputPos++] & 0xFF;
        if (lengthHigh == 160) {
            switch (lengthLow) {
                case 1: {
                    result[pos++] = 65;
                    result[pos++] = 99;
                    result[pos++] = 99;
                    result[pos++] = 101;
                    result[pos++] = 112;
                    result[pos++] = 116;
                    return pos;
                }
                case 2: {
                    result[pos++] = 65;
                    result[pos++] = 99;
                    result[pos++] = 99;
                    result[pos++] = 101;
                    result[pos++] = 112;
                    result[pos++] = 116;
                    result[pos++] = 45;
                    result[pos++] = 67;
                    result[pos++] = 104;
                    result[pos++] = 97;
                    result[pos++] = 114;
                    result[pos++] = 115;
                    result[pos++] = 101;
                    result[pos++] = 116;
                    return pos;
                }
                case 3: {
                    result[pos++] = 65;
                    result[pos++] = 99;
                    result[pos++] = 99;
                    result[pos++] = 101;
                    result[pos++] = 112;
                    result[pos++] = 116;
                    result[pos++] = 45;
                    result[pos++] = 69;
                    result[pos++] = 110;
                    result[pos++] = 99;
                    result[pos++] = 111;
                    result[pos++] = 100;
                    result[pos++] = 105;
                    result[pos++] = 110;
                    result[pos++] = 103;
                    return pos;
                }
                case 4: {
                    result[pos++] = 65;
                    result[pos++] = 99;
                    result[pos++] = 99;
                    result[pos++] = 101;
                    result[pos++] = 112;
                    result[pos++] = 116;
                    result[pos++] = 45;
                    result[pos++] = 76;
                    result[pos++] = 97;
                    result[pos++] = 110;
                    result[pos++] = 103;
                    result[pos++] = 117;
                    result[pos++] = 97;
                    result[pos++] = 103;
                    result[pos++] = 101;
                    return pos;
                }
                case 5: {
                    result[pos++] = 65;
                    result[pos++] = 117;
                    result[pos++] = 116;
                    result[pos++] = 104;
                    result[pos++] = 111;
                    result[pos++] = 114;
                    result[pos++] = 105;
                    result[pos++] = 122;
                    result[pos++] = 97;
                    result[pos++] = 116;
                    result[pos++] = 105;
                    result[pos++] = 111;
                    result[pos++] = 110;
                    return pos;
                }
                case 6: {
                    result[pos++] = 67;
                    result[pos++] = 111;
                    result[pos++] = 110;
                    result[pos++] = 110;
                    result[pos++] = 101;
                    result[pos++] = 99;
                    result[pos++] = 116;
                    result[pos++] = 105;
                    result[pos++] = 111;
                    result[pos++] = 110;
                    return pos;
                }
                case 7: {
                    result[pos++] = 67;
                    result[pos++] = 111;
                    result[pos++] = 110;
                    result[pos++] = 116;
                    result[pos++] = 101;
                    result[pos++] = 110;
                    result[pos++] = 116;
                    result[pos++] = 45;
                    result[pos++] = 84;
                    result[pos++] = 121;
                    result[pos++] = 112;
                    result[pos++] = 101;
                    return pos;
                }
                case 8: {
                    result[pos++] = 67;
                    result[pos++] = 111;
                    result[pos++] = 110;
                    result[pos++] = 116;
                    result[pos++] = 101;
                    result[pos++] = 110;
                    result[pos++] = 116;
                    result[pos++] = 45;
                    result[pos++] = 76;
                    result[pos++] = 101;
                    result[pos++] = 110;
                    result[pos++] = 103;
                    result[pos++] = 116;
                    result[pos++] = 104;
                    return pos;
                }
                case 9: {
                    result[pos++] = 67;
                    result[pos++] = 111;
                    result[pos++] = 111;
                    result[pos++] = 107;
                    result[pos++] = 105;
                    result[pos++] = 101;
                    return pos;
                }
                case 10: {
                    result[pos++] = 67;
                    result[pos++] = 111;
                    result[pos++] = 111;
                    result[pos++] = 107;
                    result[pos++] = 105;
                    result[pos++] = 101;
                    result[pos++] = 50;
                    return pos;
                }
                case 11: {
                    result[pos++] = 72;
                    result[pos++] = 111;
                    result[pos++] = 115;
                    result[pos++] = 116;
                    return pos;
                }
                case 12: {
                    result[pos++] = 80;
                    result[pos++] = 114;
                    result[pos++] = 97;
                    result[pos++] = 103;
                    result[pos++] = 109;
                    result[pos++] = 97;
                    return pos;
                }
                case 13: {
                    result[pos++] = 82;
                    result[pos++] = 101;
                    result[pos++] = 102;
                    result[pos++] = 101;
                    result[pos++] = 114;
                    result[pos++] = 101;
                    result[pos++] = 114;
                    return pos;
                }
                case 14: {
                    result[pos++] = 85;
                    result[pos++] = 115;
                    result[pos++] = 101;
                    result[pos++] = 114;
                    result[pos++] = 45;
                    result[pos++] = 65;
                    result[pos++] = 103;
                    result[pos++] = 101;
                    result[pos++] = 110;
                    result[pos++] = 116;
                    return pos;
                }
            }
            throw new IOException("Unknown 0xa0 escape code: " + lengthLow);
        }
        int length = (lengthHigh << 8) + lengthLow;
        System.arraycopy(data, this.inputPos, result, pos, length);
        this.inputPos += length + 1;
        return pos += length;
    }

    private int readInt(byte[] data) {
        return (((char)data[this.inputPos++] & 0xFF) << 8) + ((char)data[this.inputPos++] & 0xFF);
    }

    public void releaseResource() {
    }
}

