/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.ejb.persistence;

import com.evermind.naming.ContextUtils;
import com.evermind.naming.FlatContext;
import com.evermind.naming.archive.ContentArchiveContext;
import com.evermind.naming.file.ContentFileContext;
import com.evermind.server.ejb.exception.DeploymentException;
import com.evermind.server.ejb.persistence.PersistenceModule;
import com.evermind.server.http.HttpApplication;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.naming.Context;
import oracle.classloader.PolicyClassLoader;

public class WARPersistenceModule
implements PersistenceModule {
    private HttpApplication httpApplication;
    private String path;

    public WARPersistenceModule(HttpApplication httpApplication) {
        this.httpApplication = httpApplication;
        this.path = this.httpApplication.getApplication().getConfig().getWebApplication(this.httpApplication.getConfig().getShortName()).getPackagedPath();
    }

    public String getName() {
        return this.httpApplication.getConfig().getShortName();
    }

    public String getPath() {
        return this.path;
    }

    public String getRelativePersistenceUnitPath(URL persistenceUnitRoot) {
        String persistenceUnitRootString = persistenceUnitRoot.toString();
        if (persistenceUnitRootString.endsWith("WEB-INF/classes/")) {
            return this.getPath() + "/WEB-INF/classes";
        }
        return this.getPath() + "/" + persistenceUnitRootString.substring(persistenceUnitRootString.lastIndexOf("WEB-INF/lib"));
    }

    public List getPersistenceRoots() {
        ArrayList<FlatContext> roots = new ArrayList<FlatContext>();
        Context rootCtx = null;
        ContentFileContext classCtx = null;
        try {
            rootCtx = this.httpApplication.getConfig().getDocumentRoot();
        }
        catch (InstantiationException e) {
            throw DeploymentException.unableToResolveDocumentRoot(this.httpApplication.getApplication().getName(), this.getContextId(), e);
        }
        if (rootCtx != null) {
            File webRootDir = ContextUtils.getFile(rootCtx, false);
            File webInfDir = new File(webRootDir, "WEB-INF");
            File webLibDir = new File(webInfDir, "lib");
            File webClassesDir = new File(webInfDir, "classes");
            if (webClassesDir.exists()) {
                classCtx = new ContentFileContext(webClassesDir, null);
                roots.add(classCtx);
            }
            if (webLibDir.exists()) {
                String[] files = webLibDir.list();
                for (int i = 0; i < files.length; ++i) {
                    String fileName = files[i];
                    if (!fileName.endsWith(".jar")) continue;
                    File file = new File(webLibDir, fileName);
                    ContentArchiveContext context = new ContentArchiveContext(file, false);
                    roots.add(context);
                }
            }
        }
        return roots;
    }

    public PolicyClassLoader getClassLoader() {
        return (PolicyClassLoader)this.httpApplication.getClassLoader();
    }

    public String getDefaultDataSourceName() {
        return this.httpApplication.getApplication().getDefaultDataSourceJNDILocation();
    }

    public Context getApplicationContext() {
        return this.httpApplication.getApplication().getContext();
    }

    public String getContextId() {
        if (this.httpApplication.getApplication() != null) {
            return this.httpApplication.getApplication().getName() + ":" + this.httpApplication.getConfig().getName();
        }
        return this.httpApplication.getConfig().getName();
    }

    public boolean isDeployed() {
        return !this.httpApplication.getApplication().isFirstInitialization();
    }
}

