/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.ejb.persistence;

import com.evermind.server.ejb.EJBTransactionContext;
import com.evermind.server.ejb.EJBTransactionManager;
import com.evermind.server.ejb.EJBUtils;
import com.evermind.server.ejb.logging.PersistenceMessages;
import com.evermind.server.ejb.persistence.AbstractEntityManagerProxy;
import com.evermind.server.ejb.persistence.ContainerEntityManager;
import com.evermind.server.ejb.persistence.NonTransactionalQuery;
import com.evermind.server.ejb.persistence.PersistenceUnit;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.transaction.Synchronization;
import javax.transaction.Transaction;

public class EntityManagerProxy
extends AbstractEntityManagerProxy
implements ContainerEntityManager {
    private PersistenceUnit pu;

    public EntityManagerProxy(PersistenceUnit pu, Map properties) {
        super(properties);
        this.pu = pu;
    }

    public Query createNamedQuery(String name) {
        if (EJBTransactionManager.getTransaction() == null) {
            EntityManager em = this.createEntityManager();
            return new NonTransactionalQuery(em, em.createNamedQuery(name));
        }
        return super.createNamedQuery(name);
    }

    public Query createNativeQuery(String query, Class responseType) {
        if (EJBTransactionManager.getTransaction() == null) {
            EntityManager em = this.createEntityManager();
            return new NonTransactionalQuery(em, em.createNativeQuery(query, responseType));
        }
        return super.createNativeQuery(query, responseType);
    }

    public Query createNativeQuery(String query, String resultSetMappingName) {
        if (EJBTransactionManager.getTransaction() == null) {
            EntityManager em = this.createEntityManager();
            return new NonTransactionalQuery(em, em.createNativeQuery(query, resultSetMappingName));
        }
        return super.createNativeQuery(query, resultSetMappingName);
    }

    public Query createNativeQuery(String query) {
        if (EJBTransactionManager.getTransaction() == null) {
            EntityManager em = this.createEntityManager();
            return new NonTransactionalQuery(em, em.createNativeQuery(query));
        }
        return super.createNativeQuery(query);
    }

    public Query createQuery(String query) {
        if (EJBTransactionManager.getTransaction() == null) {
            EntityManager em = this.createEntityManager();
            return new NonTransactionalQuery(em, em.createQuery(query));
        }
        return super.createQuery(query);
    }

    protected EntityManager allocateEntityManager() {
        Transaction tx = EJBTransactionManager.getTransaction();
        EntityManager em = null;
        if (tx == null) {
            em = this.createEntityManager();
        } else {
            try {
                EJBTransactionContext context = EJBTransactionManager.getInstance().getOrCreateEJBTransactionContext();
                Map map = context.getPersistenceContextMap();
                em = (EntityManager)map.get(this.pu.getName());
                if (em == null) {
                    em = this.createEntityManager();
                    this.pu.joinPersistenceContext(em);
                    PersistenceMessages.finerPPMPropagatePC(this.pu.getName(), em);
                    map.put(this.pu.getName(), em);
                    tx.registerSynchronization((Synchronization)new TransactionCleanup(this.pu, em));
                }
            }
            catch (Exception e) {
                throw EJBUtils.createEJBException(e);
            }
        }
        return em;
    }

    protected EntityManager createEntityManager() {
        return (EntityManager)this.pu.createTempPersistenceContext(this.getProperties());
    }

    protected void releaseEntityManager(EntityManager em) {
        if (EJBTransactionManager.getTransaction() == null) {
            this.pu.closeTempPersistenceContext(em);
        }
    }

    public String getType() {
        return "TRANSACTION";
    }

    public PersistenceUnit getPersistenceUnit() {
        return this.pu;
    }

    public Object getDelegate() {
        if (EJBTransactionManager.getTransaction() != null) {
            return this.allocateEntityManager();
        }
        return null;
    }

    static class TransactionCleanup
    implements Synchronization {
        PersistenceUnit pu;
        Object pc;

        public TransactionCleanup(PersistenceUnit pu, Object pc) {
            this.pu = pu;
            this.pc = pc;
        }

        public void beforeCompletion() {
        }

        public void afterCompletion(int status) {
            this.pu.closeTempPersistenceContext(this.pc);
        }
    }
}

