/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.ejb.logging;

import com.evermind.server.ejb.database.TableView;
import com.evermind.server.ejb.deployment.BeanDescriptor;
import com.evermind.server.ejb.deployment.EJBPackage;
import com.evermind.server.ejb.logging.EJBMessages;
import com.evermind.server.ejb.logging.i18n.EJBCompilationMessageBundle;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.j2ee.util.CustomerLogger;

public class EJBCompilationMessages
extends EJBMessages {
    private static Logger m_logger = CustomerLogger.getLogger("oracle.j2ee.ejb.compilation", EJBCompilationMessageBundle.class.getName());

    public static void infoAutoCreateTable(EJBPackage pkg, String createTableStatement) {
        if (EJBCompilationMessages.isLoggable(Level.INFO)) {
            m_logger.log(Level.INFO, "J2EE EJB-00001", new Object[]{EJBCompilationMessages.getApplicationName(pkg), EJBCompilationMessages.getModuleName(pkg), createTableStatement});
        }
    }

    public static void infoAutoDeleteTable(EJBPackage pkg, TableView table) {
        if (EJBCompilationMessages.isLoggable(Level.INFO)) {
            m_logger.log(Level.INFO, "J2EE EJB-00002", new Object[]{EJBCompilationMessages.getApplicationName(pkg), EJBCompilationMessages.getModuleName(pkg), table.getTable().getName()});
        }
    }

    public static void warningPrintMessage() {
        m_logger.log(Level.WARNING, "J2EE EJB-00004");
    }

    public static void warningPrintSQLState(String sqlState) {
        if (EJBCompilationMessages.isLoggable(Level.WARNING)) {
            m_logger.log(Level.WARNING, "J2EE EJB-00003", new Object[]{sqlState});
        }
    }

    public static void warningPrintSQLMessage(String sqlMessage) {
        if (EJBCompilationMessages.isLoggable(Level.WARNING)) {
            m_logger.log(Level.WARNING, "J2EE EJB-00004", new Object[]{sqlMessage});
        }
    }

    public static void warningPrintSQLVendor(int errorCode) {
        if (EJBCompilationMessages.isLoggable(Level.WARNING)) {
            m_logger.log(Level.WARNING, "J2EE EJB-00005", new Object[]{new Integer(errorCode)});
        }
    }

    public static void severeGetDataSourceName(EJBPackage pkg, String message) {
        if (EJBCompilationMessages.isLoggable(Level.SEVERE)) {
            m_logger.log(Level.SEVERE, "J2EE EJB-00006", new Object[]{EJBCompilationMessages.getApplicationName(pkg), EJBCompilationMessages.getModuleName(pkg), message});
        }
    }

    public static void severeGetDataSourceType(BeanDescriptor desc, String message) {
        if (EJBCompilationMessages.isLoggable(Level.SEVERE)) {
            m_logger.log(Level.SEVERE, "J2EE EJB-00007", new Object[]{EJBCompilationMessages.getApplicationName(desc), EJBCompilationMessages.getModuleName(desc), EJBCompilationMessages.getBeanName(desc), message});
        }
    }

    public static void warningCreateWrapperDir(EJBPackage pkg, String wrapperDir, String path, String message) {
        if (EJBCompilationMessages.isLoggable(Level.WARNING)) {
            m_logger.log(Level.WARNING, "J2EE EJB-00008", new Object[]{EJBCompilationMessages.getApplicationName(pkg), EJBCompilationMessages.getModuleName(pkg), wrapperDir, path, message});
        }
    }

    public static void warningWrapperDirPermission(EJBPackage pkg, String wrapperDir, String path) {
        if (EJBCompilationMessages.isLoggable(Level.WARNING)) {
            m_logger.log(Level.WARNING, "J2EE EJB-00009", new Object[]{EJBCompilationMessages.getApplicationName(pkg), EJBCompilationMessages.getModuleName(pkg), wrapperDir, path});
        }
    }

    public static void finerGeneratedStubs(EJBPackage pkg, Vector files) {
        if (EJBCompilationMessages.isLoggable(Level.FINER)) {
            m_logger.log(Level.FINER, "J2EE EJB-00010", new Object[]{EJBCompilationMessages.getApplicationName(pkg), EJBCompilationMessages.getModuleName(pkg), files});
        }
    }

    private static boolean isLoggable(Level level) {
        return m_logger.isLoggable(level);
    }
}

