/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.ejb.deployment;

import com.evermind.server.ejb.deployment.BeanDescriptor;
import com.evermind.server.ejb.deployment.ExposableBeanDescriptorXMLFactory;
import com.evermind.server.ejb.deployment.InitMethod;
import com.evermind.server.ejb.deployment.InvalidEJBAssemblyException;
import com.evermind.server.ejb.deployment.MethodDescriptor;
import com.evermind.server.ejb.deployment.RemoveMethod;
import com.evermind.server.ejb.deployment.SessionBeanDescriptor;
import com.evermind.server.ejb.logging.EJBDeploymentMessages;
import com.evermind.xml.XMLUtils;
import com.oracle.bricks.j2ee.ReplicationPolicy;
import java.io.IOException;
import java.io.PrintWriter;
import org.w3c.dom.Node;

public class SessionBeanDescriptorXMLFactory
extends ExposableBeanDescriptorXMLFactory {
    private static SessionBeanDescriptorXMLFactory instance = new SessionBeanDescriptorXMLFactory();

    private SessionBeanDescriptorXMLFactory() {
    }

    public static SessionBeanDescriptorXMLFactory getInstance() {
        return instance;
    }

    protected boolean parseEJBJarXMLNode(BeanDescriptor desc, Node node) throws InstantiationException {
        String name = node.getNodeName();
        String value = XMLUtils.getStringValue(node);
        boolean ejb30 = desc.getEJBPackage().getCompatibility() >= 3;
        SessionBeanDescriptor descriptor = (SessionBeanDescriptor)desc;
        if (name.equals("session-type")) {
            this.parseSessionType(desc, value);
        } else if (name.equals("service-endpoint")) {
            descriptor.setServiceEndpointName(value);
        } else if (name.equals("transaction-type")) {
            this.parseTransactionType(desc, value);
        } else {
            if (ejb30 && name.equals("callback-listener")) {
                throw new InstantiationException("<callback-listener> has been removed from the spec and is unsupported.  Please place your callbacks on an interceptor class and use <interceptor> and <interceptor-binding> instead.");
            }
            if (ejb30 && name.equals("remove-method")) {
                this.parseRemoveMethod(descriptor, node);
            } else if (!ejb30 || !descriptor.getBeanInterceptor().parseCallbackMethod(desc, name, node)) {
                if (ejb30 && name.equals("timeout-method")) {
                    String methodName = XMLUtils.getSubnodeValue(node, "method-name");
                    if (methodName == null) {
                        throw new InvalidEJBAssemblyException("Missing <method-name> from <timeout-method>");
                    }
                    descriptor.setTimeoutMethodName(methodName);
                } else if (ejb30 && name.equals("init-method")) {
                    this.parseInitMethod(descriptor, node);
                } else {
                    return super.parseEJBJarXMLNode(descriptor, node);
                }
            }
        }
        return true;
    }

    protected void parseSessionType(BeanDescriptor desc, String type) throws InstantiationException {
        int beanType = 4;
        if (type.equalsIgnoreCase("Stateful")) {
            beanType = 1;
        } else if (type.equalsIgnoreCase("Stateless")) {
            beanType = 2;
        } else {
            throw new InvalidEJBAssemblyException("Invalid <session-type>, type=" + type, "Appendix B.2");
        }
        if (desc.getBeanType() == 4) {
            desc.setBeanType(beanType);
        } else if (desc.getBeanType() != beanType) {
            throw new InstantiationException("[" + desc.getContextId() + "] - According to EJB 3.0 Spec (Core Contract) section 18.2., session bean type cannot be overridden in deployment descriptor");
        }
    }

    protected void parseRemoveMethod(SessionBeanDescriptor desc, Node node) throws InstantiationException {
        Node beanNode = XMLUtils.getSubnode(node, "bean-method");
        if (beanNode == null) {
            throw new InstantiationException("Missing <bean-method> tag under <remove-method> for bean" + desc.getName());
        }
        String beanName = null;
        MethodDescriptor methodDesc = new MethodDescriptor(beanName);
        methodDesc.parseEjbJarXml(beanNode);
        if (methodDesc.getName() == null || methodDesc.getName().equals("*")) {
            throw new InstantiationException("Missing or null <method-name> tag under <remove-method> for bean" + desc.getName());
        }
        boolean retainIfExc = Boolean.valueOf(XMLUtils.getSubnodeValue(node, "retain-if-exception"));
        desc.getRemoveMethods().add(new RemoveMethod(methodDesc, retainIfExc));
    }

    protected boolean parseOracleEJBJarXMLAttribute(BeanDescriptor desc, String name, String value) throws InstantiationException {
        SessionBeanDescriptor descriptor = (SessionBeanDescriptor)desc;
        if (name.equals("replication")) {
            if (value != "inherited") {
                descriptor.setReplicationPolicy(new ReplicationPolicy());
                descriptor.getReplicationPolicy().setReplicationTrigger(ReplicationPolicy.convertReplicationTrigger(value));
            }
        } else if (name.equals("persistence-filename")) {
            descriptor.setPersistenceFilename(value);
        } else if (!name.equals("home")) {
            if (name.equals("transaction-timeout")) {
                descriptor.setTransactionTimeout(XMLUtils.parseInt("transaction-timeout", value));
            } else if (name.equals("timeout") || name.equals("idletime") || name.equals("memory-threshold") || name.equals("max-instances-threshold") || name.equals("resource-check-interval") || name.equals("passivate-count")) {
                if (!descriptor.isStateful()) {
                    EJBDeploymentMessages.warningStatefulSessionBeanTags(descriptor, name);
                } else if (name.equals("timeout")) {
                    descriptor.setTimeout(this.parseNeverStringOrInt(name, value));
                } else if (name.equals("idletime")) {
                    descriptor.setIdletime(this.parseNeverStringOrInt(name, value));
                } else if (name.equals("memory-threshold")) {
                    descriptor.setMemoryThreshold(this.parseNeverStringOrInt(name, value));
                } else if (name.equals("max-instances-threshold")) {
                    descriptor.setMaxInstancesThreshold(this.parseNeverStringOrInt(name, value));
                } else if (name.equals("resource-check-interval")) {
                    descriptor.setResourceCheckInterval(this.parseNeverStringOrInt(name, value));
                } else if (name.equals("passivate-count")) {
                    descriptor.setPassivateCount(this.parseNeverStringOrInt(name, value));
                }
            } else if (descriptor.getEJBPackage().getCompatibility() >= 3 && name.equals("interceptor-type")) {
                descriptor.setInterceptorType(value);
            } else {
                return super.parseOracleEJBJarXMLAttribute(descriptor, name, value);
            }
        }
        return true;
    }

    public void writeOracleEJBJarXML(BeanDescriptor desc, PrintWriter out, String indentation) throws IOException {
        out.println(indentation + "<" + "session-deployment" + this.getOracleEJBJarXMLAttributes(desc) + ">");
        super.writeOracleEJBJarXML(desc, out, indentation);
        out.println(indentation + "</" + "session-deployment" + ">");
    }

    public void writeEJBJarXML(BeanDescriptor descriptor, PrintWriter out, String indentation) throws IOException {
        out.println(indentation + "<" + "session" + ">");
        super.writeEJBJarXML(descriptor, out, indentation);
        out.println(indentation + "</" + "session" + ">");
    }

    protected String getOracleEJBJarXMLAttributes(BeanDescriptor desc) {
        SessionBeanDescriptor descriptor = (SessionBeanDescriptor)desc;
        StringBuffer attributes = new StringBuffer(super.getOracleEJBJarXMLAttributes(desc));
        if (descriptor.isStateful()) {
            if (descriptor.getTimeout() != 1800) {
                this.appendAttribute("timeout", this.getIntAsStringOrNever(descriptor.getTimeout()), attributes);
            }
            if (descriptor.getIdletime() != 300) {
                this.appendAttribute("idletime", this.getIntAsStringOrNever(descriptor.getIdletime()), attributes);
            }
            if (descriptor.getMemoryThreshold() != 80) {
                this.appendAttribute("memory-threshold", this.getIntAsStringOrNever(descriptor.getMemoryThreshold()), attributes);
            }
            if (descriptor.getMaxInstancesThreshold() != 90) {
                this.appendAttribute("max-instances-threshold", this.getIntAsStringOrNever(descriptor.getMaxInstancesThreshold()), attributes);
            }
            if (descriptor.getResourceCheckInterval() != 180) {
                this.appendAttribute("resource-check-interval", this.getIntAsStringOrNever(descriptor.getResourceCheckInterval()), attributes);
            }
            if (descriptor.getPassivateCount() >= 0) {
                this.appendAttribute("passivate-count", String.valueOf(descriptor.getPassivateCount()), attributes);
            }
        }
        if (descriptor.getTransactionTimeout() != -1) {
            this.appendAttribute("transaction-timeout", String.valueOf(descriptor.getTransactionTimeout()), attributes);
        }
        if (descriptor.getPersistenceFilename() != null) {
            this.appendAttribute("persistence-filename", descriptor.getPersistenceFilename(), attributes);
        } else {
            this.appendAttribute("persistence-filename", "[NONE]", attributes);
        }
        if (!descriptor.getReplicationPolicy().isNone()) {
            if (descriptor.getReplicationPolicy().isOnSetAttribute()) {
                descriptor.getReplicationPolicy().setReplicationTrigger(4);
                EJBDeploymentMessages.warningReplicationTriggerReset(ReplicationPolicy.getReplicationTriggerName(5), ReplicationPolicy.getReplicationTriggerName(4));
            }
            this.appendAttribute("replication", descriptor.getReplicationPolicy().getReplicationTriggerName(), attributes);
        }
        if (descriptor.getInterceptorType() != "default") {
            this.appendAttribute("interceptor-type", descriptor.getInterceptorType(), attributes);
        }
        return attributes.toString();
    }

    protected void writeBeanSpecificEJBJarXMLTags(BeanDescriptor descriptor, PrintWriter out, String indentation) throws IOException {
        super.writeBeanSpecificEJBJarXMLTags(descriptor, out, indentation);
        this.writeTag("session-type", descriptor.getBeanTypeString(), out, indentation);
        this.writeTag("transaction-type", this.getTransactionTypeString(descriptor.getTransactionType()), out, indentation);
    }

    protected void validateBeanTypeOverridden(BeanDescriptor descriptor, Node rootNode, boolean isEjbJar) throws InstantiationException {
        if (isEjbJar && !rootNode.getNodeName().equals("session") || !isEjbJar && !rootNode.getNodeName().equals("session-deployment")) {
            this.failOnBeanTypeMismatch(descriptor, rootNode.getNodeName(), isEjbJar);
        }
    }

    protected void parseInitMethod(SessionBeanDescriptor desc, Node node) throws InstantiationException {
        Node beanMethodNode = XMLUtils.getSubnode(node, "bean-method");
        if (beanMethodNode == null) {
            throw new InstantiationException("Missing <bean-method> tag under <init-method> for bean" + desc.getName());
        }
        String beanName = null;
        MethodDescriptor initMethodDesc = new MethodDescriptor(beanName);
        initMethodDesc.parseEjbJarXml(beanMethodNode);
        if (initMethodDesc.getName() == null || initMethodDesc.getName().equals("*")) {
            throw new InstantiationException("Missing or null <method-name> tag under <init-method> for bean" + desc.getName());
        }
        Node createMethodNode = XMLUtils.getSubnode(node, "create-method");
        String createMethodName = null;
        if (createMethodNode == null) {
            createMethodName = "";
        } else {
            MethodDescriptor createMethodDesc = new MethodDescriptor(beanName);
            createMethodDesc.parseEjbJarXml(createMethodNode);
            if (createMethodDesc.getName() == null || createMethodDesc.getName().equals("*")) {
                throw new InstantiationException("Missing or null <method-name> tag under <create-method> for bean" + desc.getName());
            }
            createMethodName = createMethodDesc.getName();
        }
        desc.getInitMethods().add(new InitMethod(initMethodDesc, createMethodName));
    }
}

