/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.ejb.deployment;

import com.evermind.server.ejb.exception.DeploymentException;
import com.evermind.server.ejb.logging.DiagnosticContext;
import com.evermind.util.AbstractDescribable;
import com.evermind.xml.XMLUtils;
import com.evermind.xml.XMLizable;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import oracle.oc4j.configuration.J2EEContextConfigDelegate;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class InterceptorDescriptor
implements XMLizable {
    private String interceptorClassName;
    private String description;
    private J2EEContextConfigDelegate configDelegate = new J2EEContextConfigDelegate(new AbstractDescribable(){});
    private List aroundInvokeMethods;
    private List postConstructMethods;
    private List preDestroyMethods;
    private List postActivateMethods;
    private List prePassivateMethods;

    public String getInterceptorClassName() {
        return this.interceptorClassName;
    }

    public boolean hasClassName() {
        return this.interceptorClassName != null;
    }

    public List getAroundInvokeMethods() {
        if (this.aroundInvokeMethods == null) {
            return Collections.EMPTY_LIST;
        }
        return this.aroundInvokeMethods;
    }

    public List getPostConstructMethods() {
        if (this.postConstructMethods == null) {
            return Collections.EMPTY_LIST;
        }
        return this.postConstructMethods;
    }

    public List getPreDestroyMethods() {
        if (this.preDestroyMethods == null) {
            return Collections.EMPTY_LIST;
        }
        return this.preDestroyMethods;
    }

    public List getPostActivateMethods() {
        if (this.postActivateMethods == null) {
            return Collections.EMPTY_LIST;
        }
        return this.postActivateMethods;
    }

    public List getPrePassivateMethods() {
        if (this.prePassivateMethods == null) {
            return Collections.EMPTY_LIST;
        }
        return this.prePassivateMethods;
    }

    public String getDescription() {
        return this.description;
    }

    public InterceptorDescriptor parseEJBJarXML(DiagnosticContext ctx, Node callbackNode) throws InstantiationException {
        NodeList nodes = callbackNode.getChildNodes();
        for (int i = 0; nodes != null && i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            String name = node.getNodeName();
            if (XMLUtils.isCommentOrID(name)) continue;
            if (name.equals("description")) {
                InterceptorDescriptor.checkForDuplicateTag(ctx, this.getDescription(), "description");
                this.setDescription(XMLUtils.getStringValue(node));
                continue;
            }
            if (name.equals("interceptor-class")) {
                InterceptorDescriptor.checkForDuplicateTag(ctx, this.getInterceptorClassName(), "interceptor-class");
                this.setInterceptorClassName(XMLUtils.getStringValue(node));
                continue;
            }
            if (this.parseCallbackMethod(ctx, name, node) || this.configDelegate.parseNode(node)) continue;
            throw DeploymentException.unknownXmlSubtag(ctx, "interceptor", name);
        }
        if (this.getInterceptorClassName() == null) {
            throw DeploymentException.interceptorClassNotDefined(ctx);
        }
        this.verifyCallbackSet(ctx);
        return this;
    }

    public void verifyCallbackSet(DiagnosticContext id) {
        if (this.getAroundInvokeMethods().isEmpty() && this.getPostConstructMethods().isEmpty() && this.getPreDestroyMethods().isEmpty() && this.getPostActivateMethods().isEmpty() && this.getPrePassivateMethods().isEmpty()) {
            throw DeploymentException.missingAroundInvokeOrCallback(id, this.getInterceptorClassName() == null ? "bean" : this.getInterceptorClassName());
        }
    }

    public boolean parseCallbackMethod(DiagnosticContext ctx, String name, Node node) {
        if (name.equals("around-invoke")) {
            String methodName = XMLUtils.getSubnodeValue(node, "method-name");
            String declaringClass = XMLUtils.getSubnodeValue(node, "class");
            InterceptorDescriptor.checkMissingMethodName(ctx, name, methodName);
            this.addAroundInvokeMethod(methodName, declaringClass);
        } else {
            String methodName = XMLUtils.getSubnodeValue(node, "lifecycle-callback-method");
            String declaringClass = XMLUtils.getSubnodeValue(node, "lifecycle-callback-class");
            if (name.equals("post-construct")) {
                InterceptorDescriptor.checkMissingMethodName(ctx, name, methodName);
                this.addPostConstructMethod(methodName, declaringClass);
            } else if (name.equals("pre-destroy")) {
                InterceptorDescriptor.checkMissingMethodName(ctx, name, methodName);
                this.addPreDestroyMethod(methodName, declaringClass);
            } else if (name.equals("post-activate")) {
                InterceptorDescriptor.checkMissingMethodName(ctx, name, methodName);
                this.addPostActivateMethod(methodName, declaringClass);
            } else if (name.equals("pre-passivate")) {
                InterceptorDescriptor.checkMissingMethodName(ctx, name, methodName);
                this.addPrePassivateMethod(methodName, declaringClass);
            } else {
                return false;
            }
        }
        return true;
    }

    private static void checkMissingMethodName(DiagnosticContext ctx, String tagName, String methodName) {
        if (methodName == null) {
            throw DeploymentException.missingOrNullTag(ctx, tagName, "lifecycle-callback-method");
        }
    }

    private static void checkForDuplicateTag(DiagnosticContext ctx, String currentValue, String tagName) {
        if (currentValue != null) {
            throw DeploymentException.duplicateTag(ctx, "interceptor", tagName);
        }
    }

    public void writeXML(PrintWriter out, String indentation) {
        if (this.getInterceptorClassName() != null) {
            out.println(indentation + "<" + "interceptor" + ">");
            if (this.getDescription() != null) {
                this.writeTag("description", this.getDescription(), out, indentation);
            }
            this.writeTag("interceptor-class", this.getInterceptorClassName(), out, indentation);
            this.writeCallbackTags(out, indentation);
            out.println(indentation + "</" + "interceptor" + ">");
        } else {
            this.writeCallbackTags(out, indentation);
        }
    }

    private void writeCallbackTags(PrintWriter out, String indentation) {
        this.writeAroundInvokeMethodTags(this.getAroundInvokeMethods(), out, indentation);
        this.writeCallbackMethodTags("post-construct", this.getPostConstructMethods(), out, indentation);
        this.writeCallbackMethodTags("pre-destroy", this.getPreDestroyMethods(), out, indentation);
        this.writeCallbackMethodTags("post-activate", this.getPostActivateMethods(), out, indentation);
        this.writeCallbackMethodTags("pre-passivate", this.getPrePassivateMethods(), out, indentation);
    }

    protected void writeCallbackMethodTags(String tagName, List tagValues, PrintWriter out, String indentation) {
        Iterator i = tagValues.iterator();
        while (i.hasNext()) {
            InterceptorCallback next = (InterceptorCallback)i.next();
            out.println(indentation + "<" + tagName + ">");
            this.writeTag("lifecycle-callback-class", next.declaringClassName, out, indentation + "\t");
            this.writeTag("lifecycle-callback-method", next.methodName, out, indentation + "\t");
            out.println(indentation + "</" + tagName + ">");
        }
    }

    protected void writeAroundInvokeMethodTags(List tagValues, PrintWriter out, String indentation) {
        Iterator i = tagValues.iterator();
        while (i.hasNext()) {
            InterceptorCallback next = (InterceptorCallback)i.next();
            out.println(indentation + "<" + "around-invoke" + ">");
            this.writeTag("class", next.declaringClassName, out, indentation + "\t");
            this.writeTag("method-name", next.methodName, out, indentation + "\t");
            out.println(indentation + "</" + "around-invoke" + ">");
        }
    }

    protected void writeTag(String tagName, String tagValue, PrintWriter out, String indentation) {
        if (tagValue != null) {
            out.println(indentation + "\t<" + tagName + ">" + XMLUtils.encode(tagValue) + "</" + tagName + ">");
        }
    }

    public void setInterceptorClassName(String className) {
        this.interceptorClassName = className;
    }

    public void addAroundInvokeMethod(String methodName, String declaringClassName) {
        if (this.aroundInvokeMethods == null) {
            this.aroundInvokeMethods = new ArrayList(1);
        }
        if (declaringClassName == null) {
            declaringClassName = this.getInterceptorClassName();
        }
        this.aroundInvokeMethods.add(new InterceptorCallback(methodName, declaringClassName));
    }

    public void addPostConstructMethod(String methodName, String declaringClassName) {
        if (this.postConstructMethods == null) {
            this.postConstructMethods = new ArrayList(1);
        }
        if (declaringClassName == null) {
            declaringClassName = this.getInterceptorClassName();
        }
        this.postConstructMethods.add(new InterceptorCallback(methodName, declaringClassName));
    }

    public void addPreDestroyMethod(String methodName, String declaringClassName) {
        if (this.preDestroyMethods == null) {
            this.preDestroyMethods = new ArrayList(1);
        }
        if (declaringClassName == null) {
            declaringClassName = this.getInterceptorClassName();
        }
        this.preDestroyMethods.add(new InterceptorCallback(methodName, declaringClassName));
    }

    public void addPostActivateMethod(String methodName, String declaringClassName) {
        if (this.postActivateMethods == null) {
            this.postActivateMethods = new ArrayList(1);
        }
        if (declaringClassName == null) {
            declaringClassName = this.getInterceptorClassName();
        }
        this.postActivateMethods.add(new InterceptorCallback(methodName, declaringClassName));
    }

    public void addPrePassivateMethod(String methodName, String declaringClassName) {
        if (this.prePassivateMethods == null) {
            this.prePassivateMethods = new ArrayList(1);
        }
        if (declaringClassName == null) {
            declaringClassName = this.getInterceptorClassName();
        }
        this.prePassivateMethods.add(new InterceptorCallback(methodName, declaringClassName));
    }

    public void setDescription(String desc) {
        this.description = desc;
    }

    public J2EEContextConfigDelegate getConfigDelegate() {
        return this.configDelegate;
    }

    public static class InterceptorCallback {
        public String methodName;
        public String declaringClassName;

        public InterceptorCallback(String methodName, String declaringClassName) {
            this.methodName = methodName;
            this.declaringClassName = declaringClassName;
        }
    }
}

