/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.ejb.deployment;

import com.evermind.server.ejb.deployment.MethodDescriptor;
import com.evermind.server.ejb.exception.DeploymentException;
import com.evermind.server.ejb.logging.DiagnosticContext;
import com.evermind.xml.XMLUtils;
import com.evermind.xml.XMLizable;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class InterceptorBinding
implements XMLizable {
    private String ejbName;
    private String description;
    private boolean excludeDefaultInterceptors = false;
    private boolean excludeClassInterceptors = false;
    private boolean isInterceptorOrderDefined = false;
    private List interceptorClassNames = new ArrayList();
    private MethodDescriptor methodDescriptor;

    public InterceptorBinding() {
    }

    public InterceptorBinding(String ejbName) {
        this.ejbName = ejbName;
    }

    public boolean isDefault() {
        return this.getEjbName().equals("*");
    }

    public boolean isClassLevel() {
        return !this.isDefault() && this.getMethodDescriptor() == null;
    }

    public String getEjbName() {
        return this.ejbName;
    }

    public void setEjbName(String ejbName) {
        this.ejbName = ejbName;
    }

    public String getDescription() {
        return this.description;
    }

    protected void setDescription(String desc) {
        this.description = desc;
    }

    public boolean isExcludeClassInterceptors() {
        return this.excludeClassInterceptors || this.isInterceptorOrderDefined;
    }

    public void setExcludeClassInterceptors(boolean excludeClassInterceptors) {
        this.excludeClassInterceptors = excludeClassInterceptors;
    }

    public boolean isExcludeDefaultInterceptors() {
        return this.excludeDefaultInterceptors || this.isInterceptorOrderDefined;
    }

    public void setExcludeDefaultInterceptors(boolean excludeDefaultInterceptors) {
        this.excludeDefaultInterceptors = excludeDefaultInterceptors;
    }

    public boolean isInterceptorOrderDefined() {
        return this.isInterceptorOrderDefined;
    }

    public List getInterceptorClassNames() {
        return this.interceptorClassNames;
    }

    public MethodDescriptor getMethodDescriptor() {
        return this.methodDescriptor;
    }

    public void setMethodDescriptor(MethodDescriptor methodDesc) {
        this.methodDescriptor = methodDesc;
    }

    public void addInterceptorClassNames(List newInterceptorClassNames) {
        this.interceptorClassNames.addAll(newInterceptorClassNames);
    }

    public void setIsInterceptorOrderDefined(boolean isInterceptorOrderDefined) {
        this.isInterceptorOrderDefined = isInterceptorOrderDefined;
    }

    public InterceptorBinding parseEJBJarXML(DiagnosticContext ctx, Node callbackNode) throws InstantiationException {
        NodeList nodes = callbackNode.getChildNodes();
        for (int i = 0; nodes != null && i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            String name = node.getNodeName();
            if (XMLUtils.isCommentOrID(name)) continue;
            if (name.equals("description")) {
                InterceptorBinding.checkForDuplicateTag(ctx, this.getDescription(), "description");
                this.setDescription(XMLUtils.getStringValue(node));
                continue;
            }
            if (name.equals("ejb-name")) {
                InterceptorBinding.checkForDuplicateTag(ctx, this.getEjbName(), "ejb-name");
                String newEjbName = XMLUtils.getStringValue(node);
                if (newEjbName.compareTo("*") != 0 && newEjbName.indexOf(42) >= 0) {
                    throw DeploymentException.invalidInterceptorBindingEjbName(ctx, newEjbName);
                }
                this.setEjbName(newEjbName);
                continue;
            }
            if (name.equals("interceptor-order")) {
                if (this.isInterceptorOrderDefined()) {
                    throw DeploymentException.duplicateTag(ctx, "interceptor-binding", "interceptor-order");
                }
                this.isInterceptorOrderDefined = true;
                if (!this.getInterceptorClassNames().isEmpty()) {
                    this.checkInterceptorOrderSpecified(ctx, "interceptor-class");
                }
                this.parseInterceptorOrder(ctx, node);
                continue;
            }
            if (name.equals("interceptor-class")) {
                this.checkInterceptorOrderSpecified(ctx, name);
                this.getInterceptorClassNames().add(XMLUtils.getStringValue(node));
                continue;
            }
            if (name.equals("exclude-default-interceptors")) {
                this.setExcludeDefaultInterceptors(XMLUtils.getStringValue(node).equals("true"));
                if (this.excludeDefaultInterceptors) continue;
                this.checkInterceptorOrderSpecified(ctx, name);
                continue;
            }
            if (name.equals("exclude-class-interceptors")) {
                this.setExcludeClassInterceptors(XMLUtils.getStringValue(node).equals("true"));
                if (this.excludeClassInterceptors) continue;
                this.checkInterceptorOrderSpecified(ctx, name);
                continue;
            }
            if (name.equals("method")) {
                InterceptorBinding.checkForDuplicateTag(ctx, this.getMethodDescriptor(), "method");
                this.setMethodDescriptor(new MethodDescriptor(this.getEjbName()));
                this.getMethodDescriptor().parseEjbJarXml(node);
                continue;
            }
            throw DeploymentException.unknownXmlSubtag(ctx, "interceptor-binding", name);
        }
        if (this.getEjbName() == null) {
            throw DeploymentException.missingInterceptorBindingEjbName(ctx);
        }
        if (this.isDefault() && this.getMethodDescriptor() != null) {
            throw DeploymentException.defaultBindingWithMethod(ctx);
        }
        return this;
    }

    private static void checkForDuplicateTag(DiagnosticContext ctx, Object currentValue, String tagName) {
        if (currentValue != null) {
            throw DeploymentException.duplicateTag(ctx, "interceptor-binding", tagName);
        }
    }

    private void checkInterceptorOrderSpecified(DiagnosticContext ctx, String tagName) {
        if (this.isInterceptorOrderDefined()) {
            throw DeploymentException.illegalTagUsedWithInterceptorOrder(ctx, tagName);
        }
    }

    private void parseInterceptorOrder(DiagnosticContext ctx, Node orderNode) {
        NodeList nodes = orderNode.getChildNodes();
        for (int i = 0; nodes != null && i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            String name = node.getNodeName();
            if (XMLUtils.isCommentOrID(name)) continue;
            if (name.equals("interceptor-class")) {
                this.getInterceptorClassNames().add(XMLUtils.getStringValue(node));
                continue;
            }
            throw DeploymentException.unknownXmlSubtag(ctx, "interceptor-order", name);
        }
    }

    public void writeXML(PrintWriter out, String indentation) {
        out.println(indentation + "<" + "interceptor-binding" + ">");
        InterceptorBinding.writeTag("description", this.getDescription(), out, indentation);
        InterceptorBinding.writeTag("ejb-name", this.getEjbName(), out, indentation);
        Iterator iter = this.getInterceptorClassNames().iterator();
        if (this.isInterceptorOrderDefined()) {
            out.println(indentation + "\t<" + "<" + "interceptor-order" + ">");
            while (iter.hasNext()) {
                InterceptorBinding.writeTag("interceptor-class", (String)iter.next(), out, indentation + "\t<");
            }
            out.println(indentation + "\t<" + "</" + "interceptor-order" + ">");
        } else {
            while (iter.hasNext()) {
                InterceptorBinding.writeTag("interceptor-class", (String)iter.next(), out, indentation);
            }
            InterceptorBinding.writeTag("exclude-default-interceptors", String.valueOf(this.isExcludeDefaultInterceptors()), out, indentation);
            InterceptorBinding.writeTag("exclude-class-interceptors", String.valueOf(this.isExcludeClassInterceptors()), out, indentation);
        }
        this.writeMethodTag(out, indentation);
        out.println(indentation + "</" + "interceptor-binding" + ">");
    }

    private static void writeTag(String tagName, String tagValue, PrintWriter out, String indentation) {
        if (tagValue != null) {
            out.println(indentation + "\t<" + tagName + ">" + XMLUtils.encode(tagValue) + "</" + tagName + ">");
        }
    }

    private void writeMethodTag(PrintWriter out, String indentation) {
        if (this.getMethodDescriptor() != null) {
            indentation = indentation + "\t";
            out.println(indentation + "<" + "method" + ">");
            InterceptorBinding.writeTag("method-name", this.getMethodDescriptor().getName(), out, indentation);
            String[] params = this.getMethodDescriptor().getParameterNames();
            if (params != null) {
                out.println(indentation + "\t<" + "method-params" + ">");
                for (int i = 0; i < params.length; ++i) {
                    InterceptorBinding.writeTag("method-param", params[i], out, indentation + "\t\t");
                }
                out.println(indentation + "\t</" + "method-params" + ">");
            }
            out.println(indentation + "</" + "method" + ">");
        }
    }

    public String toString() {
        StringBuffer bindingStr = new StringBuffer("InterceptorBinding:");
        bindingStr.append("[EjbName:");
        bindingStr.append(this.ejbName);
        bindingStr.append("[MethodName:");
        bindingStr.append(this.methodDescriptor == null ? null : this.methodDescriptor.toString());
        bindingStr.append("[excludeDefaultInterceptors:");
        bindingStr.append(this.excludeDefaultInterceptors);
        bindingStr.append("]");
        bindingStr.append("[excludeClassInterceptors:");
        bindingStr.append(this.excludeClassInterceptors);
        bindingStr.append("]");
        bindingStr.append("[interceptorClassNames:");
        bindingStr.append(this.interceptorClassNames.toString());
        return bindingStr.toString();
    }
}

