/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.ejb.deployment;

import com.evermind.server.ejb.deployment.EJBQuery;
import com.evermind.server.ejb.deployment.EntityBeanDescriptor;
import com.evermind.server.ejb.deployment.InvalidEJBAssemblyException;
import com.evermind.server.ejb.deployment.MethodDescriptor;
import com.evermind.xml.XMLUtils;
import com.sun.enterprise.deployment.EjbCMPEntityDescriptor;
import com.sun.enterprise.deployment.QueryDescriptor;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Hashtable;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class FinderMethod {
    protected MethodDescriptor method;
    protected String orionQuery = "";
    protected boolean partial = true;
    protected boolean lazyLoading = false;
    protected boolean lazyLoading_specified = false;
    protected int prefetchSize = 0;
    protected String sqlData_OnlyPK;
    protected String sqlData_AllColumns;
    protected EJBQuery ejbQuery;
    protected int cacheTimeout = 0;
    protected boolean used;
    private Hashtable tables;
    private QueryDescriptor queryDescriptor;

    public FinderMethod(Node parent) throws InstantiationException {
        String cacheTimeoutString;
        String prefetchSizeString;
        NodeList nodes = parent.getChildNodes();
        String orionQuery = XMLUtils.getNodeAttribute(parent, "query");
        if (orionQuery != null) {
            this.orionQuery = orionQuery;
        }
        this.partial = !"false".equalsIgnoreCase(XMLUtils.getNodeAttribute(parent, "partial"));
        String lazy_loading_value = XMLUtils.getNodeAttribute(parent, "lazy-loading");
        if (lazy_loading_value != null) {
            this.lazyLoading_specified = true;
            this.lazyLoading = lazy_loading_value.equalsIgnoreCase("true");
        }
        if ((prefetchSizeString = XMLUtils.getNodeAttribute(parent, "prefetch-size")) != null) {
            this.prefetchSize = XMLUtils.parseInt("prefetch-size", prefetchSizeString);
        }
        if ((cacheTimeoutString = XMLUtils.getNodeAttribute(parent, "cache-timeout")) != null) {
            this.cacheTimeout = XMLUtils.parseInt("cache-timeout", cacheTimeoutString);
        }
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            String name = node.getNodeName();
            if (XMLUtils.isCommentOrID(name) || !name.equals("method")) continue;
            this.method = new MethodDescriptor(node);
        }
        if (this.method == null) {
            throw new InvalidEJBAssemblyException("finder-method tag with missing method subtag", "22.5");
        }
    }

    public FinderMethod(String beanName, Method method, String orionQuery, boolean partial, boolean _lazyLoading, boolean _lazyLoading_specified) {
        this.method = new MethodDescriptor(beanName, method, 0);
        this.orionQuery = orionQuery;
        this.partial = partial;
        this.lazyLoading = _lazyLoading;
        this.lazyLoading_specified = _lazyLoading_specified;
    }

    private FinderMethod(String beanName, Method method, QueryDescriptor qd, boolean _lazyLoading, boolean _lazyLoading_specified) {
        this(beanName, method, null, true, _lazyLoading, _lazyLoading_specified);
        this.setQueryDescriptor(qd);
    }

    public MethodDescriptor getMethod() {
        return this.method;
    }

    public static String[] StringSplit_jdk14(String origString, String expression) {
        int length;
        int next;
        ArrayList<String> al = new ArrayList<String>();
        int prev = 0;
        while ((next = origString.indexOf(expression, prev)) != -1) {
            al.add(origString.substring(prev, next));
            prev = next + expression.length();
        }
        al.add(origString.substring(prev));
        int sz = al.size();
        for (length = sz - 1; length >= 0; --length) {
            String xx = (String)al.get(length);
            if (!((String)al.get(length)).equals("")) break;
        }
        String[] ans = new String[++length];
        for (int x = 0; x < ans.length; ++x) {
            ans[x] = (String)al.get(x);
        }
        return ans;
    }

    public Hashtable getTables() {
        if (this.tables == null) {
            this.tables = new Hashtable();
            String aFromClause = this.getFromClauseTables();
            if (aFromClause != null) {
                String[] anOuterToken = FinderMethod.StringSplit_jdk14(aFromClause, ",");
                for (int i = 0; i < anOuterToken.length; ++i) {
                    String[] anInnerToken = FinderMethod.StringSplit_jdk14(anOuterToken[i].trim(), " ");
                    if (anInnerToken.length <= 1) continue;
                    this.tables.put(anInnerToken[0], anInnerToken[1]);
                }
            }
        }
        return this.tables;
    }

    private String getFromClauseTables() {
        StringBuffer aBuffer = this.getFromClause();
        if (aBuffer == null || aBuffer.length() == 0) {
            return null;
        }
        int anEndOfFrom = aBuffer.toString().toUpperCase().indexOf("FROM") + 4;
        if (aBuffer != null) {
            aBuffer.delete(0, anEndOfFrom);
        }
        return aBuffer.toString().trim();
    }

    private StringBuffer getFromClause() {
        int aGroupEnd;
        int anOrderEnd;
        int anEnd;
        if (this.getOrionQuery() == null) {
            return null;
        }
        StringBuffer aQuery = new StringBuffer(this.getOrionQuery().toUpperCase());
        if (aQuery == null || aQuery.length() == 0) {
            return null;
        }
        int aBegin = aQuery.toString().toUpperCase().indexOf("FROM");
        if (aBegin == -1) {
            return null;
        }
        aQuery.delete(0, aBegin);
        int aSubSelect = aQuery.toString().toUpperCase().indexOf("(");
        if (aSubSelect != -1) {
            aQuery.delete(aSubSelect, aQuery.toString().length());
        }
        if ((anEnd = aQuery.toString().toUpperCase().indexOf("WHERE")) != -1) {
            aQuery.delete(anEnd, aQuery.toString().length());
        }
        if ((anOrderEnd = aQuery.toString().toUpperCase().indexOf("ORDER")) != -1) {
            aQuery.delete(anOrderEnd, aQuery.toString().length());
        }
        if ((aGroupEnd = aQuery.toString().toUpperCase().indexOf("GROUP")) != -1) {
            aQuery.delete(aGroupEnd, aQuery.toString().length());
        }
        return aQuery;
    }

    public String getAliasFor(String aTableName) {
        if (aTableName == null) {
            return null;
        }
        Object anObject = this.getTables().get(aTableName.toUpperCase());
        if (anObject == null) {
            return null;
        }
        return anObject.toString();
    }

    public void writeOrionXML(PrintWriter out, String indention) throws IOException {
        out.print(indention + "<finder-method");
        if (this.orionQuery != null) {
            out.print(" query=\"" + XMLUtils.encode(this.orionQuery) + "\"");
        }
        if (!this.partial) {
            out.print(" partial=\"false\"");
        }
        if (this.lazyLoading_specified) {
            if (!this.lazyLoading) {
                out.print(" lazy-loading=\"false\"");
            } else {
                out.print(" lazy-loading=\"true\"");
            }
        }
        if (this.prefetchSize > 0) {
            out.print(" prefetch-size=\"" + this.prefetchSize + "\"");
        }
        if (this.cacheTimeout > 0) {
            out.print(" cache-timeout=\"" + this.cacheTimeout + "\"");
        }
        out.println(">");
        if (this.sqlData_OnlyPK != null) {
            out.println(indention + "\t<!-- Generated SQL (pk only): " + this.sqlData_OnlyPK + " -->");
        }
        if (this.sqlData_AllColumns != null) {
            out.println(indention + "\t<!-- Generated SQL (all columns): " + this.sqlData_AllColumns + " -->");
        }
        this.method.writeXML(out, indention + "\t");
        out.println(indention + "</finder-method>");
    }

    public void setOnlyPKSQLData(String data) {
        this.sqlData_OnlyPK = data;
    }

    public void setAllColumnsSQLData(String data) {
        this.sqlData_AllColumns = data;
    }

    public String getOrionQuery() {
        return this.orionQuery;
    }

    public boolean isPartial() {
        return this.partial;
    }

    public boolean isLazyLoading() {
        return this.lazyLoading;
    }

    public boolean isLazyLoading_specified() {
        return this.lazyLoading_specified;
    }

    public EJBQuery getEJBQuery() {
        return this.ejbQuery;
    }

    public void setEJBQuery(EJBQuery query) {
        this.ejbQuery = query;
    }

    public void setPartial(boolean partial) {
        this.partial = partial;
    }

    public int getPrefetchSize() {
        return this.prefetchSize;
    }

    public void setPrefetchSize(int size) {
        this.prefetchSize = size;
    }

    public int getCacheTimeout() {
        return this.cacheTimeout;
    }

    public void setUsed(boolean used) {
        this.used = used;
    }

    public boolean isUsed() {
        return this.used;
    }

    public void setQueryDescriptor(QueryDescriptor value) {
        this.queryDescriptor = value;
    }

    public QueryDescriptor getQueryDescriptor() {
        return this.queryDescriptor;
    }

    public static FinderMethod lookupEjbqlFinderMethod(EntityBeanDescriptor ebd, Method method, String query, boolean partial, boolean _lazyLoading, boolean _lazyLoading_specified) {
        if (query.equals("")) {
            try {
                QueryDescriptor qd = ((EjbCMPEntityDescriptor)ebd.getEjbqlDescriptor()).getPersistenceDescriptor().getQueryFor(method);
                return new FinderMethod(ebd.getName(), method, qd, _lazyLoading, _lazyLoading_specified);
            }
            catch (Exception ejbqle) {
                // empty catch block
            }
        }
        return new FinderMethod(ebd.getName(), method, query, partial, _lazyLoading, _lazyLoading_specified);
    }
}

