/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.ejb.compilation;

import com.evermind.compiler.CompilationException;
import com.evermind.server.ejb.compilation.CustomFinderMethodCompilation;
import com.evermind.server.ejb.deployment.BeanDescriptor;
import com.evermind.server.ejb.deployment.ContainerManagedField;
import com.evermind.server.ejb.deployment.EntityBeanDescriptor;
import com.evermind.server.ejb.deployment.FinderMethod;
import com.evermind.server.ejb.deployment.PrimaryKeyContext;
import com.sun.ejb.ejbql.QueryParam;
import com.sun.enterprise.deployment.QueryDescriptor;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class OrionQueryParameter {
    public String name;
    public ContainerManagedField field;
    public PrimaryKeyContext context;
    public int queryParameterID;

    public OrionQueryParameter(String var, CustomFinderMethodCompilation compilation) throws CompilationException {
        try {
            this.queryParameterID = Integer.parseInt(var);
            if (this.queryParameterID < 1 || this.queryParameterID - 1 >= compilation.method.getParameterTypes().length) {
                throw new CompilationException("Illegal $number in finder query: $" + this.queryParameterID);
            }
            compilation.preparedArgs.add(new Integer(this.queryParameterID - 1));
        }
        catch (NumberFormatException e) {
            BeanDescriptor descriptor;
            this.context = compilation.bean;
            int dotIndex = var.indexOf(46);
            String subVar = var;
            if (dotIndex >= 0) {
                subVar = var.substring(0, dotIndex);
            }
            this.field = this.context.getContainerManagedField(subVar, this.context);
            if (this.field == null && (descriptor = compilation.bean.getPackage().getBean(subVar)) instanceof EntityBeanDescriptor) {
                this.context = (EntityBeanDescriptor)descriptor;
                if (dotIndex < 0) {
                    this.field = this.context.getPrimaryKey();
                    return;
                }
                dotIndex = var.indexOf(46, subVar.length() + 1);
                subVar = var.substring(subVar.length() + 1, dotIndex < 0 ? var.length() : dotIndex);
                this.field = this.context.getContainerManagedField(subVar, this.context);
            }
            if (this.field == null) {
                Set fields = this.context.getContainerManagedFields();
                String fieldString = "";
                if (fields != null) {
                    fieldString = ", valid fields are: ";
                    Iterator iterator = fields.iterator();
                    while (iterator.hasNext()) {
                        fieldString = fieldString + ((ContainerManagedField)iterator.next()).getName();
                        if (!iterator.hasNext()) continue;
                        fieldString = fieldString + ", ";
                    }
                }
                throw new CompilationException("Field " + subVar + " used in finder query not found in bean" + fieldString);
            }
            if (this.field.getPersistenceType() == 4) {
                this.field = this.field.getEJBReferenceField();
            }
            while (dotIndex >= 0) {
                int lastDotEnd;
                if (this.field.getPersistenceType() != 2) {
                    if (this.field.getPersistenceType() != 3) {
                        throw new CompilationException("Unable to process query: " + subVar + " was not a property/field mapped field (invalid '.' use)");
                    }
                }
                subVar = var.substring(lastDotEnd, (dotIndex = var.indexOf(46, lastDotEnd = dotIndex + 1)) >= 0 ? dotIndex : var.length());
                this.field = this.field.getPropertyField(subVar);
                if (this.field.getPropertyField(subVar) == null) {
                    throw new CompilationException("Unable to process query: field " + this.field.getName() + " does not have a subproperty/field named " + subVar);
                }
                this.field = this.field.getPropertyField(subVar);
                if (this.field.getPersistenceType() != 4) continue;
                this.field = this.field.getEJBReferenceField();
            }
        }
    }

    public static void makeParametersForQLFinder(CustomFinderMethodCompilation compilation) throws CompilationException {
        FinderMethod finder = compilation.getFinder();
        if (finder == null) {
            return;
        }
        QueryDescriptor qd = finder.getQueryDescriptor();
        if (qd == null) {
            return;
        }
        List queryParams = qd.getEjbQlRuntimeInfo().getQueryParams();
        Iterator iter = queryParams.iterator();
        while (iter.hasNext()) {
            QueryParam next = (QueryParam)iter.next();
            int idx = next.getParamIndex();
            new OrionQueryParameter("" + idx, compilation);
        }
    }
}

