/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.ejb.compilation;

import com.evermind.compiler.CompilationException;
import com.evermind.server.ejb.compilation.EJBCompilationUtils;
import com.evermind.server.ejb.compilation.ORCompilation;
import com.evermind.server.ejb.database.TableIteration;
import com.evermind.server.ejb.deployment.CollectionORMapping;
import com.evermind.server.ejb.deployment.EntityBeanDescriptor;
import java.util.Iterator;
import java.util.Vector;

public class ORCollectionCompilation
extends ORCompilation {
    protected CollectionORMapping mapping;
    private boolean compiled;

    public ORCollectionCompilation(ORCompilation slave) {
        super(slave);
        this.local = true;
    }

    public ORCollectionCompilation(ORCompilation slave, boolean _local) {
        super(slave);
        this.local = _local;
    }

    public ORCollectionCompilation() {
    }

    public boolean init() throws CompilationException {
        this.mapping = (CollectionORMapping)this.orField.getORMapping();
        return super.init("ORCollection");
    }

    protected void createTable() throws CompilationException {
        if (this.mapping.isManyToManySlave() || this.mapping.isOneToManyBiSlave()) {
            return;
        }
        this.compilation.createTable(this.getNonPrimaryKeyTable());
    }

    public void appendGetObjectsEndInterceptor() {
        this.source.append("applyAdded(found);\n");
        this.source.append("applyRemoved(found);\n");
    }

    public void compile() throws CompilationException {
        if (this.compiled) {
            throw new InternalError("Already compiled");
        }
        this.compiled = true;
        try {
            this.appendImports();
            this.appendClassStart("ORCollection");
            this.appendGetObjectsMethod();
            this.appendPersistMethod();
            this.addDeleteEntriesMethod();
            this.appendIsValueImmutable();
            this.appendInitializeObject();
            this.appendGetTransaction();
            this.source.append("}\n");
        }
        catch (IllegalArgumentException e) {
            throw new CompilationException("Error in collection-mapping '" + this.orField.getName() + "': " + e.getMessage());
        }
    }

    public void appendPersistMethod() throws CompilationException {
        this.source.append("public void persist(DataSourceConnection connection) throws java.sql.SQLException\n{\nthis.checkScope();\n");
        this.source.append("if (this.removed != null && this.objects == null) {\n  this.objects = getObjects(); \n}\n");
        if (this.mapping.isOneToManyBiSlave()) {
            this.source.append("if(this.objects != null)\n{\nint length = objects.length;\nfor(int i = 0; i < objects.length; i++)\n{\nif(!(objects[i] instanceof ChangedValue))\ncontinue;\n\nChangedValue change = (ChangedValue)objects[i];\n" + this.valueTypeName + " value = (" + this.valueTypeName + ")change.newValue;\n" + "\n" + "if(value != null)\n" + "{\n" + "objects[i] = value;\n" + "if ( " + EJBCompilationUtils.getTransactionEqualsNullString() + " ) {\n" + this.getCoreSetCode() + "}\n" + "}\n" + "else if(change.oldValue != null)\n" + "{\n" + "((com.evermind.server.ejb.EntityEJBObject) change.oldValue).updateFieldsBeforeLoadState();\n" + "}\n" + "}\n" + "clearRemoved();\n" + "}\n" + "dirty = false;\n" + "return;\n" + "}\n\n");
            return;
        }
        this.source.append("PreparedStatement deleteStatement = null;\nPreparedStatement insertStatement = null;\n");
        this.source.append("try\n{\nif(this.objects != null)\n{\n");
        this.appendDefinePrimaryKey();
        this.source.append("deleteStatement = EJBPrivileged.getCustomStatement(connection, \"");
        EntityBeanDescriptor bean = this.compilation.descriptor;
        this.source.append(this.nonPrimaryKeyTable.getPreparedDeleteStatement(false, true), true);
        this.source.append("\"");
        if (bean.getBatchSize() > 1) {
            this.source.append("," + bean.getBatchSize() + ",false");
        }
        this.source.append(");\n");
        this.source.append("insertStatement = EJBPrivileged.getCustomStatement(connection, \"");
        this.source.append(this.nonPrimaryKeyTable.getPreparedInsertStatement(false), true);
        this.source.append("\"");
        if (bean.getBatchSize() > 1) {
            this.source.append("," + bean.getBatchSize() + ",false");
        }
        this.source.append(");\n");
        this.source.append("int length = objects.length;\nfor(int i = 0; i < objects.length; i++)\n{\nif(!(objects[i] instanceof ChangedValue))\ncontinue;\n\nChangedValue change = (ChangedValue)objects[i];\n" + this.valueTypeName + " value = (" + this.valueTypeName + ")change.newValue;\n" + "\n" + "if(value == null)\n" + "{\n" + "value = (" + this.valueTypeName + ")change.oldValue;\n");
        TableIteration deleteIteration = new TableIteration();
        Iterator fields = this.getPrimaryKeysTable().getPrimaryKey().getPropertyFields().iterator();
        while (fields.hasNext()) {
            if (fields.next() == this.mapping.getKeyField()) continue;
            this.getPrimaryKeysTable().appendPreparedSet(this.source, false, "deleteStatement", this.mapping.getValueField().getType(), deleteIteration, "value", this.mapping.getValueField(), "context", true);
        }
        this.getPrimaryKeysTable().appendPreparedSet(this.source, false, "deleteStatement", this.mapping.getPrimaryKey().getType(), deleteIteration, "__thePrimaryKey", this.mapping.getPrimaryKey(), "context", true);
        this.source.append("int deleteResult = deleteStatement.executeUpdate();\n\nif(deleteResult > 1)\n{\nwhile(--deleteResult > 0)\n{\n");
        TableIteration insertIteration = new TableIteration();
        this.getNonPrimaryKeyTable().appendPreparedSet(this.source, false, "insertStatement", this.mapping.getValueField().getType(), insertIteration, "value", this.mapping.getValueField(), "context", true);
        this.getNonPrimaryKeyTable().appendPreparedSet(this.source, false, "insertStatement", this.mapping.getPrimaryKey().getType(), insertIteration, "__thePrimaryKey", this.mapping.getPrimaryKey(), "context", true);
        this.source.append("insertStatement.executeUpdate();\nobjects[i] = value;\n}\n}\n}\nelse if(change.oldValue == null)\n{\n");
        insertIteration = new TableIteration();
        this.getNonPrimaryKeyTable().appendPreparedSet(this.source, false, "insertStatement", this.mapping.getValueField().getType(), insertIteration, "value", this.mapping.getValueField(), "context", true);
        this.getNonPrimaryKeyTable().appendPreparedSet(this.source, false, "insertStatement", this.mapping.getPrimaryKey().getType(), insertIteration, "__thePrimaryKey", this.mapping.getPrimaryKey(), "context", true);
        this.source.append("insertStatement.executeUpdate();\n");
        this.source.append("objects[i] = value;\n}\n}\nclearRemoved();\n}\nelse if(this.added != null)\n{\nObject[] objects = (Object[])this.added.toArray(new Object[this.added.size()]);\n");
        this.appendDefinePrimaryKey();
        this.appendInsertObjects();
        this.source.append("}\n}\n" + this.getCatches() + "finally\n" + "{\n" + "dirty = false;\n" + "added = null;\n" + "if(deleteStatement != null) {\n try {\n deleteStatement.close();\n } catch(java.sql.SQLException e) {}\n }\n" + "if(insertStatement != null) {\n try {\n insertStatement.close();\n } catch(java.sql.SQLException e) {}\n }\n" + "}\n" + "}\n" + "\n");
    }

    private String getCoreSetCode() throws CompilationException {
        StringBuffer buffer = new StringBuffer();
        buffer.append("( (").append(this.compilation.className).append(") context.getEJBLocalObject() )").append("._getObject().addOutOfTransDirtyEjb ( (").append(this.compilation.compilation.getCompilation((String)this.mapping.peer.getRoleSource().getName()).className).append(") value );\n");
        return buffer.toString();
    }

    public Vector getDependentClasses() {
        return null;
    }
}

