/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.ejb.compilation;

import com.evermind.compiler.CompilationException;
import com.evermind.server.ejb.compilation.ClassCompilation;
import com.evermind.server.ejb.compilation.Compilation;
import com.evermind.server.ejb.compilation.EJBCompilationUtils;
import com.evermind.server.ejb.compilation.EntityBeanCompilation;
import com.evermind.server.ejb.compilation.MethodCompilation;
import com.evermind.server.ejb.compilation.ORCompilation;
import com.evermind.server.ejb.compilation.PersistenceManagerCompilation;
import com.evermind.server.ejb.compilation.SelectMethodCompilation;
import com.evermind.server.ejb.database.DatabaseSchema;
import com.evermind.server.ejb.database.TableIteration;
import com.evermind.server.ejb.database.TableView;
import com.evermind.server.ejb.deployment.CommitOptionDescriptor;
import com.evermind.server.ejb.deployment.ContainerManagedField;
import com.evermind.server.ejb.deployment.EntityBeanDescriptor;
import com.evermind.server.ejb.deployment.ORMapping;
import com.evermind.server.ejb.deployment.PrimaryKeyContext;
import com.evermind.util.ByteString;
import com.evermind.util.ClassUtils;
import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.ejb.EJBLocalObject;
import javax.ejb.EJBObject;

public class CMPObjectCompilation
extends ClassCompilation {
    Compilation compilation;
    public TableView table;
    ByteString createSource = new ByteString(200);
    private ContainerManagedField primaryKey;
    private List containerManagedFields;
    private PropertyDescriptor[] properties;
    private PrimaryKeyContext context;
    protected Set fields;

    public CMPObjectCompilation(String name, Compilation compilation, PrimaryKeyContext context, Class type, DatabaseSchema schema) throws CompilationException {
        this(name, type);
        if (schema == null) {
            throw new NullPointerException("schema was null");
        }
        this.context = context;
        this.primaryKey = context.getPrimaryKey();
        this.fields = context.getContainerManagedFields();
        this.compilation = compilation;
        this.properties = ((EntityBeanDescriptor)context).getProperties();
        boolean deepCopyFound = false;
        if (!(context instanceof EntityBeanDescriptor) || ((EntityBeanDescriptor)context).isCMP2_0()) {
            this.verifyMethods();
            Iterator iterator = this.fields.iterator();
            while (iterator.hasNext()) {
                ContainerManagedField field = (ContainerManagedField)iterator.next();
                boolean found = false;
                try {
                    for (int i = 0; i < this.properties.length; ++i) {
                        if (!this.properties[i].getName().equals(field.getName())) continue;
                        if (this.properties[i].getReadMethod() != null) {
                            field.init(compilation.container, schema, type, this.properties[i].getReadMethod().getReturnType());
                            found = true;
                            continue;
                        }
                        if (this.properties[i].getWriteMethod() == null) continue;
                        field.init(compilation.container, schema, type, this.properties[i].getWriteMethod().getParameterTypes()[0]);
                        found = true;
                    }
                    if (found) continue;
                    if (!(field.isOCA() || field.getEJBRelationshipRole() != null && field.getEJBRelationshipRole().getRelation() != null && field.getEJBRelationshipRole().getRelation().unspecifiedCMRField())) {
                        throw new CompilationException("No abstract setter/getter found for cmp-field " + field.getName() + " in dependent class " + type.getName());
                    }
                    EntityBeanDescriptor owner = (EntityBeanDescriptor)field.getOwner();
                    field.init(compilation.container, schema, owner.getEJBClass(), owner.getPropertyType(field.getName(), field));
                }
                catch (InstantiationException e) {
                    throw new CompilationException(e.getMessage());
                }
            }
        }
    }

    public CMPObjectCompilation(String name, Class type) {
        super(name, type);
    }

    public void cleanSource() {
        this.resetSource();
        this.createSource.reset();
    }

    public void setFields(Set fields) {
        this.fields = fields;
    }

    public void compile() throws CompilationException {
        this.addDmsImports();
        this.source.append("import java.sql.*;\n");
        this.source.append("import javax.ejb.*;\n");
        this.source.append("import javax.sql.*;\n");
        this.source.append("import com.evermind.server.ejb.*;\n");
        this.source.append("\n");
        this.addSharedImports();
        this.source.append("public class " + this.getName() + " extends " + this.interfaceClass.getName() + "\n" + "{\n" + "ExtendedContainerManagedObject __parent;\n" + "boolean __dirty;\n");
        this.processFields();
        this.source.append("\npublic void __setDirty(Object referer)\n{\nif(this.__dirty) return;\nthis.__dirty = true;\nif(__parent != null) __parent.__setDirty(this);\n}\n");
        this.appendClearDirty(this.source);
        this.compileMethods();
        this.source.append("}");
    }

    public void appendFieldCopy(ByteString buffer, ContainerManagedField field, Compilation compilation, boolean local) {
        compilation.appendCloneSource("clone." + field.getName() + " = ", true, buffer, "this", "__getContext()", field, "clone." + field.getName(), local);
    }

    public void appendFieldCopies(ByteString buffer, Compilation compilation, boolean local) {
        Iterator iterator = this.fields.iterator();
        while (iterator.hasNext()) {
            this.appendFieldCopy(buffer, (ContainerManagedField)iterator.next(), this.compilation, local);
        }
    }

    public void processFields() throws CompilationException {
        if (this instanceof PersistenceManagerCompilation && !((PersistenceManagerCompilation)this).compilation.descriptor.isCMP2_0()) {
            return;
        }
        ByteString methodSource = new ByteString(1000);
        if (this instanceof PersistenceManagerCompilation) {
            EntityBeanDescriptor bean = ((PersistenceManagerCompilation)this).compilation.descriptor;
            if (bean.isAutomaticIdentity()) {
                this.processContainerManagedField(bean.getPrimaryKey(), methodSource, true);
            } else if (bean.getPrimaryKeyFieldName() != null) {
                this.processContainerManagedField(bean.getPrimaryKey(), methodSource, true);
            } else {
                Iterator iterator = bean.getPrimaryKey().getPropertyFields().iterator();
                while (iterator.hasNext()) {
                    ContainerManagedField field = (ContainerManagedField)iterator.next();
                    this.processContainerManagedField(field, methodSource, true);
                }
            }
        }
        Iterator iterator = this.fields.iterator();
        while (iterator.hasNext()) {
            ContainerManagedField field = (ContainerManagedField)iterator.next();
            this.processContainerManagedField(field, methodSource, true);
        }
        if (!(this instanceof PersistenceManagerCompilation)) {
            this.source.append("\npublic " + this.interfaceClass.getName() + " deepCopy()\n" + "{\n" + this.getName() + " clone = new " + this.getName() + "();\n");
            this.appendFieldCopies(this.source, this.compilation, false);
            this.source.append("return clone;\n}\n");
            this.source.append("\npublic EvermindEntityContext __getContext()\n{\nif(this.__parent != null)\nreturn this.__parent.__getContext();\n\nreturn null;\n}\n");
        }
        this.source.append(methodSource);
    }

    public void processContainerManagedField(ContainerManagedField field, ByteString methodSource, boolean requireAccessor) throws CompilationException {
        String aFieldName = field.isAutomaticIdentity() ? field.getDatabaseName() : field.getName();
        String fieldType = ClassUtils.getSourceNotation(field.getType(), 0);
        this.source.append(fieldType + " " + aFieldName + ";\n");
        PropertyDescriptor property = null;
        for (int i = 0; i < this.properties.length; ++i) {
            if (!this.properties[i].getName().equals(field.getName())) continue;
            property = this.properties[i];
            break;
        }
        if (!(property != null || field.isAutomaticIdentity() || field.isOCA() || field.getEJBRelationshipRole().getRelation().unspecifiedCMRField())) {
            if (requireAccessor) {
                throw new CompilationException("Abstract accessors for the cmp-field '" + field.getName() + "' in class " + this.interfaceClass.getName() + " not found (if this is a CMP 1.0 bean then consider setting <cmp-version> to 1.x or using the 1.1 DTD)");
            }
        } else {
            if (property != null && property.getReadMethod() != null) {
                this.appendReadMethod(methodSource, field, property);
            }
            if (field.getPeer() != null && field.getPeer().getRelation() != null) {
                this.appendORWriteMethod(methodSource, field, property, fieldType);
            } else if (property != null && property.getWriteMethod() != null) {
                this.appendWriteMethod(methodSource, field, property, fieldType);
            }
        }
    }

    protected boolean canHaveLocalAccess() {
        return true;
    }

    protected void appendReadMethod(ByteString methodSource, ContainerManagedField field, PropertyDescriptor property) throws CompilationException {
        boolean genEndIfStatement = false;
        boolean hasOneToOnePeer = field.getPeer() != null && !field.getPeer().isMany() && !field.getPeer().getPeer().isMany() && field.getPeer().getRelation() != null;
        boolean hasOneToManyPeer = field.getPeer() != null && field.getPeer().isMany() && !field.getPeer().getPeer().isMany() && field.getPeer().getRelation() != null;
        methodSource.append("\npublic " + ClassUtils.getSourceNotation(field.getType(), 0) + " " + property.getReadMethod().getName() + "()\n" + "{\n");
        boolean appendReturn = true;
        if (field.getORMapping() != null && (field.getType() == Map.class || field.getType() == Collection.class || field.getType() == Set.class || field.getType() == List.class)) {
            methodSource.append("if(this." + field.getName() + " == null || " + EJBCompilationUtils.getTransactionString() + " !=  ((" + field.getORMapping().compilation.getName() + " )this." + field.getName() + ").getTransaction()) this." + field.getName() + " = new " + field.getORMapping().compilation.getName() + "(this.__context);\n");
            if ((field.getType() == Collection.class || field.getType() == Set.class) && this.canHaveLocalAccess()) {
                if (hasOneToManyPeer && field.getPeer().getRelation().isSynthetic()) {
                    EntityBeanCompilation entity = (EntityBeanCompilation)this.compilation.getCompilation(field.getPeer().getRoleSource().getName());
                    String peerField = field.getPeer().getRelation().getName();
                    methodSource.append("java.util.Iterator it = " + field.getName() + ".iterator();\n" + "while(it.hasNext()) {\n" + entity.getName() + " entity = (" + entity.getName() + ")it.next();\n" + "com.evermind.server.ejb.EJBUtils.confirmAlive(entity);\n" + entity.persistenceManagerCompilation.getName() + " toPersistenceManager = (" + entity.persistenceManagerCompilation.getName() + ")entity.getEntityBean();\n" + "com.evermind.server.ejb.EJBUtils.confirmAlive(toPersistenceManager);\n" + "toPersistenceManager." + peerField + " = (" + this.compilation.getCompilation(field.getPeer().getPeer().getRoleSource().getName()).getName() + ")this.__context.getAnEJBObject_Local_or_Remote();\n" + "}\n");
                }
                methodSource.append("return this." + field.getName() + ";\n");
                appendReturn = false;
            }
        } else if (EJBObject.class.isAssignableFrom(field.getType()) || EJBLocalObject.class.isAssignableFrom(field.getType())) {
            CommitOptionDescriptor co;
            EntityBeanDescriptor owner = (EntityBeanDescriptor)field.getOwner();
            if (owner.isContainerManaged() && (co = owner.getCommitOption()).isCacheable() && field.isCMR() && (field.isOneToOne() || field.isOneToMany_Many())) {
                EntityBeanCompilation entity = (EntityBeanCompilation)this.compilation.getCompilation(field.getPeer().getRoleSource().getName());
                methodSource.append("if( _" + field.getName() + "FKey != null)");
                methodSource.append("{\n");
                if (entity.getEntityBeanDescriptor().getCommitOption().isCacheable()) {
                    methodSource.append(" if(this." + field.getName() + " != null)\n");
                    methodSource.append(" {\n");
                    methodSource.append(entity.getName() + " value = (" + entity.getName() + ")this." + field.getName() + ";\n");
                    methodSource.append("  value.context.setObject ((" + entity.persistenceManagerCompilation.getName() + ")");
                    methodSource.append("  EntityCacheManager.instance().clone(this._" + field.getName() + "FKey, value.getMyHome().getBeanDescriptor(), value._getObject()));\n");
                    if (appendReturn) {
                        methodSource.append("return this." + field.getName() + ";\n");
                    }
                    methodSource.append(" }\n");
                    methodSource.append(" else\n");
                } else {
                    methodSource.append(" if(this." + field.getName() + " == null)\n");
                }
                methodSource.append(" {\n");
                methodSource.append("com.evermind.server.ejb.EntityContainer peerHome;\n");
                methodSource.append("if (this.__context.localHome != null) {\n");
                methodSource.append("peerHome = ");
                methodSource.append("(com.evermind.server.ejb.EntityContainer) this.__context.localHome.getHome(\"" + field.getEJBReferenceHome() + "\", " + EJBLocalObject.class.isAssignableFrom(field.getType()) + ");\n");
                methodSource.append("} else {\n");
                methodSource.append("peerHome = ");
                methodSource.append("(com.evermind.server.ejb.EntityContainer) this.__context.remoteHome.getHome(\"" + field.getEJBReferenceHome() + "\", " + EJBLocalObject.class.isAssignableFrom(field.getType()) + ");\n");
                methodSource.append("}\n");
                methodSource.append("ThreadState state = ThreadState.getCurrentState();\n");
                methodSource.append("ApplicationServerTransaction transaction = (com.evermind.server.ApplicationServerTransaction)" + EJBCompilationUtils.getTransactionManagerString() + ".getTransaction();\n");
                methodSource.append("try \n{\n");
                methodSource.append("this." + field.getName() + " = (" + ClassUtils.getSourceNotation(field.getType(), 0) + ")");
                methodSource.append("peerHome.getWrapperByPK(transaction, " + ClassUtils.getConvertSource("this._" + field.getName() + "FKey", field.getType(), field.getType()) + ");\n");
                methodSource.append("}\ncatch(java.rmi.RemoteException re)\n{\nthrow com.evermind.server.ejb.EJBUtils.createEJBException(re);\n}\n");
                methodSource.append(" }\n");
                methodSource.append("}\n");
            }
            methodSource.append("if(this." + field.getName() + " != null && ((com.evermind.server.ejb.EntityEJBObject)this." + field.getName() + ").__isRemoved(null)) this." + field.getName() + " = null;\n");
            if (hasOneToOnePeer) {
                methodSource.append("if(this." + field.getName() + " != null) ((com.evermind.server.ejb.EntityEJBObject)this." + field.getName() + ").__updateOneToOne(\"" + field.getPeer().getRelation().getName() + "\", this.__context.getAnEJBObject_Local_or_Remote());\n");
            }
        }
        if (appendReturn) {
            methodSource.append("return this." + field.getName() + ";\n");
        }
        methodSource.append("}\n");
    }

    protected void appendORWriteMethod(ByteString methodSource, ContainerManagedField field, PropertyDescriptor property, String fieldType) throws CompilationException {
        boolean isToManyOR = field.getORMapping() != null && (field.getType() == Map.class || field.getType() == Collection.class || field.getType() == Set.class || field.getType() == List.class) && field.getPeer() != null && field.getPeer().isMany();
        boolean isManyToOneOR = !isToManyOR && field.getPeer() != null && !field.getPeer().isMany() && field.getPeer().getPeer().isMany();
        boolean hasOneToOnePeer = field.getPeer() != null && !field.getPeer().isMany() && !field.getPeer().getPeer().isMany() && field.getPeer().getRelation() != null;
        methodSource.append("\nvoid __core__set" + field.getName() + "(" + field.getType().getName() + " newValue)\n" + "{\n");
        methodSource.append("if(this." + field.getName() + " == newValue) return;\n");
        if (hasOneToOnePeer) {
            methodSource.append(field.getType().getName() + " oldValue = " + "this." + field.getName() + ";\n");
            methodSource.append("if(oldValue != null)\n((com.evermind.server.ejb.EntityEJBObject)oldValue).__updateOneToOne(\"" + field.getPeer().getRelation().getName() + "\", null);\n");
            methodSource.append("if(newValue != null)\n((com.evermind.server.ejb.EntityEJBObject)newValue).__updateOneToOne(\"" + field.getPeer().getRelation().getName() + "\", this.__context.getAnEJBObject_Local_or_Remote());\n");
            methodSource.append("this." + field.getName() + " = ");
            methodSource.append("newValue;\n");
        } else if (isManyToOneOR) {
            field.getPeer();
            field.getPeer().getRelation();
            field.getPeer().getRelation().getResolved();
            field.getPeer().getRelation().getResolved().getORMapping();
            ORCompilation a = field.getPeer().getRelation().getResolved().getORMapping().compilation;
            EntityBeanCompilation entity = (EntityBeanCompilation)this.compilation.getCompilation(field.getPeer().getRoleSource().getName());
            ORCompilation mapping = field.getPeer().getRelation().getResolved().getORMapping().compilation;
            if (mapping == null) {
                ORCompilation slaveCompilation;
                EntityBeanDescriptor resolvedEntity = (EntityBeanDescriptor)field.getPeer().getRoleSource().getResolved();
                EntityBeanCompilation resolvedCompilation = (EntityBeanCompilation)this.compilation.getCompilation(resolvedEntity.getName());
                field.getEJBRelationshipRole();
                field.getEJBRelationshipRole().getRelation();
                field.getEJBRelationshipRole().getRelation().getResolved();
                field.getEJBRelationshipRole().getRelation().getResolved().getORMapping();
                ORMapping slaveMapping = field.getEJBRelationshipRole().getRelation().getResolved().getORMapping();
                ORCompilation oRCompilation = slaveCompilation = slaveMapping == null ? null : slaveMapping.compilation;
                if (slaveMapping != null && slaveCompilation == null) {
                    throw new NullPointerException("slaveCompilation was null");
                }
                mapping = field.getPeer().getRelation().getResolved().getORMapping().compilation = resolvedCompilation.createORCompilation(field.getPeer().getRelation().getResolved(), slaveCompilation);
                mapping.setEnvironment(field.getPeer().getRelation().getResolved(), resolvedCompilation);
                mapping.init();
                if (mapping == null) {
                    throw new NullPointerException("mapping was null");
                }
                if (mapping.orField == null) {
                    throw new NullPointerException("mapping.orField was null");
                }
            }
            methodSource.append("com.evermind.server.ThreadState state = com.evermind.server.ThreadState.getCurrentState();\ncom.evermind.server.ApplicationServerTransaction transaction = (com.evermind.server.ApplicationServerTransaction)" + EJBCompilationUtils.getTransactionManagerString() + ".getTransaction();\n" + entity.getName() + " oldValue = (" + entity.getName() + ")this." + field.getName() + ";\n" + "boolean oldInCall = oldValue == null ? false : oldValue.__allocateCoreInstance(state, 90000l, true);\n" + "try\n" + "{\n" + "if(oldValue != null) oldValue = (" + entity.getName() + ")oldValue.__getCoreInstance();\n" + "if(oldValue != null && transaction != null)\n" + "{\n" + EJBCompilationUtils.getRegisterBeanUncheckedString("oldValue") + ";\n" + "oldValue.transaction = transaction;\n" + "}\n" + "\n" + "if(oldValue != null && ((EntityEJBObject)oldValue).context.isLazy())" + "{\n" + "try {\n" + "oldValue.loadState(transaction);\n" + "} catch(javax.ejb.NoSuchEntityException e) {\n" + "} catch(Exception e) {\n" + "}\n" + "}\n" + "\n" + entity.getName() + " entity = (" + entity.getName() + ")newValue;\n" + "boolean inCall = entity == null ? false : entity.__allocateCoreInstance(state, 90000l, true);\n" + "if(entity != null)\n" + "entity = (" + entity.getName() + ")entity.__getCoreInstance();\n" + "try\n" + "{\n" + "if(entity != null && transaction != null)\n" + "{\n" + EJBCompilationUtils.getRegisterBeanUncheckedString("entity") + ";\n" + "entity.transaction = transaction;\n" + "}\n\n" + "if(entity != null && ((EntityEJBObject)entity).context.isLazy()) {\n" + "try {\n" + "entity.loadState(transaction);\n" + "} catch(javax.ejb.NoSuchEntityException e) {\n" + "} catch(Exception e) {\n" + "}\n" + "}\n\n" + "if(oldValue != null)\n" + "{\n" + entity.persistenceManagerCompilation.getName() + " oldFromPersistenceManager = (" + entity.persistenceManagerCompilation.getName() + ")oldValue.getEntityBean();\n" + "if(oldFromPersistenceManager." + mapping.orField.getName() + " == null)\n" + "oldFromPersistenceManager." + mapping.orField.getName() + " = new " + mapping.getName() + "(oldValue.context);\n");
            if (!(ORMapping.ASSOC_TABLES_USER_PREF && !field.isManyToMany() || field.isBiDirectional() && field.isManyToMany())) {
                methodSource.append("if (((CMRCollectionField)oldFromPersistenceManager." + mapping.orField.getName() + ").isLoaded())\n" + "{\n");
            }
            methodSource.append("((CMRCollectionField)oldFromPersistenceManager." + mapping.orField.getName() + ").remove(this.__context.getEJB" + (((PersistenceManagerCompilation)this).compilation.descriptor.getLocalInterface() != null ? "Local" : "") + "Object(), true, (entity == null));\n" + "oldFromPersistenceManager.__setDirty(\"" + mapping.orField.getName() + "\");\n" + "if( transaction == null ) addOutOfTransDirtyEjb( oldValue );");
            if (!(ORMapping.ASSOC_TABLES_USER_PREF && !field.isManyToMany() || field.isBiDirectional() && field.isManyToMany())) {
                methodSource.append("}\n\n");
            }
            methodSource.append("}\n\nif(entity != null)\n{\n" + entity.persistenceManagerCompilation.getName() + " newFromPersistenceManager = (" + entity.persistenceManagerCompilation.getName() + ")entity.getEntityBean();\n" + "if(newFromPersistenceManager." + mapping.orField.getName() + " == null)\n" + "newFromPersistenceManager." + mapping.orField.getName() + " = new " + mapping.getName() + "(entity.context);\n" + (!field.isPersistedToAssociationTable() ? "if (((CMRCollectionField)newFromPersistenceManager." + mapping.orField.getName() + ").isLoaded())" + "{\n" : "") + "((CMRCollectionField)newFromPersistenceManager." + mapping.orField.getName() + ").add(this.__context.getEJB" + (((PersistenceManagerCompilation)this).compilation.descriptor.getLocalInterface() != null ? "Local" : "") + "Object());\n" + "newFromPersistenceManager.__setDirty(\"" + mapping.orField.getName() + "\");\n" + "if( transaction == null ) addOutOfTransDirtyEjb( entity );\n" + (!field.isPersistedToAssociationTable() ? "}\nelse\n((CMRCollectionField)newFromPersistenceManager." + mapping.orField.getName() + ").notifyAddedObject(this.__context.getEJB" + (((PersistenceManagerCompilation)this).compilation.descriptor.getLocalInterface() != null ? "Local" : "") + "Object());\n" : "") + "}\n" + "}\n" + "finally\n" + "{\n" + "if(entity != null)\n" + "entity.endCallLocal(inCall);\n" + "}\n" + "}\n" + "finally\n" + "{\n" + "if(oldValue != null)\n" + "oldValue.endCallLocal(oldInCall);\n" + "}\n" + "\n");
        }
        if (isToManyOR) {
            methodSource.append("if(this." + field.getName() + " == null) this." + field.getName() + " = new " + field.getORMapping().compilation.getName() + "(this.__context);\n");
            methodSource.append("this." + field.getName() + ".clear();\n");
            methodSource.append("this." + field.getName() + ".addAll(newValue);\n");
        }
        if (!field.isCMRPK() && !field.getPeer().getEJBRelationship().isCascadeDeleteForRole()) {
            methodSource.append("if (__context.isSqlExecuted() )\n{\n");
            methodSource.append("this.__setDirty(\"" + field.getName() + "\");\n");
            methodSource.append("__context.getAnEJBObject_Local_or_Remote().updateFieldsBeforeLoadState();\n");
            methodSource.append("}\n");
        }
        methodSource.append("}\n");
        if (property != null && property.getWriteMethod() != null) {
            this.appendWriteMethod(methodSource, field, property, fieldType);
        }
    }

    protected void appendWriteMethod(ByteString methodSource, ContainerManagedField field, PropertyDescriptor property, String fieldType) throws CompilationException {
        methodSource.append("\npublic void " + property.getWriteMethod().getName() + "(" + ClassUtils.getSourceNotation(property.getWriteMethod().getParameterTypes()[0], 0) + " newValue)\n" + "{\n");
        if (field.getORMapping() != null) {
            methodSource.append("if(newValue == null) com.evermind.server.ejb.EJBUtils.throwNullORCollectionSet();\n");
        }
        if ((property.getWriteMethod().getModifiers() & 0x400) == 0) {
            methodSource.append("super." + property.getWriteMethod().getName() + "(newValue);\n");
        }
        if (EJBObject.class.isAssignableFrom(field.getType()) || EJBLocalObject.class.isAssignableFrom(field.getType())) {
            methodSource.append("com.evermind.server.ejb.EJBUtils.confirmAlive(newValue);\n");
        }
        if (field.getPeer() != null && field.getPeer().getRelation() != null) {
            methodSource.append("__core__set" + field.getName() + "(newValue);\n");
        } else {
            if (field.isPrimaryKey()) {
                methodSource.append("if (__context == null || __context.actionTaken != MethodState.EJB_CREATE)\n");
                methodSource.append("throw new IllegalStateException(\"It is illegal to call a primary key set accessor method (" + property.getWriteMethod().getName() + "(...)) once the primary key has been set\");\n");
            }
            if (!field.isShared()) {
                methodSource.append("this." + field.getName() + " = ");
                methodSource.append("newValue;\n");
                methodSource.append("this.__setDirty(\"" + field.getName() + "\");\n");
            }
        }
        methodSource.append("}\n");
    }

    protected void appendClearDirty(ByteString source) {
        source.append("public void __clearDirty()\n{\nif(this.__dirty == 0) return;\nthis.__dirty = 0;\n");
        Iterator iterator = this.fields.iterator();
        while (iterator.hasNext()) {
            ContainerManagedField field = (ContainerManagedField)iterator.next();
            if (field.getORMapping() == null) continue;
            if (field.getType() == (class$java$util$Set == null ? CMPObjectCompilation.class$("java.util.Set") : class$java$util$Set)) {
                source.append("((ORSet)" + field.getName() + ").__clearDirty();\n");
                continue;
            }
            if (field.getType() == (class$java$util$Map == null ? CMPObjectCompilation.class$("java.util.Map") : class$java$util$Map)) {
                source.append("((ORMap)" + field.getName() + ").__clearDirty();\n");
                continue;
            }
            if (field.getType() == (class$java$util$Collection == null ? CMPObjectCompilation.class$("java.util.Collection") : class$java$util$Collection)) {
                source.append("((ORCollection)" + field.getName() + ").__clearDirty();\n");
                continue;
            }
            if (field.getType() != (class$java$util$List == null ? CMPObjectCompilation.class$("java.util.List") : class$java$util$List)) continue;
            source.append("((ORList)" + field.getName() + ").__clearDirty();\n");
        }
        source.append("}\n\n");
    }

    public MethodCompilation compileMethod(Method method) {
        return null;
    }

    public void verifyMethods() throws CompilationException {
        Method[] methods = this.interfaceClass.getMethods();
        for (int y = 0; y < methods.length; ++y) {
            Method method = methods[y];
            if (!Modifier.isAbstract(method.getModifiers())) continue;
            try {
                boolean isValid = this.context.isPropertyMethod(method);
                if (isValid) continue;
                if (method.getName().startsWith("ejbSelect")) {
                    SelectMethodCompilation compilation = new SelectMethodCompilation(this, (EntityBeanDescriptor)this.context, method);
                    ((MethodCompilation)compilation).compile();
                    this.methods.add(compilation);
                    continue;
                }
                if (isValid) continue;
                throw new CompilationException("Method " + method + " can not be declared abstract for entity '" + ((EntityBeanDescriptor)this.context).getName() + "'");
            }
            catch (IntrospectionException e) {
                throw new CompilationException("Error introspecting " + this.getDisplayName() + ": " + e);
            }
        }
    }

    protected String getDisplayName() {
        return this.interfaceClass.getName();
    }

    public void appendLOBDeclareCode(StringBuffer source, Vector _lobVariables) throws CompilationException {
        Iterator iterator = this.table.getFields().iterator();
        while (iterator.hasNext()) {
            ContainerManagedField field = (ContainerManagedField)iterator.next();
            if (field.isSynthetic() || field.getDatabaseFieldCount() <= 0) continue;
            field.appendLOBVariable(source, _lobVariables);
        }
    }

    public boolean containLobColumns() {
        Iterator iterator = this.table.getFields().iterator();
        while (iterator.hasNext()) {
            ContainerManagedField field = (ContainerManagedField)iterator.next();
            if (field.isSynthetic() || field.isPersistedToAssociationTable() || field.getDatabaseFieldCount() <= 0 || !field.containLobColumns()) continue;
            return true;
        }
        return false;
    }

    public boolean appendEJBStoreCode(ByteString source, boolean onlyUpdateEffected, Vector _lobVariables) throws CompilationException {
        boolean hasMainFields = this.table.getFieldCount(false) > 0;
        boolean generatedForAtLeastOneField = false;
        ContainerManagedField ocafiled = null;
        if (onlyUpdateEffected) {
            source.append("{\nint currentStatementPosition = 1;\n");
            if (hasMainFields) {
                source.append("StringBuffer buffer = new StringBuffer();\nbuffer.append(\"update ");
                source.append(this.table.getTable().getName(), true);
                source.append(" set \");\nboolean first = true;\n");
            }
            Iterator iterator = this.table.getFields().iterator();
            int currentIndex = -1;
            while (iterator.hasNext()) {
                ContainerManagedField field = (ContainerManagedField)iterator.next();
                ++currentIndex;
                if (field.isSynthetic() || field.isPersistedToAssociationTable() || field.getDatabaseFieldCount() <= 0) continue;
                generatedForAtLeastOneField = true;
                StringBuffer temporaryBuffer = new StringBuffer();
                field.appendFieldNames(temporaryBuffer, new TableIteration(), 2, false);
                EntityBeanDescriptor owner = (EntityBeanDescriptor)field.getOwner();
                source.append("// commitOption: " + field.isOCA() + " " + owner.getCommitOption().getOption() + " \n");
                if (field.isOCA() && (owner.getCommitOption().getOption() == 2 || owner.getCommitOption().getOption() == 4)) {
                    source.append("if(this._getObject()." + field.getName() + "Changed)\n");
                    source.append("{\n");
                    source.append("dirtyBSet.set(" + currentIndex + ");\n");
                    ocafiled = field;
                } else {
                    source.append("if(dirtyBSet.get(" + currentIndex + "))\n");
                    source.append("{\n");
                }
                source.append("   if(!first) buffer.append(\", \"); buffer.append(\"");
                source.append(temporaryBuffer.toString(), true);
                source.append("\"); first = false; }\n");
            }
            if (hasMainFields) {
                EntityBeanDescriptor bean;
                StringBuffer endBuffer = new StringBuffer();
                endBuffer.append(" where ");
                this.table.getPrimaryKey().appendFieldNames(endBuffer, new TableIteration(), 3, false);
                if (this.table.getPrimaryKey().getDatabaseFieldCount() < 1) {
                    throw new CompilationException("No direct database fields for primary key for " + this.table.getPrimaryKey().getContext());
                }
                StringBuffer ocaBuffer = new StringBuffer();
                if (ocafiled != null) {
                    ocafiled.appendFieldNames(ocaBuffer, new TableIteration(), 2, false);
                }
                source.append("buffer.append(\"");
                source.append(endBuffer.toString(), true);
                if (ocafiled != null) {
                    source.append(" AND ", true);
                    source.append(ocaBuffer.toString(), true);
                }
                source.append("\");\n");
                source.append("traceLog(\"Executing: \" + buffer);\n");
                source.append("sqlStatement = buffer.toString();\n");
                source.append("PreparedStatement statement = first ? null : EJBPrivileged.getCustomStatement(connection, buffer.toString()");
                if (this instanceof PersistenceManagerCompilation && (bean = ((PersistenceManagerCompilation)this).compilation.descriptor).getBatchSize() > 1) {
                    source.append("," + bean.getBatchSize() + "," + bean.getDelayUpdatesUntilCommit());
                }
                source.append(");\n\n");
            }
            if (this.context instanceof EntityBeanDescriptor) {
                ByteString tempBuffer = new ByteString();
                if (((EntityBeanDescriptor)this.context).getPrimaryKeyFieldName() != null) {
                    this.table.appendPreparedUpdateStatementSetSource(this.compilation.container, tempBuffer, false, "statement", "this._getObject().", "this._getObject().", "context", hasMainFields, true, "dirtyBSet", "currentStatementPosition");
                } else if (((EntityBeanDescriptor)this.context).isAutomaticIdentity()) {
                    this.table.appendPreparedUpdateStatementSetSource(this.compilation.container, tempBuffer, false, "statement", "this._getObject().", ClassUtils.getConvertSource("this.primaryKey", Object.class, this.context.getPrimaryKey().getType()), "context", hasMainFields, true, "dirtyBSet", "currentStatementPosition");
                } else {
                    this.table.appendPreparedUpdateStatementSetSource(this.compilation.container, tempBuffer, false, "statement", "this._getObject().", "this.__", "context", hasMainFields, true, "dirtyBSet", "currentStatementPosition");
                }
                tempBuffer.append("// ocafield: " + ocafiled + "\n");
                if (ocafiled != null) {
                    tempBuffer.append("if(currentStatementPosition != 1)\n{\n");
                    EntityBeanDescriptor bean = ocafiled.getEntity();
                    if (bean.getCommitOption().getType().equalsIgnoreCase("int")) {
                        tempBuffer.append("statement.setInt(currentStatementPosition++, this._getObject()._getBaseVersion());\n");
                    } else {
                        tempBuffer.append("statement.setLong(currentStatementPosition++, this._getObject()._getBaseVersion());\n");
                    }
                    tempBuffer.append("}\n");
                }
                if (tempBuffer.length() > 0) {
                    generatedForAtLeastOneField = true;
                    source.append(tempBuffer);
                }
            }
        } else {
            EntityBeanDescriptor bean;
            source.append("traceLog(\"Executing \");\n");
            source.append("traceLog(\"" + this.table.getPreparedUpdateStatement(true) + "\");\n");
            source.append("PreparedStatement statement = EJBPrivileged.getCustomStatement(connection, \"" + this.table.getPreparedUpdateStatement(true) + "\");\n");
            if (this instanceof PersistenceManagerCompilation && (bean = ((PersistenceManagerCompilation)this).compilation.descriptor).getBatchSize() > 1) {
                source.append("," + bean.getBatchSize() + "," + bean.getDelayUpdatesUntilCommit());
            }
            source.append("\n");
            source.append("sqlStatement = \"" + this.table.getPreparedUpdateStatement(true) + "\";\n");
            if (this.context instanceof EntityBeanDescriptor) {
                if (((EntityBeanDescriptor)this.context).getPrimaryKeyFieldName() != null) {
                    this.table.appendPreparedUpdateStatementSetSource(this.compilation.getContainer(), source, false, "statement", "this._getObject().", "_getObject().", "context", hasMainFields, true, null, null);
                } else {
                    this.table.appendPreparedUpdateStatementSetSource(this.compilation.getContainer(), source, false, "statement", "this._getObject().", "this.__", "context", hasMainFields, true, null, null);
                }
                generatedForAtLeastOneField = true;
            }
        }
        if (hasMainFields) {
            long timeout;
            if (onlyUpdateEffected) {
                source.append("if(statement!=null && currentStatementPosition != 1){\n");
            }
            if (this.context instanceof EntityBeanDescriptor && (timeout = ((EntityBeanDescriptor)this.context).getCallTimeout()) > 0L) {
                source.append(" statement.setQueryTimeout(" + (int)(timeout / 1000L) + ");\n");
            }
            source.append("try\n{ statement.executeUpdate();\n} finally { try { statement.close();\n} catch(java.sql.SQLException e) {}\n }\n");
            if (onlyUpdateEffected) {
                source.append("}\n");
            }
        }
        if (this.primaryKey.getEntity().getCommitOption().isCacheable()) {
            source.append("this._getObject()._setState(ExtendedContainerManagedObject.State.k_updated, true);\n");
        }
        this.appendFreeLobVariables(source, _lobVariables);
        if (onlyUpdateEffected) {
            source.append("}\n");
        }
        return generatedForAtLeastOneField;
    }

    protected void appendFreeLobVariables(ByteString _source, Vector _lobVariables) {
        for (int y = 0; y < _lobVariables.size(); ++y) {
            String _lobVar = (String)_lobVariables.get(y);
            _source.append("if (" + _lobVar + "!= null) {\n" + _lobVar + ".freeTemporary();\n" + "}\n");
        }
    }

    public static int bumpDirtyBit(int bit) {
        if (bit == Integer.MIN_VALUE) {
            return bit;
        }
        return bit * 2;
    }

    public void verifyAbstractMethod(Method method) throws CompilationException {
        int y;
        boolean useful = false;
        for (y = 0; y < this.properties.length; ++y) {
            if (this.properties[y].getReadMethod() != null && this.properties[y].getReadMethod().equals(method)) {
                useful = true;
                break;
            }
            if (this.properties[y].getWriteMethod() == null || !this.properties[y].getWriteMethod().equals(method)) continue;
            useful = true;
            break;
        }
        if (!useful) {
            for (y = 0; y < this.properties.length; ++y) {
                Method writeMethod;
                Method readMethod;
                if (this.properties[y].getReadMethod() != null && (readMethod = this.properties[y].getReadMethod()).getName().equals(method.getName()) && ((Object)Arrays.asList(readMethod.getParameterTypes())).equals(Arrays.asList(method.getParameterTypes())) && readMethod.getReturnType().isAssignableFrom(method.getReturnType())) {
                    useful = true;
                    break;
                }
                if (this.properties[y].getWriteMethod() == null || !(writeMethod = this.properties[y].getWriteMethod()).getName().equals(method.getName()) || !((Object)Arrays.asList(writeMethod.getParameterTypes())).equals(Arrays.asList(method.getParameterTypes())) || !writeMethod.getReturnType().isAssignableFrom(method.getReturnType())) continue;
                useful = true;
                break;
            }
        }
        if (!useful) {
            throw new CompilationException("Illegal abstract method in EJB class " + this.interfaceClass.getName() + ": " + method);
        }
    }

    public String lowerFirstCharacter(String original) {
        if (Character.isUpperCase(original.charAt(0))) {
            char[] old = original.toCharArray();
            old[0] = original.substring(0, 1).toLowerCase().charAt(0);
            return new String(old);
        }
        return null;
    }
}

