/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.ejb.cache;

import com.evermind.server.ejb.ExtendedContainerManagedObject;
import com.evermind.server.ejb.cache.AlternateHashTable;
import com.evermind.server.ejb.cache.CachePolicy;
import com.evermind.util.ExtendedComparator;

public class CMObjectsHashTable
extends AlternateHashTable {
    ExtendedComparator _comparator = ExtendedComparator.DEFAULT_COMPARATOR;
    CachePolicy _accessPolicy = CachePolicy.DEFAULT_POLICY;

    public CMObjectsHashTable(int initialCapacity) {
        super(initialCapacity);
    }

    public CMObjectsHashTable(int initialCapacity, ExtendedComparator comparator, CachePolicy policy) {
        this(initialCapacity);
        if (comparator != null) {
            this._comparator = comparator;
        }
        if (policy != null) {
            this._accessPolicy = policy;
        }
    }

    public void setComparator(ExtendedComparator comparator) {
        this._comparator = comparator;
    }

    public final Object cloneValue(Object value, boolean merge) {
        return ((ExtendedContainerManagedObject)value)._copy(merge);
    }

    public final Object copyValue(Object from, Object to, boolean merge) {
        return ((ExtendedContainerManagedObject)to)._copy(from, to, merge);
    }

    public final boolean isKeyEqual(Object key1, Object key2) {
        return this._comparator.equalKeys(key1, key2);
    }

    public int keyHashCode(Object object) {
        return this._comparator.keyHashCode(object);
    }

    public int altKeyHashCode(Object object) {
        return this._comparator.keyHashCode(object);
    }

    public void updateAccess(AlternateHashTable.BucketEntry currNode, AlternateHashTable.Bucket b) {
        long time;
        b.access = time = this.getTime();
        currNode.access = time;
    }

    public long getTime() {
        return this._accessPolicy.getTime();
    }

    public boolean hasExpired(AlternateHashTable.BucketEntry currNode, AlternateHashTable.Bucket b, int ttl) {
        return this._accessPolicy.expired(currNode.access, ttl);
    }
}

