/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.ejb;

import com.evermind.security.User;
import com.evermind.server.ThreadState;
import com.evermind.server.ejb.RemoteStatefulSessionEJBObject;
import com.evermind.server.ejb.SessionContainer;
import com.evermind.server.ejb.deployment.ExposableBeanDescriptor;
import java.rmi.RemoteException;
import java.util.Hashtable;
import javax.ejb.EJBObject;
import javax.ejb.Handle;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import oracle.oc4j.rmi.OracleRemoteException;
import oracle.oc4j.transport.TransportManager;

public class StatefulSessionHandle
implements Handle {
    private static final long serialVersionUID = 1907734962021405942L;
    public String homePath;
    public long id;
    public long checksum;
    public transient EJBObject object;
    private String providerUrl;

    public StatefulSessionHandle(RemoteStatefulSessionEJBObject object) {
        this(object, null);
    }

    public StatefulSessionHandle(RemoteStatefulSessionEJBObject object, String url) {
        this.object = object;
        this.id = object.OC4J_getId();
        this.checksum = object.OC4J_getChecksum();
        this.homePath = ((ExposableBeanDescriptor)object.getBeanDescriptor()).getQualifiedLocation();
        this.providerUrl = url;
    }

    public EJBObject getEJBObject() throws RemoteException {
        if (this.object != null) {
            return this.object;
        }
        SessionContainer home = null;
        NamingException namingEx = null;
        try {
            InitialContext context = new InitialContext();
            home = (SessionContainer)context.lookup(this.homePath);
            this.object = home.getRemoteSession(this.id, this.checksum);
            if (this.object != null) {
                return this.object;
            }
        }
        catch (NamingException e) {
            namingEx = e;
        }
        if (this.providerUrl == null) {
            throw new OracleRemoteException("The associated session bean has been discarded from home location=" + this.homePath, namingEx);
        }
        boolean remote = false;
        TransportManager manager = TransportManager.getInstance();
        String managerProviderUrl = null;
        if (manager != null) {
            managerProviderUrl = manager.getProviderUrl("");
            if (this.providerUrl.startsWith(managerProviderUrl)) {
                throw new OracleRemoteException("The associated session bean has been discarded at home location=" + this.homePath + ", providerUrl = " + this.providerUrl, namingEx);
            }
            remote = true;
        }
        try {
            InitialContext context = new InitialContext(remote ? this.getRemoteEnvironment() : this.getClientEnvironment());
            home = (SessionContainer)context.lookup(this.homePath);
            this.object = home.getRemoteSession(this.id, this.checksum);
            if (this.object != null) {
                return this.object;
            }
        }
        catch (NamingException e) {
            namingEx = e;
        }
        throw new OracleRemoteException("The associated session bean have been discarded at  home location=" + this.homePath + ", providerUrl=" + this.providerUrl + ", managerProviderUrl=" + managerProviderUrl, namingEx);
    }

    private Hashtable getClientEnvironment() throws NamingException {
        InitialContext context = new InitialContext();
        Hashtable env = new Hashtable(context.getEnvironment());
        env.put("java.naming.provider.url", this.providerUrl);
        return env;
    }

    private Hashtable getRemoteEnvironment() throws OracleRemoteException {
        ThreadState state = ThreadState.getCurrentState();
        if (state != null && state.getUser() != null) {
            User user = state.getUser();
            String name = user.getName();
            try {
                String pass = user.getPassword();
                if (pass != null) {
                    Hashtable<String, String> env = new Hashtable<String, String>();
                    env.put("java.naming.provider.url", this.providerUrl);
                    env.put("java.naming.factory.initial", "com.evermind.server.rmi.RMIInitialContextFactory");
                    env.put("java.naming.security.principal", name);
                    env.put("java.naming.security.credentials", pass);
                    return env;
                }
                throw new OracleRemoteException("Password is null for " + name + " at providerUrl '" + this.providerUrl + "'");
            }
            catch (Throwable t) {
                throw new OracleRemoteException("Cannot get the password for " + name + " to connect to a remote bean at providerUrl '" + this.providerUrl + "'", t);
            }
        }
        throw new OracleRemoteException("Cannot get User from ThreadState  at providerUrl '" + this.providerUrl + "'");
    }
}

