/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.ejb;

import com.evermind.server.ejb.EJBContainer;
import com.evermind.server.ejb.EJBPackageDeployment;
import com.evermind.server.ejb.StatefulSessionEJBHome;
import com.evermind.server.ejb.deployment.BeanDescriptor;
import com.evermind.server.http.HttpDateFormat;
import java.util.Collection;
import java.util.Iterator;

public class EJBTask
implements Runnable {
    private EJBContainer container;

    public EJBTask(EJBContainer container) {
        this.container = container;
    }

    public void run() {
        long currentTime = HttpDateFormat.currentTimeMillis();
        Collection modules = this.container.getDeployedPackages();
        Iterator mi = modules.iterator();
        while (mi.hasNext()) {
            EJBPackageDeployment module = (EJBPackageDeployment)mi.next();
            Iterator i = module.getPackage().getAllBeans().iterator();
            while (i.hasNext()) {
                BeanDescriptor desc = (BeanDescriptor)i.next();
                if (desc.getBeanPool() == null) continue;
                desc.getBeanPool().expirePool();
            }
            Collection homes = module.getDeployedHomes();
            Iterator hi = homes.iterator();
            while (hi.hasNext()) {
                Object genericHome = hi.next();
                if (!(genericHome instanceof StatefulSessionEJBHome)) continue;
                StatefulSessionEJBHome home = (StatefulSessionEJBHome)genericHome;
                if (home.lastCacheCheck + home.cacheCheckInterval < currentTime) {
                    home.lastCacheCheck = currentTime;
                    home.cleanUpMaintenance();
                    continue;
                }
                if (home.lastCacheCheck <= currentTime) continue;
                home.lastCacheCheck = currentTime;
            }
        }
    }
}

