/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.ejb;

import com.evermind.naming.archive.ArchiveContext;
import com.evermind.naming.archive.MemoryArchiveContext;
import com.evermind.naming.file.FileContext;
import com.evermind.server.ejb.AnnotationListener;
import com.evermind.server.ejb.EJBUtils;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.zip.ZipEntry;
import javax.naming.Context;
import javax.naming.NamingException;
import oracle.j2ee.deployment.AnnotationParsingMessages;

public class AnnotationParser {
    private static final String GET_ANNOTATIONS_METHOD = "getDeclaredAnnotations";
    private static Method getAnnotationsMethod;
    private static final String ANNOTATION_MANAGER_CLASS = "com.evermind.server.deployment.AnnotationManager";
    private Object annotationManager;
    private Collection annotationListeners;

    protected boolean parseAnnotations(ClassLoader tempLoader, Context ctx) {
        if (!EJBUtils.isJdk50()) {
            return false;
        }
        boolean hasAnnotatedClass = false;
        try {
            if (getAnnotationsMethod == null) {
                getAnnotationsMethod = Class.class.getMethod(GET_ANNOTATIONS_METHOD, null);
            }
            Iterator applicationClasses = this.getClasses(ctx, tempLoader).iterator();
            while (applicationClasses.hasNext()) {
                Class cls = (Class)applicationClasses.next();
                if (((Object[])getAnnotationsMethod.invoke((Object)cls, null)).length <= 0) continue;
                AnnotationParsingMessages.finerFoundAnnotatedClass(cls.getName());
                this.notifyAnnotationListeners(cls, tempLoader);
                hasAnnotatedClass = true;
            }
        }
        catch (NoSuchMethodException e) {
            throw EJBUtils.createEJBException(e);
        }
        catch (IllegalArgumentException e) {
            throw EJBUtils.createEJBException(e);
        }
        catch (IllegalAccessException e) {
            throw EJBUtils.createEJBException(e);
        }
        catch (InvocationTargetException e) {
            throw EJBUtils.createEJBException(e);
        }
        return hasAnnotatedClass;
    }

    private Collection getClasses(Context ctx, ClassLoader tempLoader) {
        ArrayList<Class> classes;
        block8: {
            classes = new ArrayList<Class>();
            try {
                if (ctx instanceof ArchiveContext) {
                    ArchiveContext ac = (ArchiveContext)ctx;
                    Enumeration<? extends ZipEntry> e = ac.getZip().entries();
                    while (e.hasMoreElements()) {
                        Class c;
                        ZipEntry entry = e.nextElement();
                        if (!entry.getName().endsWith(".class") || (c = this.loadTempClass(entry.getName(), tempLoader)) == null) continue;
                        classes.add(c);
                    }
                    break block8;
                }
                if (ctx instanceof MemoryArchiveContext) {
                    MemoryArchiveContext ac = (MemoryArchiveContext)ctx;
                    Iterator j = ac.getArchive().getNames().iterator();
                    while (j.hasNext()) {
                        Class c;
                        String name = (String)j.next();
                        if (!name.endsWith(".class") || (c = this.loadTempClass(name, tempLoader)) == null) continue;
                        classes.add(c);
                    }
                    break block8;
                }
                if (ctx instanceof FileContext) {
                    File rootDir = ((FileContext)ctx).getFile();
                    this.getClasses(rootDir.getAbsolutePath().length() + 1, rootDir, tempLoader, classes);
                    break block8;
                }
                throw EJBUtils.createEJBException("Unsupported context type: " + ctx.getClass().getName());
            }
            catch (IOException e) {
                throw EJBUtils.createEJBException(e);
            }
            catch (NamingException e) {
                throw EJBUtils.createEJBException(e);
            }
        }
        return classes;
    }

    private void getClasses(int rootFileNameEnd, File dir, ClassLoader tempLoader, ArrayList classes) throws NamingException {
        if (dir == null || !dir.isDirectory()) {
            return;
        }
        File[] files = dir.listFiles();
        for (int i = 0; i < files.length; ++i) {
            Class c;
            if (files[i].isDirectory()) {
                this.getClasses(rootFileNameEnd, files[i], tempLoader, classes);
                continue;
            }
            if (!files[i].getName().endsWith(".class") || (c = this.loadTempClass(files[i].getAbsolutePath().substring(rootFileNameEnd), tempLoader)) == null) continue;
            classes.add(c);
        }
    }

    private Class loadTempClass(String className, ClassLoader tempLoader) {
        AnnotationParsingMessages.finestInspectingClass(className);
        className = className.replace('/', '.').replace('\\', '.').substring(0, className.indexOf(".class"));
        try {
            return tempLoader.loadClass(className);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    protected synchronized void addAnnotationListener(AnnotationListener listener) {
        if (listener == null) {
            return;
        }
        if (this.annotationListeners == null) {
            this.annotationListeners = new ArrayList(3);
        }
        this.annotationListeners.add(listener);
    }

    protected synchronized void removeAnnotationListener(AnnotationListener listener) {
        if (this.annotationListeners == null) {
            return;
        }
        this.annotationListeners.remove(listener);
    }

    private void notifyAnnotationListeners(Class annotatedClass, ClassLoader tempLoader) {
        if (this.annotationListeners == null) {
            return;
        }
        Iterator listeners = this.annotationListeners.iterator();
        while (listeners.hasNext()) {
            ((AnnotationListener)listeners.next()).parseAnnotatedClass(annotatedClass, tempLoader, this.getAnnotationManager());
        }
    }

    public Object getAnnotationManager() {
        try {
            if (this.annotationManager == null) {
                Class<?> cls = Class.forName(ANNOTATION_MANAGER_CLASS);
                this.annotationManager = cls.newInstance();
            }
        }
        catch (Exception e) {
            throw EJBUtils.createEJBException(e);
        }
        return this.annotationManager;
    }
}

