/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.deployment;

import com.evermind.server.deployment.InjectableReference;
import com.evermind.xml.XMLUtils;
import com.evermind.xml.XMLizable;
import java.io.PrintWriter;
import java.io.Serializable;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ResourceEnvironmentReference
extends InjectableReference
implements XMLizable,
Serializable {
    private static final long serialVersionUID = -2195494956686585721L;
    protected Object value;
    protected String location;

    public ResourceEnvironmentReference() {
    }

    public ResourceEnvironmentReference(String name, String type) throws InstantiationException {
        this.setName(name);
        this.setType(type);
    }

    public ResourceEnvironmentReference(Node parent) throws InstantiationException {
        this.parseXML(parent);
    }

    public void parseXML(Node parent) throws InstantiationException {
        NodeList nodes = parent.getChildNodes();
        if (nodes != null) {
            for (int i = 0; i < nodes.getLength(); ++i) {
                Node node = nodes.item(i);
                String nodeName = node.getNodeName();
                if (XMLUtils.isCommentOrID(nodeName)) continue;
                String value = XMLUtils.getStringValue(node);
                if (nodeName.equals("resource-env-ref-name")) {
                    this.setName(value);
                    continue;
                }
                if (nodeName.equals("description")) {
                    this.setDescription(value);
                    continue;
                }
                if (nodeName.equals("resource-env-ref-type")) {
                    this.setType(value);
                    continue;
                }
                if (nodeName.equals("mapped-name") && value.length() > 0) {
                    this.setLocation(value);
                    continue;
                }
                if (this.parseInjectionTarget(node)) continue;
                throw new InstantiationException("Unknown resource-env-ref tag: " + nodeName);
            }
        }
        if (this.getName() == null) {
            throw new InstantiationException("resource-env-ref tag with missing resource-env-ref-name subtag");
        }
        if (this.getType() == null) {
            throw new InstantiationException("resource-env-ref tag with missing resource-env-ref-type subtag");
        }
    }

    public String getLocation() {
        return this.location;
    }

    public String getType() {
        return this.getReferenceClass();
    }

    public void setLocation(String location) {
        this.location = location;
        this.firePropertyChangeEvent("location", this.location, location);
    }

    public void writeXML(PrintWriter out, String indention) {
        out.println(indention + "<resource-env-ref>");
        if (this.getDescription() != null) {
            out.println(indention + "\t<description>" + XMLUtils.encode(this.getDescription()) + "</description>");
        }
        if (this.getName() != null) {
            out.println(indention + "\t<resource-env-ref-name>" + XMLUtils.encode(this.getName()) + "</resource-env-ref-name>");
        } else {
            out.println(indention + "\t<resource-env-ref-name>unnamed</resource-env-ref-name>");
        }
        if (this.getType() != null) {
            out.println(indention + "\t<resource-env-ref-type>" + XMLUtils.encode(this.getType()) + "</resource-env-ref-type>");
        } else {
            out.println(indention + "\t<resource-env-ref-type>javax.sql.DataSource</resource-env-ref-type>");
        }
        this.writeMappedName(out, indention + "\t", this.location);
        this.writeInjectableXML(out, indention + "\t");
        out.println(indention + "</resource-env-ref>");
    }

    public void parseOrionXML(Node parent) throws InstantiationException {
        this.location = XMLUtils.getNodeAttribute(parent, "location");
    }

    public void writeOrionXML(PrintWriter out, String indention) {
        out.print(indention + "<resource-env-ref-mapping name=\"" + XMLUtils.encode(this.getName()) + "\"");
        if (this.location != null) {
            out.print(" location=\"" + XMLUtils.encode(this.location) + "\"");
        }
        out.println(" />");
    }

    public Object getValue() throws InstantiationException {
        return this.value;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("resource-env-ref      : ");
        buf.append("\n");
        buf.append("  name      : ");
        buf.append(this.getName());
        buf.append("\n");
        buf.append("  type      : ");
        buf.append(this.getType());
        buf.append("\n");
        buf.append("  description      : ");
        buf.append(this.getDescription());
        buf.append("\n");
        return buf.toString();
    }

    public void setType(String type) {
        super.setReferenceClass(type);
    }
}

