/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.deployment;

import com.evermind.server.deployment.AnnotationManager;
import com.evermind.server.deployment.DestinationReference;
import com.evermind.server.deployment.EnvironmentEntry;
import com.evermind.server.deployment.InjectableReference;
import com.evermind.server.deployment.InjectionField;
import com.evermind.server.deployment.InjectionMethod;
import com.evermind.server.deployment.InjectionTarget;
import com.evermind.server.deployment.ResourceEnvironmentReference;
import com.evermind.server.deployment.ResourceReference;
import com.evermind.server.ejb.deployment.EJBReference;
import com.evermind.server.ejb.deployment.PersistenceContextReference;
import com.evermind.server.ejb.deployment.PersistenceUnitReference;
import com.evermind.util.ClassUtils;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import javax.annotation.Resource;
import javax.annotation.Resources;
import javax.ejb.EJB;
import javax.ejb.EJBException;
import javax.ejb.EJBs;
import javax.jws.WebService;
import javax.persistence.PersistenceContext;
import javax.persistence.PersistenceContextType;
import javax.persistence.PersistenceContexts;
import javax.persistence.PersistenceProperty;
import javax.persistence.PersistenceUnit;
import javax.persistence.PersistenceUnits;
import javax.xml.ws.WebServiceRef;
import oracle.j2ee.deployment.AnnotationParsingMessages;
import oracle.j2ee.ws.server.deployment.ServiceReferenceDescriptor;
import oracle.oc4j.configuration.J2EEContextConfigDelegate;

public class J2EEContextAnnotationParser {
    public static final Class EJB_ANNOTATION = EJB.class;
    public static final Class EJBS_ANNOTATION = EJBs.class;
    public static final Class RESOURCE_ANNOTATION = Resource.class;
    public static final Class RESOURCES_ANNOTATION = Resources.class;
    public static final Class PERSISTENCE_UNIT_ANNOTATION = PersistenceUnit.class;
    public static final Class PERSISTENCE_UNITS_ANNOTATION = PersistenceUnits.class;
    public static final Class PERSISTENCE_CONTEXT_ANNOTATION = PersistenceContext.class;
    public static final Class PERSISTENCE_CONTEXTS_ANNOTATION = PersistenceContexts.class;
    public static final Class WEBSERVICE_REF_ANNOTATION = WebServiceRef.class;
    AnnotationManager annotationMgr;
    boolean isStaticInjectionParsing = false;

    public J2EEContextAnnotationParser() {
        this.annotationMgr = new AnnotationManager();
    }

    public J2EEContextAnnotationParser(AnnotationManager annotMgr) {
        this.annotationMgr = annotMgr;
    }

    public void parse(J2EEContextConfigDelegate config, Class baseClass) throws InstantiationException {
        this.parseClassLevelAnnotations(config, baseClass);
        for (Field field : this.annotationMgr.getFields(baseClass)) {
            this.parseInjectedField(config, field);
        }
        for (Method method : this.annotationMgr.getMethods(baseClass)) {
            this.parseInjectedMethod(config, method);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parseStaticInjection(J2EEContextConfigDelegate config, Class baseClass) throws InstantiationException {
        this.isStaticInjectionParsing = true;
        try {
            for (Field field : this.annotationMgr.getStaticFields(baseClass)) {
                this.parseInjectedField(config, field);
            }
            for (Method method : this.annotationMgr.getStaticMethods(baseClass)) {
                this.parseInjectedMethod(config, method);
            }
        }
        finally {
            this.isStaticInjectionParsing = false;
        }
    }

    protected void parseClassLevelAnnotations(J2EEContextConfigDelegate config, Class cls) throws InstantiationException {
        Object annot;
        if (!cls.getSuperclass().equals(Object.class)) {
            this.parseClassLevelAnnotations(config, cls.getSuperclass());
        }
        if ((annot = cls.getAnnotation(EJB_ANNOTATION)) != null) {
            AnnotationParsingMessages.finestParsingClassLevelAnnotation(EJB_ANNOTATION.getName());
            this.parseClassLevelEJB(config, (EJB)annot, cls);
        }
        if ((annot = cls.getAnnotation(EJBS_ANNOTATION)) != null) {
            AnnotationParsingMessages.finestParsingClassLevelAnnotation(EJBS_ANNOTATION.getName());
            for (EJB eJB : ((EJBs)annot).value()) {
                this.parseClassLevelEJB(config, eJB, cls);
            }
        }
        if ((annot = cls.getAnnotation(RESOURCE_ANNOTATION)) != null) {
            AnnotationParsingMessages.finestParsingClassLevelAnnotation(RESOURCE_ANNOTATION.getName());
            this.parseClassLevelResource(config, (Resource)annot, cls);
        }
        if ((annot = cls.getAnnotation(RESOURCES_ANNOTATION)) != null) {
            AnnotationParsingMessages.finestParsingClassLevelAnnotation(RESOURCES_ANNOTATION.getName());
            for (EJB eJB : ((Resources)annot).value()) {
                this.parseClassLevelResource(config, (Resource)eJB, cls);
            }
        }
        if ((annot = cls.getAnnotation(PERSISTENCE_UNIT_ANNOTATION)) != null) {
            AnnotationParsingMessages.finestParsingClassLevelAnnotation(PERSISTENCE_UNIT_ANNOTATION.getName());
            this.parseClassLevelPersistenceUnit(config, (PersistenceUnit)annot, cls);
        }
        if ((annot = cls.getAnnotation(PERSISTENCE_UNITS_ANNOTATION)) != null) {
            AnnotationParsingMessages.finestParsingClassLevelAnnotation(PERSISTENCE_UNITS_ANNOTATION.getName());
            for (EJB eJB : ((PersistenceUnits)annot).value()) {
                this.parseClassLevelPersistenceUnit(config, (PersistenceUnit)eJB, cls);
            }
        }
        if ((annot = cls.getAnnotation(PERSISTENCE_CONTEXT_ANNOTATION)) != null) {
            AnnotationParsingMessages.finestParsingClassLevelAnnotation(PERSISTENCE_CONTEXT_ANNOTATION.getName());
            this.parseClassLevelPersistenceContext(config, (PersistenceContext)annot, cls);
        }
        if ((annot = cls.getAnnotation(PERSISTENCE_CONTEXTS_ANNOTATION)) != null) {
            AnnotationParsingMessages.finestParsingClassLevelAnnotation(PERSISTENCE_CONTEXTS_ANNOTATION.getName());
            for (EJB eJB : ((PersistenceContexts)annot).value()) {
                this.parseClassLevelPersistenceContext(config, (PersistenceContext)eJB, cls);
            }
        }
        if ((annot = cls.getAnnotation(WEBSERVICE_REF_ANNOTATION)) != null) {
            AnnotationParsingMessages.finestParsingClassLevelAnnotation(WEBSERVICE_REF_ANNOTATION.getName());
            this.parseClassLevelWebServiceRef(config, (WebServiceRef)annot, cls);
        }
    }

    protected void parseClassLevelWebServiceRef(J2EEContextConfigDelegate config, WebServiceRef webServiceRef, Class cls) throws InstantiationException {
        String name = webServiceRef.name();
        if (J2EEContextAnnotationParser.valueIsEmpty(name)) {
            throw new InstantiationException("No name specified for class level WebServiceRef.  You must specify the name attribute for any class level WebServiceRef annotation.");
        }
        Class type = webServiceRef.type();
        if (J2EEContextAnnotationParser.valueIsEmpty(type)) {
            throw new InstantiationException("No type specified for class level WebServiceRef.  You must specify the class attribute for any class level WebServiceRef annotation.");
        }
        String wsdlUri = webServiceRef.wsdlLocation();
        String intf = webServiceRef.value().getName();
        if (J2EEContextAnnotationParser.valueIsEmpty(webServiceRef.value())) {
            intf = "javax.xml.rpc.Service";
        }
        J2EEContextAnnotationParser.addServiceReference(config, name, type, intf, wsdlUri, webServiceRef.mappedName(), cls.getClassLoader());
    }

    public void parseInjectedField(J2EEContextConfigDelegate config, Field field) throws InstantiationException {
        Object annot = field.getAnnotation(EJB_ANNOTATION);
        if (annot != null) {
            AnnotationParsingMessages.finestParsingFieldLevelAnnotation(EJB_ANNOTATION.getName(), field.getName());
            this.parseInjectedEJB(config, (EJB)annot, field.getDeclaringClass(), field.getType(), J2EEContextAnnotationParser.createInjectionTarget(field));
        } else {
            annot = field.getAnnotation(RESOURCE_ANNOTATION);
            if (annot != null) {
                AnnotationParsingMessages.finestParsingFieldLevelAnnotation(RESOURCE_ANNOTATION.getName(), field.getName());
                this.parseInjectedResource(config, (Resource)annot, field.getDeclaringClass(), field.getType(), J2EEContextAnnotationParser.createInjectionTarget(field));
            } else {
                annot = field.getAnnotation(PERSISTENCE_UNIT_ANNOTATION);
                if (annot != null) {
                    AnnotationParsingMessages.finestParsingFieldLevelAnnotation(PERSISTENCE_UNIT_ANNOTATION.getName(), field.getName());
                    if (this.isStaticInjectionParsing) {
                        throw new InstantiationException("@PersistenceContext is not allowed to inject to application client static field '" + field.getName() + "' of " + field.getDeclaringClass().getName());
                    }
                    this.parseInjectedPersistenceUnit(config, (PersistenceUnit)annot, J2EEContextAnnotationParser.createInjectionTarget(field));
                } else {
                    annot = field.getAnnotation(PERSISTENCE_CONTEXT_ANNOTATION);
                    if (annot != null) {
                        AnnotationParsingMessages.finestParsingFieldLevelAnnotation(PERSISTENCE_CONTEXT_ANNOTATION.getName(), field.getName());
                        if (this.isStaticInjectionParsing) {
                            throw new InstantiationException("@PersistenceUnit is not allowed to inject to application client static field '" + field.getName() + "' of " + field.getDeclaringClass().getName());
                        }
                        this.parseInjectedPersistenceContext(config, (PersistenceContext)annot, J2EEContextAnnotationParser.createInjectionTarget(field));
                    } else {
                        annot = field.getAnnotation(WEBSERVICE_REF_ANNOTATION);
                        if (annot != null) {
                            AnnotationParsingMessages.finestParsingFieldLevelAnnotation(WEBSERVICE_REF_ANNOTATION.getName(), field.getName());
                            this.parseInjectedWebServiceRef(config, (WebServiceRef)annot, J2EEContextAnnotationParser.createInjectionTarget(field), field.getType(), field.getDeclaringClass().getClassLoader());
                        }
                    }
                }
            }
        }
    }

    private void parseInjectedWebServiceRef(J2EEContextConfigDelegate config, WebServiceRef webServiceRef, InjectionTarget injectionTarget, Class type, ClassLoader cl) throws InstantiationException {
        String refName = webServiceRef.name();
        Class serviceType = webServiceRef.type();
        String serviceIntf = webServiceRef.value().getName();
        String wsdlUri = webServiceRef.wsdlLocation();
        if (J2EEContextAnnotationParser.valueIsEmpty(refName)) {
            refName = injectionTarget.getTargetName();
        }
        if (J2EEContextAnnotationParser.valueIsEmpty(webServiceRef.type())) {
            serviceType = type;
        }
        if (J2EEContextAnnotationParser.valueIsEmpty(webServiceRef.value())) {
            serviceIntf = "javax.xml.rpc.Service";
        }
        ServiceReferenceDescriptor desc = J2EEContextAnnotationParser.addServiceReference(config, refName, serviceType, serviceIntf, wsdlUri, webServiceRef.mappedName(), cl);
        desc.addInjectionTarget(injectionTarget);
    }

    public static ServiceReferenceDescriptor addServiceReference(J2EEContextConfigDelegate config, String name, Class type, String intf, String wsdlUri, String mappedName, ClassLoader cl) throws InstantiationException {
        ServiceReferenceDescriptor desc = new ServiceReferenceDescriptor();
        desc.setName(name);
        desc.setReferenceClass(type.getName());
        desc.setServiceInterface(intf);
        desc.setMappedName(mappedName);
        WebService ws = type.getAnnotation(WebService.class);
        if (J2EEContextAnnotationParser.valueIsEmpty(wsdlUri)) {
            if (ws == null || J2EEContextAnnotationParser.valueIsEmpty(ws.wsdlLocation())) {
                throw new InstantiationException("No wsdlLocation was specified for the service reference: " + name + " and there was no @WebService.wsdlLocation property on the interface: " + type.getName() + ".  You must either provide a wsdlLocation property on the @WebServiceRef annotation or add the property to " + " the interface of the field/setter method parameter being injected.");
            }
            wsdlUri = ws.wsdlLocation();
        }
        desc.setWsdlFileUri(wsdlUri);
        String mappingFileBaseName = null;
        if (ws != null) {
            if (!J2EEContextAnnotationParser.valueIsEmpty(ws.serviceName())) {
                mappingFileBaseName = ws.serviceName();
                mappingFileBaseName = mappingFileBaseName + "-java-wsdl-mapping";
            } else {
                mappingFileBaseName = ws.name();
                mappingFileBaseName = mappingFileBaseName + "Service-java-wsdl-mapping";
            }
        }
        if (J2EEContextAnnotationParser.valueIsEmpty(mappingFileBaseName) || !desc.mappingFileExists("META-INF/" + mappingFileBaseName + ".xml", cl) && !desc.mappingFileExists("WEB-INF/" + mappingFileBaseName + ".xml", cl)) {
            if (J2EEContextAnnotationParser.valueIsURL(wsdlUri)) {
                throw new InstantiationException("The wsdl file " + wsdlUri + " does not appear to be packaged in the EJB or WEB archive." + " Remote WSDLs are not supported.  WSDLs must be packaged under the META-INF or WEB-INF directories of the respective archive.");
            }
            String wsdlName = wsdlUri;
            int index = wsdlUri.lastIndexOf("/");
            if (index != -1) {
                wsdlName = wsdlName.substring(wsdlUri.lastIndexOf("/") + 1);
            }
            index = wsdlName.lastIndexOf(".wsdl");
            wsdlName = wsdlName.substring(0, index);
            mappingFileBaseName = wsdlName + "-java-wsdl-mapping";
        }
        String mappingFileLoc = "";
        if (desc.mappingFileExists("META-INF/" + mappingFileBaseName + ".xml", cl)) {
            mappingFileLoc = "META-INF/" + mappingFileBaseName + ".xml";
        } else if (desc.mappingFileExists("WEB-INF/" + mappingFileBaseName + ".xml", cl)) {
            mappingFileLoc = "WEB-INF/" + mappingFileBaseName + ".xml";
        } else {
            throw new InstantiationException("Unable to find the mapping file: " + mappingFileBaseName + ".xml.  This file must be packaged under META-INF for EJB jar files or WEB-INF for web archives");
        }
        desc.setMappingFileUri(mappingFileLoc);
        config.addServiceReference(desc);
        return desc;
    }

    private static boolean valueIsURL(String wsdlUri) {
        try {
            URL url = new URL(wsdlUri);
            return true;
        }
        catch (MalformedURLException e) {
            return false;
        }
    }

    public void parseInjectedMethod(J2EEContextConfigDelegate config, Method method) throws InstantiationException {
        Object annot = method.getAnnotation(EJB_ANNOTATION);
        if (annot != null) {
            AnnotationParsingMessages.finestParsingMethodLevelAnnotation(EJB_ANNOTATION.getName(), method.getName());
            this.parseInjectedEJB(config, (EJB)annot, method.getDeclaringClass(), method.getParameterTypes()[0], J2EEContextAnnotationParser.createInjectionTarget(method));
        } else {
            annot = method.getAnnotation(RESOURCE_ANNOTATION);
            if (annot != null) {
                AnnotationParsingMessages.finestParsingMethodLevelAnnotation(RESOURCE_ANNOTATION.getName(), method.getName());
                this.parseInjectedResource(config, (Resource)annot, method.getDeclaringClass(), method.getParameterTypes()[0], J2EEContextAnnotationParser.createInjectionTarget(method));
            } else {
                annot = method.getAnnotation(PERSISTENCE_UNIT_ANNOTATION);
                if (annot != null) {
                    AnnotationParsingMessages.finestParsingMethodLevelAnnotation(PERSISTENCE_UNIT_ANNOTATION.getName(), method.getName());
                    if (this.isStaticInjectionParsing) {
                        throw new InstantiationException("@PersistenceContext  is not allowed to inject to application client static method '" + method.getName() + "' of " + method.getDeclaringClass().getName());
                    }
                    this.parseInjectedPersistenceUnit(config, (PersistenceUnit)annot, J2EEContextAnnotationParser.createInjectionTarget(method));
                } else {
                    annot = method.getAnnotation(PERSISTENCE_CONTEXT_ANNOTATION);
                    if (annot != null) {
                        AnnotationParsingMessages.finestParsingMethodLevelAnnotation(PERSISTENCE_CONTEXT_ANNOTATION.getName(), method.getName());
                        if (this.isStaticInjectionParsing) {
                            throw new InstantiationException("@PersistenceUnit  is not allowed to inject to application client static method '" + method.getName() + "' of " + method.getDeclaringClass().getName());
                        }
                        this.parseInjectedPersistenceContext(config, (PersistenceContext)annot, J2EEContextAnnotationParser.createInjectionTarget(method));
                    } else {
                        annot = method.getAnnotation(WEBSERVICE_REF_ANNOTATION);
                        if (annot != null) {
                            AnnotationParsingMessages.finestParsingMethodLevelAnnotation(WEBSERVICE_REF_ANNOTATION.getName(), method.getName());
                            this.parseInjectedWebServiceRef(config, (WebServiceRef)annot, J2EEContextAnnotationParser.createInjectionTarget(method), method.getParameterTypes()[0], method.getDeclaringClass().getClassLoader());
                        }
                    }
                }
            }
        }
    }

    protected void parseClassLevelEJB(J2EEContextConfigDelegate config, EJB ejbAnnot, Class cls) throws InstantiationException {
        String refName = ejbAnnot.name();
        if (J2EEContextAnnotationParser.valueIsEmpty(refName)) {
            throw new InstantiationException("@EJB annotation at class-level of " + cls.getName() + " must specify a name.");
        }
        if (J2EEContextAnnotationParser.valueIsEmpty(ejbAnnot.beanInterface()) && J2EEContextAnnotationParser.valueIsEmpty(ejbAnnot.beanName())) {
            throw new InstantiationException("@EJB annotation at class-level of " + cls.getName() + " must specify a beanInterface or beanName.");
        }
        if (config.getEJBReference(refName) != null) {
            throw new EJBException("@EJB annotation at class-level of " + cls.getName() + " specifies the name '" + refName + "' is already used.");
        }
        String intfName = null;
        if (!J2EEContextAnnotationParser.valueIsEmpty(ejbAnnot.beanInterface())) {
            intfName = ejbAnnot.beanInterface().getName();
        }
        J2EEContextAnnotationParser.addEJBReference(config, ejbAnnot.beanName(), ejbAnnot.description(), refName, ejbAnnot.mappedName(), intfName);
    }

    public static EJBReference addEJBReference(J2EEContextConfigDelegate config, String beanName, String description, String refName, String mappedName, String interfaceName) {
        EJBReference ejbRef = new EJBReference(refName, false, true);
        if (!J2EEContextAnnotationParser.valueIsEmpty(interfaceName)) {
            ejbRef.setHomeName(interfaceName);
            ejbRef.setRemoteName(interfaceName);
        }
        if (!J2EEContextAnnotationParser.valueIsEmpty(beanName)) {
            ejbRef.setEJBLink(beanName);
        }
        if (!J2EEContextAnnotationParser.valueIsEmpty(description)) {
            ejbRef.setDescription(description);
        }
        if (!J2EEContextAnnotationParser.valueIsEmpty(mappedName)) {
            ejbRef.setLocation(mappedName);
        }
        config.addEJBReference(ejbRef);
        return ejbRef;
    }

    protected void parseInjectedEJB(J2EEContextConfigDelegate config, EJB ejbAnnot, Class srcCls, Class targetCls, InjectionTarget target) throws InstantiationException {
        EJBReference ejbRef;
        String refName = ejbAnnot.name();
        if (J2EEContextAnnotationParser.valueIsEmpty(refName)) {
            refName = target.getDefaultRefName();
        }
        String intfClass = null;
        if (J2EEContextAnnotationParser.valueIsEmpty(ejbAnnot.beanInterface())) {
            if (J2EEContextAnnotationParser.valueIsEmpty(ejbAnnot.beanName())) {
                intfClass = target.getResourceType();
            }
        } else {
            this.validateInjectionAndAnnotationTypes("@EJB", srcCls, target.getTargetName(), targetCls, ejbAnnot.beanInterface());
            intfClass = ejbAnnot.beanInterface().getName();
        }
        if ((ejbRef = config.getEJBReference(refName)) != null) {
            if (intfClass != null && ejbRef.getLink() == null) {
                String oldRefName = ejbRef.getRemoteName();
                if (ejbRef.getHomeName() != null) {
                    oldRefName = ejbRef.getHomeName();
                }
                if (!intfClass.equals(oldRefName)) {
                    throw new InstantiationException("Injected field/property " + target.getTargetName() + "'s type ( " + intfClass + ")does not match the declared @EJB type (" + oldRefName + ")");
                }
            }
        } else {
            ejbRef = J2EEContextAnnotationParser.addEJBReference(config, ejbAnnot.beanName(), ejbAnnot.description(), refName, ejbAnnot.mappedName(), intfClass);
        }
        ejbRef.setReferenceClass(intfClass == null ? target.getResourceType() : intfClass);
        ejbRef.addInjectionTarget(target);
    }

    protected void parseClassLevelPersistenceContext(J2EEContextConfigDelegate config, PersistenceContext pcAnnot, Class cls) throws InstantiationException {
        String resourceName = pcAnnot.name();
        if (J2EEContextAnnotationParser.valueIsEmpty(resourceName)) {
            throw new InstantiationException("@PersistenceContext annotation at class-level of " + cls.getName() + " must specify a name.");
        }
        J2EEContextAnnotationParser.addPersistenceContextReference(config, resourceName, pcAnnot.unitName(), pcAnnot.type(), pcAnnot.properties());
    }

    public static PersistenceContextReference addPersistenceContextReference(J2EEContextConfigDelegate config, String refName, String unitName, PersistenceContextType type, PersistenceProperty[] props) {
        PersistenceContextReference ref = new PersistenceContextReference(refName);
        if (!J2EEContextAnnotationParser.valueIsEmpty(unitName)) {
            ref.setUnitName(unitName);
        }
        if (type == PersistenceContextType.EXTENDED) {
            ref.setUnitType("EXTENDED");
        }
        config.addPersistenceContextReference(ref);
        return ref;
    }

    protected void parseInjectedPersistenceContext(J2EEContextConfigDelegate config, PersistenceContext pcAnnot, InjectionTarget target) {
        String refName = pcAnnot.name();
        if (J2EEContextAnnotationParser.valueIsEmpty(refName)) {
            refName = target.getDefaultRefName();
        }
        PersistenceContextReference ref = J2EEContextAnnotationParser.addPersistenceContextReference(config, refName, pcAnnot.unitName(), pcAnnot.type(), pcAnnot.properties());
        ref.setReferenceClass(target.getResourceType());
        ref.addInjectionTarget(target);
    }

    protected void parseInjectedPersistenceUnit(J2EEContextConfigDelegate config, PersistenceUnit puAnnot, InjectionTarget target) {
        String refName = puAnnot.name();
        if (J2EEContextAnnotationParser.valueIsEmpty(refName)) {
            refName = target.getDefaultRefName();
        }
        PersistenceUnitReference ref = J2EEContextAnnotationParser.addPersistenceUnitReference(config, refName, puAnnot.unitName());
        ref.setReferenceClass(target.getResourceType());
        ref.addInjectionTarget(target);
    }

    protected void parseClassLevelPersistenceUnit(J2EEContextConfigDelegate config, PersistenceUnit puAnnot, Class cls) throws InstantiationException {
        String resourceName = puAnnot.name();
        if (J2EEContextAnnotationParser.valueIsEmpty(resourceName)) {
            throw new InstantiationException("@PersistenceUnit annotation at class-level of " + cls.getName() + " must specify a name.");
        }
        J2EEContextAnnotationParser.addPersistenceUnitReference(config, resourceName, puAnnot.unitName());
    }

    public static PersistenceUnitReference addPersistenceUnitReference(J2EEContextConfigDelegate config, String refName, String unitName) {
        PersistenceUnitReference ref = new PersistenceUnitReference(refName);
        if (!J2EEContextAnnotationParser.valueIsEmpty(unitName)) {
            ref.setUnitName(unitName);
        }
        config.addPersistenceUnitReference(ref);
        return ref;
    }

    protected void parseInjectedResource(J2EEContextConfigDelegate config, Resource resourceAnnot, Class srcCls, Class targetCls, InjectionTarget target) throws InstantiationException {
        String resourceType;
        String resourceName = resourceAnnot.name();
        if (J2EEContextAnnotationParser.valueIsEmpty(resourceName)) {
            resourceName = target.getDefaultRefName();
        }
        if (J2EEContextAnnotationParser.valueIsEmpty(resourceAnnot.type())) {
            resourceType = target.getResourceType();
        } else {
            this.validateInjectionAndAnnotationTypes("@Resource", srcCls, target.getTargetName(), targetCls, resourceAnnot.type());
            resourceType = resourceAnnot.type().getName();
        }
        InjectableReference ref = J2EEContextAnnotationParser.addResourceReference(config, resourceName, resourceAnnot.mappedName(), resourceType, resourceAnnot.authenticationType(), resourceAnnot.shareable(), resourceAnnot.description(), target);
        ref.setReferenceClass(resourceType);
        ref.addInjectionTarget(target);
    }

    protected void parseClassLevelResource(J2EEContextConfigDelegate config, Resource resourceAnnot, Class cls) throws InstantiationException {
        String resourceClsName;
        String resourceName = resourceAnnot.name();
        Class resourceType = resourceAnnot.type();
        if (J2EEContextAnnotationParser.valueIsEmpty(resourceName)) {
            throw new InstantiationException("@Resource annotation at class-level of " + cls.getName() + " must specify a name.");
        }
        if (J2EEContextAnnotationParser.valueIsEmpty(resourceType)) {
            throw new InstantiationException("@Resource annotation at class-level of " + cls.getName() + " must specify a type.");
        }
        if (!J2EEContextAnnotationParser.valueIsEmpty(resourceType) && this.isInternalDependencyRef(resourceClsName = resourceType.getName())) {
            throw new InstantiationException("@Resource with type " + resourceType + " can only be defined at the field or method level.");
        }
        resourceClsName = resourceType.getName();
        J2EEContextAnnotationParser.addResourceReference(config, resourceName, resourceAnnot.mappedName(), resourceClsName, resourceAnnot.authenticationType(), resourceAnnot.shareable(), resourceAnnot.description(), null);
    }

    private boolean isInternalDependencyRef(String refType) {
        return refType.equals("java.transaction.UserTranscation") || refType.equals("javax.ejb.EJBContext") || refType.equals("javax.ejb.SessionContext") || refType.equals("javax.ejb.EntityContext") || refType.equals("javax.ejb.MessageDrivenContext");
    }

    public static InjectableReference addResourceReference(J2EEContextConfigDelegate config, String resourceName, String mappedName, String resourceType, Resource.AuthenticationType authType, boolean shareable, String description, InjectionTarget target) throws InstantiationException {
        InjectableReference ref;
        String envEntryType = ClassUtils.getNonPrimitiveName(resourceType);
        if (envEntryType.equals("java.lang.Boolean") || envEntryType.equals("java.lang.String") || envEntryType.equals("java.lang.Integer") || envEntryType.equals("java.lang.Double") || envEntryType.equals("java.lang.Byte") || envEntryType.equals("java.lang.Short") || envEntryType.equals("java.lang.Long") || envEntryType.equals("java.lang.Character") || envEntryType.equals("java.lang.Float")) {
            EnvironmentEntry envEntry = config.getEnvironmentEntry(resourceName);
            if (envEntry == null) {
                envEntry = new EnvironmentEntry(resourceName, null, envEntryType, null);
                config.addEnvironmentEntry(envEntry);
            } else {
                J2EEContextAnnotationParser.validateMatchingResourceType("@Resource", envEntry, envEntryType, target);
            }
            envEntry.setDescription(description);
            ref = envEntry;
        } else if (resourceType.equals("javax.sql.DataSource") || resourceType.equals("javax.jms.ConnectionFactory") || resourceType.equals("javax.jms.QueueConnectionFactory") || resourceType.equals("javax.jms.TopicConnectionFactory") || resourceType.equals("javax.resource.cci.ConnectionFactory") || resourceType.equals("javax.mail.Session") || resourceType.equals("java.net.URL")) {
            ResourceReference resRef = config.getResourceReference(resourceName);
            if (resRef == null) {
                resRef = new ResourceReference(resourceName, resourceType, authType == Resource.AuthenticationType.CONTAINER, shareable);
                config.addResourceReference(resRef);
            } else {
                J2EEContextAnnotationParser.validateMatchingResourceType("@Resource", resRef, resourceType, target);
            }
            resRef.setDescription(description);
            if (!J2EEContextAnnotationParser.valueIsEmpty(mappedName)) {
                resRef.setLocation(mappedName);
            }
            ref = resRef;
        } else if (resourceType.equals("javax.persistence.EntityManager")) {
            PersistenceContextReference resRef = config.getPersistenceContextReference(resourceName);
            if (resRef == null) {
                resRef = new PersistenceContextReference(resourceName);
                resRef.setUnitName("");
                resRef.setDescription(description);
                config.addPersistenceContextReference(resRef);
            } else {
                J2EEContextAnnotationParser.validateMatchingResourceType("@Resource", resRef, resourceType, target);
            }
            ref = resRef;
        } else if (resourceType.equals("javax.persistence.EntityManagerFactory")) {
            PersistenceUnitReference resRef = config.getPersistenceUnitReference(resourceName);
            if (resRef == null) {
                resRef = new PersistenceUnitReference(resourceName);
                resRef.setUnitName("");
                resRef.setDescription(description);
                config.addPersistenceUnitReference(resRef);
            } else {
                J2EEContextAnnotationParser.validateMatchingResourceType("@Resource", resRef, resourceType, target);
            }
            ref = resRef;
        } else if (resourceType.equals("javax.jms.Queue") || resourceType.equals("javax.jms.Topic")) {
            DestinationReference desRef = config.getDestinationReference(resourceName);
            if (desRef == null) {
                desRef = new DestinationReference(resourceName, resourceType, null, null);
                desRef.setDescription(description);
                if (!J2EEContextAnnotationParser.valueIsEmpty(mappedName)) {
                    desRef.setLocation(mappedName);
                }
                config.addDestinationReference(desRef);
            } else {
                J2EEContextAnnotationParser.validateMatchingResourceType("@Resource", desRef, resourceType, target);
            }
            ref = desRef;
        } else {
            ResourceEnvironmentReference resRef = config.getResourceEnvironmentReference(resourceName);
            if (resRef == null) {
                resRef = new ResourceEnvironmentReference(resourceName, resourceType);
                config.addResourceEnvironmentReference(resRef);
            } else {
                J2EEContextAnnotationParser.validateMatchingResourceType("@Resource", resRef, resourceType, target);
            }
            resRef.setDescription(description);
            if (!J2EEContextAnnotationParser.valueIsEmpty(mappedName)) {
                resRef.setLocation(mappedName);
            }
            ref = resRef;
        }
        return ref;
    }

    public static void validateMatchingResourceType(String annotation, InjectableReference ref, String resourceType, InjectionTarget target) throws InstantiationException {
        if (!ref.getReferenceClass().equals(resourceType)) {
            if (target == null) {
                throw new InstantiationException(annotation + " for class-level with name '" + ref.getName() + "' and type '" + resourceType + "' does not match the type '" + ref.getReferenceClass() + "' of an existing reference");
            }
            throw new InstantiationException(annotation + " for injection field or setter property of with name '" + target.getTargetName() + "' does not have the declared type that matches '" + ref.getReferenceClass() + "' of an existing reference");
        }
    }

    public static boolean valueIsEmpty(String value) {
        return value == null || value.equals("");
    }

    public static boolean valueIsEmpty(Class value) {
        return value == null || value == Object.class;
    }

    public AnnotationManager getAnnotationManager() {
        return this.annotationMgr;
    }

    public static String validateInjectionSetter(Method method) throws InstantiationException {
        String methodName = method.getName();
        if (!methodName.startsWith("set")) {
            throw new InstantiationException("Setter injection being applied to non-setter method: " + methodName);
        }
        if (method.getParameterTypes().length != 1) {
            throw new InstantiationException("Setter injection being applied to setter method: " + methodName + "with wrong number of arguments: " + method.getParameterTypes().length + ".  Should be 1.");
        }
        return String.valueOf(methodName.charAt(3)).toLowerCase() + methodName.substring(4);
    }

    public static InjectionTarget createInjectionTarget(Field field) {
        return new InjectionField(field.getDeclaringClass().getName(), field.getName(), field.getType().getName());
    }

    public static InjectionTarget createInjectionTarget(Method method) throws InstantiationException {
        String propertyName = J2EEContextAnnotationParser.validateInjectionSetter(method);
        return new InjectionMethod(method.getDeclaringClass().getName(), propertyName, method.getParameterTypes()[0].getName());
    }

    public void validateInjectionAndAnnotationTypes(String annotation, Class srcClass, String targetName, Class targetCls, Class annotatedRefType) throws InstantiationException {
        if (!targetCls.isAssignableFrom(annotatedRefType)) {
            throw new InstantiationException("Error in " + annotation + " for injection field name or setter property name '" + targetName + "' defined on '" + srcClass + "' - annotated type or interface '" + annotatedRefType + "' of an existing reference is not assignable to the declaring field/setter argument type " + targetCls);
        }
    }
}

