/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.deployment;

import com.evermind.server.deployment.InjectionTarget;
import com.evermind.util.ClassUtils;
import java.lang.reflect.Method;

public class InjectionMethod
extends InjectionTarget {
    private Method method;

    public InjectionMethod(String targetClass, String targetName, String resourceType) {
        super(targetClass, targetName, resourceType);
    }

    public InjectionMethod(Method method) throws InstantiationException {
        this(method.getDeclaringClass().getName(), InjectionMethod.getPropertyName(method), method.getParameterTypes()[0].getName());
        this.method = method;
        this.method.setAccessible(true);
    }

    private static String getPropertyName(Method method) {
        return String.valueOf(method.getName().charAt(0)).toLowerCase() + method.getName().substring(1);
    }

    public void initialize(Class baseClass) throws InstantiationException {
        Class resourceClass;
        if (this.method != null && this.method.getDeclaringClass() == baseClass) {
            return;
        }
        try {
            resourceClass = ClassUtils.findClass(this.getResourceType(), baseClass.getClassLoader());
        }
        catch (ClassNotFoundException e) {
            throw new InstantiationException("Error loading method parameter '" + this.getResourceType() + "' due to ClassNotFoundException");
        }
        String methodName = "set" + String.valueOf(this.getTargetName().charAt(0)).toUpperCase() + this.getTargetName().substring(1);
        try {
            this.method = baseClass.getClassLoader().loadClass(this.getTargetClass()).getDeclaredMethod(methodName, resourceClass);
            this.method.setAccessible(true);
        }
        catch (SecurityException e) {
            throw new InstantiationException("Error loading method '" + methodName + "' from class '" + this.getTargetClass() + "' due to SecurityException");
        }
        catch (NoSuchMethodException e) {
            throw new InstantiationException("Error loading method '" + methodName + "' from class '" + this.getTargetClass() + "' due to NoSuchMethodException");
        }
        catch (ClassNotFoundException e) {
            throw new InstantiationException("Error loading class '" + this.targetClass + "' due to ClassNotFoundException");
        }
    }

    public void inject(Object target, Object value) throws Exception {
        this.method.invoke(target, value);
    }
}

