/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.deployment;

import com.evermind.server.deployment.InjectionTarget;
import java.lang.reflect.Field;

public class InjectionField
extends InjectionTarget {
    private Field field;

    public InjectionField(String targetClass, String targetName, String resourceType) {
        super(targetClass, targetName, resourceType);
    }

    public InjectionField(Field field) {
        super(field.getDeclaringClass().getName(), field.getName(), field.getType().getName());
        this.field = field;
        this.field.setAccessible(true);
    }

    public void initialize(Class baseClass) throws InstantiationException {
        if (this.field != null && this.field.getDeclaringClass() == baseClass) {
            return;
        }
        try {
            this.field = baseClass.getClassLoader().loadClass(this.getTargetClass()).getDeclaredField(this.getTargetName());
            this.field.setAccessible(true);
        }
        catch (SecurityException e) {
            throw new InstantiationException("Error loading field '" + this.getTargetName() + "' from class '" + this.getTargetClass() + "' due to SecurityException");
        }
        catch (NoSuchFieldException e) {
            throw new InstantiationException("Error loading field '" + this.getTargetName() + "' from class '" + this.getTargetClass() + "' due to NoSuchFieldException");
        }
        catch (ClassNotFoundException e) {
            throw new InstantiationException("Error loading class '" + this.getTargetClass() + "' due to ClassNotFoundException");
        }
    }

    public void inject(Object target, Object value) throws Exception {
        this.field.set(target, value);
    }
}

