/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.deployment;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;

public class ClassUtils {
    static /* synthetic */ Class class$java$lang$Object;

    public static Field getField(Class targetClass, String fieldName, String fieldType) throws ClassNotFoundException {
        Class<?> type = targetClass.getClassLoader().loadClass(fieldType);
        for (Class tempClass = targetClass; tempClass != null && !tempClass.getName().equals((class$java$lang$Object == null ? ClassUtils.class$("java.lang.Object") : class$java$lang$Object).getName()); tempClass = tempClass.getSuperclass()) {
            Field[] list = tempClass.getDeclaredFields();
            for (int i = 0; i < list.length; ++i) {
                Field field = list[i];
                if (!field.getName().equals(fieldName) || !field.getType().isAssignableFrom(type) && !ClassUtils.checkPrimitiveAndWrapperType(field.getType(), type)) continue;
                return field;
            }
        }
        return null;
    }

    public static boolean checkPrimitiveAndWrapperType(Class primitiveCls, Class primitiveWrapperCls) {
        if (primitiveCls.isPrimitive()) {
            if (primitiveWrapperCls == Integer.class) {
                return primitiveCls == Integer.TYPE;
            }
            if (primitiveWrapperCls == Float.class) {
                return primitiveCls == Float.TYPE;
            }
            if (primitiveWrapperCls == Long.class) {
                return primitiveCls == Long.TYPE;
            }
            if (primitiveWrapperCls == Double.class) {
                return primitiveCls == Double.TYPE;
            }
            if (primitiveWrapperCls == Boolean.class) {
                return primitiveCls == Boolean.TYPE;
            }
            if (primitiveWrapperCls == Byte.class) {
                return primitiveCls == Byte.TYPE;
            }
            if (primitiveWrapperCls == Character.class) {
                return primitiveCls == Character.TYPE;
            }
            if (primitiveWrapperCls == Short.class) {
                return primitiveCls == Short.TYPE;
            }
        }
        return false;
    }

    public static Method getMethod(Class baseClass, String methodName, Class[] methodParams) {
        if (baseClass.isInterface()) {
            try {
                return baseClass.getMethod(methodName, methodParams);
            }
            catch (NoSuchMethodException e) {
            }
        } else {
            for (Class tempClass = baseClass; tempClass != null && !tempClass.getName().equals("java.lang.Object"); tempClass = tempClass.getSuperclass()) {
                try {
                    return tempClass.getDeclaredMethod(methodName, methodParams);
                }
                catch (NoSuchMethodException e) {
                    continue;
                }
            }
        }
        return null;
    }

    public static Method getInjectableMethod(Class baseClass, String methodName, Class paramClass) {
        int i;
        Class[] paramClasses = new Class[]{paramClass};
        Method method = ClassUtils.getMethod(baseClass, methodName, paramClasses);
        if (method != null) {
            return method;
        }
        Class tempClass = baseClass;
        ArrayList<Method> methodList = new ArrayList<Method>();
        while (!tempClass.getName().equals("java.lang.Object")) {
            Method[] methods = tempClass.getDeclaredMethods();
            for (i = 0; i < methods.length; ++i) {
                method = methods[i];
                if (!method.getName().equals(methodName) || method.getParameterTypes() == null || method.getParameterTypes().length != 1 || !method.getParameterTypes()[0].isAssignableFrom(paramClass) && !ClassUtils.checkPrimitiveAndWrapperType(method.getParameterTypes()[0], paramClass)) continue;
                methodList.add(method);
            }
            tempClass = tempClass.getSuperclass();
        }
        Method matchMethod = null;
        for (i = 0; i < methodList.size(); ++i) {
            method = (Method)methodList.get(i);
            Class<?>[] methodClasses = method.getParameterTypes();
            if (matchMethod != null && !matchMethod.getParameterTypes()[0].isAssignableFrom(methodClasses[0])) continue;
            matchMethod = method;
        }
        return matchMethod;
    }

    public static boolean isMethodOverridden(Class baseClass, Method method) {
        if (method.getDeclaringClass().equals(baseClass)) {
            return false;
        }
        return !method.equals(ClassUtils.getMethod(baseClass, method.getName(), method.getParameterTypes()));
    }
}

