/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.deployment;

import com.evermind.server.deployment.RoleNameContainer;
import com.evermind.util.AbstractDescribable;
import com.evermind.xml.XMLizable;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;

public abstract class AbstractSecurityConstraint
extends AbstractDescribable
implements XMLizable,
RoleNameContainer,
Serializable {
    public static final int TRANSPORT_NONE = 0;
    public static final int TRANSPORT_CONFIDENTIAL = 1;
    public static final int TRANSPORT_INTEGRAL = 2;
    protected int transportGuarantee;
    protected List roleNames;

    public int getTransportGuarantee() {
        return this.transportGuarantee;
    }

    public String getTransportGuaranteeString() {
        switch (this.transportGuarantee) {
            case 2: {
                return "INTEGRAL";
            }
            case 1: {
                return "CONFIDENTIAL";
            }
        }
        return "NONE";
    }

    public List getRoleNames() {
        if (this.roleNames == null) {
            return Collections.EMPTY_LIST;
        }
        return this.roleNames;
    }

    public void setRoleNames(List names) {
        this.roleNames = names;
    }

    public void addRoleName(String name) {
        this.roleNames.add(name);
        this.firePropertyChangeEvent("roleNames", null, name);
    }

    public void removeRoleName(int pos) {
        this.firePropertyChangeEvent("roleNames", this.roleNames.remove(pos), null);
    }

    public void removeRoleName(String name) {
        this.roleNames.remove(name);
        this.firePropertyChangeEvent("roleNames", name, null);
    }

    public void setTransportGuarantee(String value) throws InstantiationException {
        if (value.equals("NONE")) {
            this.transportGuarantee = 0;
        } else if (value.equals("INTEGRAL")) {
            this.transportGuarantee = 2;
        } else if (value.equals("CONFIDENTIAL")) {
            this.transportGuarantee = 1;
        } else {
            throw new InstantiationException("Unknown transport-guarantee value: " + value);
        }
    }

    public static String getTransportGuaranteeName(int type) {
        switch (type) {
            case 0: {
                return "NONE";
            }
            case 2: {
                return "INTEGRAL";
            }
            case 1: {
                return "CONFIDENTIAL";
            }
        }
        return "NONE";
    }

    public boolean hasRoles() {
        return this.roleNames != null && !this.roleNames.isEmpty();
    }
}

