/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.connector.deployment;

import com.evermind.xml.XMLUtils;
import com.evermind.xml.XMLizable;
import java.io.PrintWriter;
import java.security.PermissionCollection;
import oracle.j2ee.security.PolicyFile;
import org.w3c.dom.Node;

public class SecurityPermission
implements XMLizable {
    private String description;
    private String permissionText;
    private boolean orionMode;
    private boolean enabled;
    private PermissionCollection permissions;

    public SecurityPermission(Node node, boolean orionMode) throws InstantiationException {
        this.orionMode = orionMode;
        this.description = XMLUtils.getSubnodeValue(node, "description");
        this.permissionText = XMLUtils.getSubnodeValue(node, "security-permission-spec");
        this.enabled = false;
        if (orionMode) {
            this.enabled = "true".equalsIgnoreCase(XMLUtils.getNodeAttribute(node, "enabled"));
            if (this.enabled) {
                this.permissions = PolicyFile.parseGrantEntries(this.permissionText);
            }
        }
    }

    public SecurityPermission(Node node) throws InstantiationException {
        this(node, false);
    }

    public void enable() {
        this.enabled = true;
    }

    public void writeXML(PrintWriter out, String indention) {
        out.println(indention + "<security-permission>");
        out.println(indention + "\t<description>" + XMLUtils.encode(this.description) + "</description>");
        out.println(indention + "\t<security-permission-spec>" + XMLUtils.encode(this.permissionText) + "</security-permission-spec>");
        out.println(indention + "</security-permission>");
    }

    public void writeOrionXML(PrintWriter out, String indention) {
        out.println(indention + "<security-permission enabled=\"" + (this.enabled ? "true" : "false") + "\">");
        if (this.description != null) {
            out.println(indention + "\t<description>" + XMLUtils.encode(this.description) + "</description>");
        }
        if (this.permissionText != null) {
            out.println(indention + "\t<security-permission-spec>" + XMLUtils.encode(this.permissionText) + "</security-permission-spec>");
        }
        out.println(indention + "</security-permission>");
    }

    public PermissionCollection getPermissions() {
        if (!this.enabled) {
            return null;
        }
        return this.permissions;
    }
}

