/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.connector.deployment;

import com.evermind.server.connector.deployment.AdminObjectInstance;
import com.evermind.server.connector.deployment.ConfigurationProperty;
import com.evermind.util.AbstractDescribable;
import com.evermind.xml.XMLUtils;
import com.evermind.xml.XMLizable;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import oracle.oc4j.admin.management.callbackinterfaces.JCAAdminObjectCallBackIf;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class AdminObject
extends AbstractDescribable
implements XMLizable,
JCAAdminObjectCallBackIf {
    protected Map m_configurationProperties;
    protected String m_adminObjectInterface;
    protected String m_adminObjectClass;

    public AdminObject() {
    }

    public AdminObject(Node parent) throws InstantiationException {
        NodeList nodes = parent.getChildNodes();
        if (nodes != null) {
            for (int i = 0; i < nodes.getLength(); ++i) {
                Node node = nodes.item(i);
                String nodeName = node.getNodeName();
                if (nodeName.startsWith("#")) continue;
                String value = XMLUtils.getStringValue(node);
                if (nodeName.equals("adminobject-class")) {
                    this.m_adminObjectClass = value;
                    continue;
                }
                if (nodeName.equals("adminobject-interface")) {
                    this.m_adminObjectInterface = value;
                    continue;
                }
                if (nodeName.equals("config-property")) {
                    this.addConfigurationProperty(new ConfigurationProperty(node, 1));
                    continue;
                }
                throw new InstantiationException("Unknown adminobject subtag: " + nodeName);
            }
        }
        if (this.m_adminObjectClass == null) {
            throw new InstantiationException("Missing 'adminobject-class' subtag in 'adminobject' tag");
        }
        if (this.m_adminObjectInterface == null) {
            throw new InstantiationException("Missing 'adminobject-interface' subtag in 'adminobject' tag");
        }
    }

    public void addConfigurationProperty(ConfigurationProperty property) {
        if (this.m_configurationProperties == null) {
            this.m_configurationProperties = new HashMap();
        }
        this.m_configurationProperties.put(property.getName(), property);
    }

    public Collection getConfigurationProperties() {
        if (this.m_configurationProperties == null) {
            return Collections.EMPTY_LIST;
        }
        return this.m_configurationProperties.values();
    }

    public String getAdminObjectClass() {
        return this.m_adminObjectClass;
    }

    public String getAdminObjectInterface() {
        return this.m_adminObjectInterface;
    }

    public void writeXML(PrintWriter out, String indention) throws IOException {
        out.println(indention + "<adminobject>");
        out.println(indention + "\t<adminobject-interface>" + XMLUtils.encode(this.m_adminObjectInterface) + "</adminobject-interface>");
        out.println(indention + "\t<adminobject-class>" + XMLUtils.encode(this.m_adminObjectClass) + "</adminobject-class>");
        if (this.m_configurationProperties != null) {
            XMLUtils.writeAll(this.m_configurationProperties.values(), out, indention + "\t");
        }
        out.println(indention + "</adminobject>");
    }

    public void writeOrionXML(PrintWriter out, String indention) {
    }

    public AdminObjectInstance createInstance(Map configProperties) {
        HashMap<String, Object> configurationProperties = null;
        if (this.getConfigurationProperties() != null) {
            configurationProperties = new HashMap<String, Object>();
            Iterator iter = this.getConfigurationProperties().iterator();
            while (iter.hasNext()) {
                ConfigurationProperty config = (ConfigurationProperty)iter.next();
                configurationProperties.put(config.getName(), config.clone());
            }
        }
        AdminObjectInstance adminObj = new AdminObjectInstance(this.getAdminObjectInterface(), this.getAdminObjectClass(), configurationProperties);
        if (configProperties != null && adminObj.getConfigurationProperties() != null) {
            Iterator iter = adminObj.getConfigurationProperties().iterator();
            while (iter.hasNext()) {
                ConfigurationProperty config = (ConfigurationProperty)iter.next();
                Iterator it = configProperties.entrySet().iterator();
                while (it.hasNext()) {
                    Map.Entry t = it.next();
                    String name = t.getKey().toString();
                    if (!name.equalsIgnoreCase(config.getName())) continue;
                    String value = t.getValue().toString();
                    config.setRuntimeValue(value);
                }
            }
        }
        return adminObj;
    }

    public String toString() {
        return "[AdminObject: interface = " + this.m_adminObjectInterface + ", class = " + this.m_adminObjectClass + ", configurationProperties = " + this.m_configurationProperties + "]";
    }
}

