/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.connector.deployment;

import com.evermind.server.connector.deployment.ConfigurationProperty;
import com.evermind.util.AbstractDescribable;
import com.evermind.xml.XMLUtils;
import com.evermind.xml.XMLizable;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ActivationSpecConfig
extends AbstractDescribable
implements XMLizable {
    protected String m_className;
    protected List m_configProperties;
    protected List m_requiredConfigProperties;

    public ActivationSpecConfig(Node parent) throws InstantiationException {
        this(parent, false);
    }

    public ActivationSpecConfig(Node parent, boolean orionMode) throws InstantiationException {
        NodeList nodes = parent.getChildNodes();
        if (nodes != null) {
            for (int i = 0; i < nodes.getLength(); ++i) {
                Node node = nodes.item(i);
                String nodeName = node.getNodeName();
                if (nodeName.startsWith("#")) continue;
                String value = XMLUtils.getStringValue(node);
                if (nodeName.equals("activationspec-class")) {
                    this.m_className = value;
                    continue;
                }
                if (nodeName.equals("required-config-property") && !orionMode) {
                    this.addRequiredConfigProperty(new ConfigurationProperty(node, 0));
                    continue;
                }
                if (nodeName.equals("config-property") && orionMode) {
                    this.addConfigProperty(new ConfigurationProperty(node));
                    continue;
                }
                throw new InstantiationException("Unknown messagelistener subtag: " + nodeName);
            }
        }
        if (this.m_className == null) {
            throw new InstantiationException("Missing 'activationspec-class' subtag in activationspec tag");
        }
    }

    public String getClassName() {
        return this.m_className;
    }

    public void addConfigProperty(ConfigurationProperty property) {
        if (this.m_configProperties == null) {
            this.m_configProperties = new ArrayList();
        }
        this.m_configProperties.add(property);
    }

    public List getConfigProperties() {
        if (this.m_configProperties == null) {
            return Collections.EMPTY_LIST;
        }
        return this.m_configProperties;
    }

    public void addRequiredConfigProperty(ConfigurationProperty property) {
        if (this.m_requiredConfigProperties == null) {
            this.m_requiredConfigProperties = new ArrayList();
        }
        this.m_requiredConfigProperties.add(property);
    }

    public List getRequiredConfigProperties() {
        if (this.m_requiredConfigProperties == null) {
            return Collections.EMPTY_LIST;
        }
        return this.m_requiredConfigProperties;
    }

    public void writeXML(PrintWriter out, String indention) throws IOException {
        out.println(indention + "<activationspec>");
        out.println(indention + "\t<activationspec-class>" + XMLUtils.encode(this.m_className) + "</activationspec-class>");
        if (this.m_requiredConfigProperties != null) {
            XMLUtils.writeAll(this.m_requiredConfigProperties, out, indention + "\t");
        }
        out.println(indention + "</activationspec>");
    }

    public void writeOrionXML(PrintWriter out, String indention) throws IOException {
        out.println(indention + "<activationspec-config>");
        out.println(indention + "\t<activationspec-class>" + XMLUtils.encode(this.m_className) + "</activationspec-class>");
        if (this.m_configProperties != null) {
            XMLUtils.writeAll(this.m_configProperties, out, indention + "\t");
        }
        out.println(indention + "</activationspec-config>");
    }
}

