/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.administration;

import com.evermind.security.Group;
import com.evermind.security.PermissionDescriptor;
import com.evermind.security.User;
import com.evermind.security.UserAlreadyExistsException;
import com.evermind.security.UserManager;
import com.evermind.server.administration.BasicGroupInfo;
import com.evermind.server.administration.BasicUserInfo;
import com.evermind.server.administration.ExtensiveUserInfo;
import com.evermind.server.administration.UserAdministrator;
import com.evermind.util.ObjectUtils;
import java.beans.IntrospectionException;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.security.Permission;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class DefaultUserAdministrator
implements UserAdministrator {
    private UserManager manager;

    public DefaultUserAdministrator(UserManager manager) {
        this.manager = manager;
    }

    public int getUserCount() {
        return this.manager.getUserCount();
    }

    public List getUsers(int startPos, int max) {
        List users = this.manager.getUsers(startPos, max);
        ArrayList<BasicUserInfo> response = new ArrayList<BasicUserInfo>();
        for (int i = 0; i < users.size(); ++i) {
            User user = (User)users.get(i);
            try {
                response.add(new BasicUserInfo(user.getName(), ObjectUtils.getStringProperty(user, "realName", true, true), user.getDescription()));
                continue;
            }
            catch (IntrospectionException e) {
                continue;
            }
            catch (IllegalAccessException e) {
                continue;
            }
            catch (InvocationTargetException e) {
                // empty catch block
            }
        }
        return response;
    }

    public int getGroupCount() {
        return this.manager.getGroupCount();
    }

    public List getGroups(int startPos, int max, boolean recursive) {
        ArrayList<BasicGroupInfo> response = new ArrayList<BasicGroupInfo>();
        UserManager manager = this.manager;
        do {
            int currentMax = max;
            if (max > manager.getGroupCount()) {
                currentMax = manager.getGroupCount();
            }
            List groups = manager.getGroups(startPos, currentMax);
            max -= groups.size();
            for (int i = 0; i < groups.size(); ++i) {
                Group group = (Group)groups.get(i);
                response.add(new BasicGroupInfo(group.getName(), group.getDescription(), DefaultUserAdministrator.convertPermissionsToStringArrays(group.getPermissions())));
            }
            manager = manager.getParent();
        } while (recursive && manager != null);
        return response;
    }

    public void addUser(ExtensiveUserInfo info) throws InstantiationException, UserAlreadyExistsException, IOException {
        User user = this.manager.createUser(info.getUsername(), info.getPassword());
        user.setDescription(info.getDescription());
        if (info.getRealname() != null) {
            try {
                ObjectUtils.setProperty(user, "realName", info.getRealname(), true, true);
            }
            catch (IntrospectionException e) {
            }
            catch (IllegalAccessException e) {
            }
            catch (InvocationTargetException invocationTargetException) {
                // empty catch block
            }
        }
        this.manager.store();
    }

    public void removeUsers(Collection usernames) throws IOException {
        Iterator iterator = usernames.iterator();
        while (iterator.hasNext()) {
            String username = iterator.next().toString();
            User user = this.manager.getUser(username);
            if (user == null) continue;
            this.manager.remove(user);
        }
        this.manager.store();
    }

    public void addGroup(BasicGroupInfo info) throws InstantiationException, IOException, InstantiationException {
        Group group = this.manager.createGroup(info.getName());
        group.setDescription(info.getDescription());
        for (int i = 0; i < info.getPermissionDescriptors().length; ++i) {
            String[] permission = info.getPermissionDescriptors()[i];
            group.addPermission(new PermissionDescriptor(permission[0], permission[1], permission[2]).getPermission(group.getClass().getClassLoader()));
        }
        this.manager.store();
    }

    public void removeGroups(Collection names) throws IOException {
        Iterator iterator = names.iterator();
        while (iterator.hasNext()) {
            String groupname = iterator.next().toString();
            Group group = this.manager.getGroup(groupname);
            if (group == null) continue;
            this.manager.remove(group);
        }
        this.manager.store();
    }

    public ExtensiveUserInfo getUser(String name) {
        HashSet groupNames;
        User user = this.manager.getUser(name);
        if (user == null) {
            return null;
        }
        try {
            groupNames = DefaultUserAdministrator.getNamesFromGroups(user.getGroups());
        }
        catch (UnsupportedOperationException e) {
            groupNames = new HashSet();
        }
        String realName = null;
        try {
            realName = ObjectUtils.getStringProperty(user, "realName", true, true);
        }
        catch (IntrospectionException e) {
        }
        catch (IllegalAccessException e) {
        }
        catch (InvocationTargetException e) {
            // empty catch block
        }
        return new ExtensiveUserInfo(user.getName(), realName, user.getDescription(), user.getPassword(), groupNames);
    }

    public BasicGroupInfo getGroup(String name) {
        String[][] permissions;
        Group group = this.manager.getGroup(name);
        if (group == null) {
            return null;
        }
        try {
            permissions = DefaultUserAdministrator.convertPermissionsToStringArrays(group.getPermissions());
        }
        catch (UnsupportedOperationException e) {
            permissions = new String[0][3];
        }
        return new BasicGroupInfo(group.getName(), group.getDescription(), permissions);
    }

    public void updateUser(ExtensiveUserInfo userInfo) throws IOException {
        User user = this.manager.getUser(userInfo.getUsername());
        if (user != null) {
            if (!ObjectUtils.equals(user.getDescription(), userInfo.getDescription())) {
                user.setDescription(userInfo.getDescription());
            }
            try {
                ObjectUtils.setProperty(user, "realName", userInfo.getRealname(), true, true);
            }
            catch (IntrospectionException e) {
            }
            catch (IllegalAccessException e) {
            }
            catch (InvocationTargetException e) {
                // empty catch block
            }
            try {
                Set toRemove = DefaultUserAdministrator.getNamesFromGroups(user.getGroups());
                toRemove.removeAll(userInfo.getGroupNames());
                Iterator iterator = toRemove.iterator();
                while (iterator.hasNext()) {
                    user.removeFromGroup(this.manager.getGroup((String)iterator.next()));
                }
                HashSet toAdd = new HashSet(userInfo.getGroupNames());
                toAdd.removeAll(DefaultUserAdministrator.getNamesFromGroups(user.getGroups()));
                iterator = toAdd.iterator();
                while (iterator.hasNext()) {
                    user.addToGroup(this.manager.getGroup((String)iterator.next()));
                }
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
        }
        this.manager.store();
    }

    public void updateGroup(BasicGroupInfo groupInfo) throws InstantiationException, IOException {
        Group group = this.manager.getGroup(groupInfo.getName());
        if (group != null && !ObjectUtils.equals(group.getDescription(), groupInfo.getDescription())) {
            group.setDescription(groupInfo.getDescription());
        }
        HashSet toDelete = new HashSet(group.getPermissions());
        HashSet toAdd = new HashSet(Arrays.asList(groupInfo.getPermissionDescriptors()));
        Iterator iterator = toDelete.iterator();
        while (iterator.hasNext()) {
            boolean found = false;
            Permission permission = (Permission)iterator.next();
            for (int i = 0; i < groupInfo.getPermissionDescriptors().length; ++i) {
                if (!groupInfo.getPermissionDescriptors()[i][0].equals(permission.getClass().getName()) || !ObjectUtils.equals(groupInfo.getPermissionDescriptors()[i][1], permission.getName()) || !ObjectUtils.equals(groupInfo.getPermissionDescriptors()[i][2], permission.getActions())) continue;
                iterator.remove();
                toAdd.remove(groupInfo.getPermissionDescriptors()[i]);
                found = true;
                break;
            }
            if (found) continue;
            group.removePermission(permission);
        }
        iterator = toAdd.iterator();
        while (iterator.hasNext()) {
            String[] descriptor = (String[])iterator.next();
            group.addPermission(new PermissionDescriptor(descriptor[0], descriptor[1], descriptor[2]).getPermission(group.getClass().getClassLoader()));
        }
        this.manager.store();
    }

    public static Set getNamesFromGroups(Set groups) {
        HashSet groupNames = new HashSet();
        if (groups != null) {
            Iterator iterator = groups.iterator();
            while (iterator.hasNext()) {
                Object item = iterator.next();
                if (item instanceof String) {
                    groupNames.add(item);
                    continue;
                }
                groupNames.add(((Group)item).getName());
            }
        }
        return groupNames;
    }

    public static String[][] convertPermissionsToStringArrays(Set permissions) {
        String[][] response = new String[permissions.size()][3];
        Iterator iterator = permissions.iterator();
        int i = 0;
        while (iterator.hasNext()) {
            Permission permission = (Permission)iterator.next();
            response[i][0] = permission.getClass().getName();
            response[i][1] = permission.getName();
            response[i][2] = permission.getActions();
            ++i;
        }
        return response;
    }
}

