/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.administration;

import com.evermind.naming.archive.ContentArchiveContext;
import com.evermind.security.User;
import com.evermind.server.Application;
import com.evermind.server.ApplicationServer;
import com.evermind.server.ApplicationServerShutdownHandler;
import com.evermind.server.ApplicationServerThread;
import com.evermind.server.ThreadState;
import com.evermind.server.administration.ApplicationAdministrator;
import com.evermind.server.administration.ApplicationServerAdministrator;
import com.evermind.server.administration.DefaultApplicationAdministrator;
import com.evermind.server.administration.DefaultServerAdministrator;
import com.evermind.server.http.administration.DefaultHttpServerAdministrator;
import com.evermind.server.http.administration.HttpServerAdministrator;
import com.evermind.server.jms.JMSServer;
import com.evermind.server.jms.administration.DefaultJMSServerAdministrator;
import com.evermind.server.jms.administration.JMSServerAdministrator;
import com.evermind.server.rmi.RMIServer;
import com.evermind.server.rmi.administration.DefaultRMIServerAdministrator;
import com.evermind.server.rmi.administration.RMIServerAdministrator;
import java.io.File;
import java.io.InputStream;
import java.net.InetAddress;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import oracle.oc4j.admin.internal.DeployerFactory;
import oracle.oc4j.admin.internal.DeployerIF;
import oracle.oc4j.admin.internal.InternalUploader;
import oracle.oc4j.admin.internal.UnDeployerFactory;
import oracle.oc4j.admin.internal.UnDeployerIF;
import oracle.oc4j.admin.internal.UploaderStateKeeper;
import oracle.oc4j.admin.internal.WebApplicationBinder;
import oracle.oc4j.admin.jmx.server.Oc4jMBeanServerFactory;
import oracle.oc4j.admin.jmx.shared.util.DataSink;
import oracle.oc4j.admin.jmx.shared.util.ObjectNameFactory;
import oracle.oc4j.admin.management.shared.SharedModuleType;

public class DefaultApplicationServerAdministrator
extends DefaultServerAdministrator
implements ApplicationServerAdministrator {
    protected ApplicationServer server;
    private static int iASDeploymentTransactionRefCount_ = 0;
    public static Object iASDeploymentTransactionMutex_ = new Object();
    private WebApplicationBinder webApplicationBinder;
    private static final int SUCCESS = 0;

    public DefaultApplicationServerAdministrator(ApplicationServer server) {
        super(server);
        this.server = server;
        try {
            this.webApplicationBinder = new WebApplicationBinder();
        }
        catch (Exception e) {
            System.out.println("WebApplicationBinder is null!");
        }
        ApplicationServer.setApplicationServerAdministrator(this);
    }

    public String getVersion() {
        return ApplicationServer.VERSION;
    }

    public void shutdown(String reason, boolean force) throws RemoteException {
        if (!this.server.isReady()) {
            throw new RemoteException("Server initialization not complete");
        }
        User user = null;
        InetAddress address = null;
        try {
            ThreadState state = ThreadState.getCurrentState();
            user = state.getUser();
            address = state.getInetAddress();
        }
        catch (Exception e) {
            // empty catch block
        }
        reason = "Shutdown executed by " + (user == null ? "<unknown administrator>" : user.getName()) + (address == null ? "" : " from " + address.getHostAddress() + " (" + address.getHostName() + ")") + (reason == null ? "" : ", " + reason);
        System.out.println("Shutting down...");
        ApplicationServerShutdownHandler shutdownHandler = new ApplicationServerShutdownHandler(this.server, false, force, reason);
        ApplicationServerThread t = new ApplicationServerThread(null, (Runnable)shutdownHandler, "shutdownThread", 0L);
        t.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void restart(String reason) {
        Object object = iASDeploymentTransactionMutex_;
        synchronized (object) {
            User user = ThreadState.getCurrentState().getUser();
            InetAddress address = ThreadState.getCurrentState().getInetAddress();
            reason = "Shutdown executed by " + (user == null ? "<unknown administrator>" : user.getName()) + (address == null ? "" : " from " + address.getHostAddress() + " (" + address.getHostName() + ")") + (reason == null ? "" : ", " + reason);
            System.out.println("Restarting... ");
            ApplicationServerShutdownHandler restartHandler = new ApplicationServerShutdownHandler(this.server, true, false, reason);
            ApplicationServerThread thread = new ApplicationServerThread(null, (Runnable)restartHandler, "restartThread", 0L);
            thread.start();
        }
    }

    public void restartApplication(String appName) throws RemoteException, InstantiationException {
        Application application;
        Application application2 = application = "default".equals(appName) ? this.server.getDefaultApplication() : this.server.getApplication(appName);
        if (application == null) {
            throw new RemoteException("DefaultApplicationServerAdministrator.restartApplication(" + appName + "), application does not exist!");
        }
        application.restartRecursive();
    }

    public void stopApplication(String appName) throws RemoteException {
        try {
            MBeanServer oc4jMBeanServer = Oc4jMBeanServerFactory.getMBeanServer();
            ObjectName appMBeanObjectName = ObjectNameFactory.create((String)("oc4j:j2eeType=J2EEApplication,name=" + appName + ",J2EEServer=" + "standalone"));
            oc4jMBeanServer.invoke(appMBeanObjectName, "stop", new Object[0], new String[0]);
        }
        catch (Throwable t) {
            throw new RemoteException("Failed to stop application " + appName, t);
        }
    }

    public int stopApplication(String appName, int timeout, boolean graceful) throws RemoteException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("timeout", String.valueOf(timeout));
        params.put("graceful", String.valueOf(graceful));
        try {
            Application app = ApplicationServer.getInstance().getApplication(appName);
            app.stop(params);
        }
        catch (InstantiationException e) {
            RemoteException re = new RemoteException("Exception while restarting app: " + appName);
            re.initCause(e);
            throw re;
        }
        return 0;
    }

    public void startApplication(String appName) throws RemoteException {
        try {
            MBeanServer oc4jMBeanServer = Oc4jMBeanServerFactory.getMBeanServer();
            ObjectName appMBeanObjectName = ObjectNameFactory.create((String)("oc4j:j2eeType=J2EEApplication,name=" + appName + ",J2EEServer=" + "standalone"));
            oc4jMBeanServer.invoke(appMBeanObjectName, "startRecursive", new Object[0], new String[0]);
        }
        catch (Throwable t) {
            throw new RemoteException("Failed to start application " + appName, t);
        }
    }

    public HttpServerAdministrator getHttpServerAdministrator() throws RemoteException {
        if (this.server.getHttpServer() != null) {
            return new DefaultHttpServerAdministrator(this.server.getHttpServer());
        }
        return null;
    }

    public ApplicationAdministrator getDefaultApplication() {
        return new DefaultApplicationAdministrator(this.server.getDefaultApplication());
    }

    public String getDefaultApplicationName() {
        return this.server.getDefaultApplication().getName();
    }

    public ApplicationAdministrator getApplication(String name) throws RemoteException, InstantiationException {
        Application application = this.server.getApplication(name);
        if (application != null) {
            return new DefaultApplicationAdministrator(this.server.getApplication(name));
        }
        return null;
    }

    public List getApplicationNames() {
        ArrayList names = new ArrayList(this.server.getApplicationNames());
        Collections.sort(names);
        return names;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map getStatistics() {
        long time = System.currentTimeMillis();
        ApplicationServer applicationServer = this.server;
        synchronized (applicationServer) {
            HashMap<String, Object> statistics = new HashMap<String, Object>();
            Properties properties = new Properties();
            properties.putAll((Map<?, ?>)System.getProperties());
            statistics.put("systemProperties", properties);
            statistics.put("startTime", new Long(this.server.getStartTime()));
            statistics.put("uptime", new Long(time - this.server.getStartTime()));
            statistics.put("logEvents", this.server.getLogEvents());
            int[] memoryUsage = new int[this.server.memoryUsage.length];
            int firstCut = this.server.memoryUsage.length - this.server.memoryUsagePos;
            System.arraycopy(this.server.memoryUsage, this.server.memoryUsagePos, memoryUsage, 0, firstCut);
            System.arraycopy(this.server.memoryUsage, 0, memoryUsage, firstCut, memoryUsage.length - firstCut);
            int lastZero = 0;
            for (int i = 0; i < memoryUsage.length - 2 && memoryUsage[i] == 0; ++i) {
                lastZero = i + 1;
            }
            if (lastZero > 0) {
                int[] newUsage = new int[memoryUsage.length - lastZero];
                System.arraycopy(memoryUsage, lastZero, newUsage, 0, newUsage.length);
                memoryUsage = newUsage;
            }
            statistics.put("memoryUsage", memoryUsage);
            return statistics;
        }
    }

    public JMSServerAdministrator getJMSServerAdministrator() {
        JMSServer jmsServer = this.server.getJMSServer();
        if (jmsServer != null) {
            return new DefaultJMSServerAdministrator(jmsServer);
        }
        return null;
    }

    public RMIServerAdministrator getRMIServerAdministrator() {
        RMIServer server = this.server.getRMIServer();
        if (server == null) {
            return null;
        }
        return new DefaultRMIServerAdministrator(server);
    }

    public void checkForUpdates() {
        this.server.forceCheckForUpdates();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int beginIASDeploymentTransaction() {
        Object object = iASDeploymentTransactionMutex_;
        synchronized (object) {
            return ++iASDeploymentTransactionRefCount_;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int endIASDeploymentTransaction() {
        Object object = iASDeploymentTransactionMutex_;
        synchronized (object) {
            if (--iASDeploymentTransactionRefCount_ == 0) {
                iASDeploymentTransactionMutex_.notifyAll();
            }
            return iASDeploymentTransactionRefCount_;
        }
    }

    public static boolean isIASDeploymentTransaction() {
        return iASDeploymentTransactionRefCount_ > 0;
    }

    public Integer beginUpload(String fileName) throws RemoteException {
        try {
            return InternalUploader.beginUpload(fileName);
        }
        catch (Exception e) {
            throw new RemoteException("beginUpload() failed!", e);
        }
    }

    public void endUpload(Integer id) throws RemoteException {
        try {
            InternalUploader.endUpload(id);
        }
        catch (Exception e) {
            throw new RemoteException("endUpload() failed!", e);
        }
    }

    public void upload(Integer id, byte[] data) throws RemoteException {
        try {
            InternalUploader.upload(id, data);
        }
        catch (Exception e) {
            throw new RemoteException("upload() failed!", e);
        }
    }

    public Map deploy(Integer id, String applicationName, Map extraParameters) throws RemoteException {
        File uploadFile = (File)UploaderStateKeeper.getState(id);
        DataSink sink = new DataSink(uploadFile.getAbsolutePath());
        sink.setUploadId(id);
        return this.internalDeploy(sink, applicationName, extraParameters, SharedModuleType.EAR);
    }

    public Map deploy(byte[] data, String applicationName, Map extraParameters) throws RemoteException {
        DataSink sink = new DataSink(data);
        return this.internalDeploy(sink, applicationName, extraParameters, SharedModuleType.EAR);
    }

    public Map deploy(String earFilePath, String applicationName) throws RemoteException {
        return this.deploy(earFilePath, applicationName, null);
    }

    public Map deploy(String earFilePath, String applicationName, Map extraParameters) throws RemoteException {
        if (extraParameters != null && extraParameters.containsKey("isRar") && "true".equals(extraParameters.get("isRar"))) {
            byte[] data;
            try {
                data = this.extractRarFile(earFilePath, (String)extraParameters.get("rarPath"));
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new RemoteException("Unable to extract rar file");
            }
            DataSink sink = new DataSink(data);
            return this.internalDeploy(sink, applicationName, extraParameters, SharedModuleType.RAR);
        }
        DataSink sink = new DataSink(earFilePath);
        return this.internalDeploy(sink, applicationName, extraParameters, SharedModuleType.EAR);
    }

    public Map deploy(InputStream appStream, String applicationName, String parentApp, String bindto) throws Exception {
        HashMap<String, String> extraParams = new HashMap<String, String>();
        if (!"default".equals(parentApp)) {
            extraParams.put("parent", parentApp);
        }
        if (bindto != null) {
            extraParams.put("bindWebApp", bindto);
        }
        DataSink sink = new DataSink(appStream);
        return this.internalDeploy(sink, applicationName, extraParams, SharedModuleType.EAR);
    }

    public Map deployConnector(Integer id, String deployName, Map extraParams) throws RemoteException {
        File uploadFile = (File)UploaderStateKeeper.getState(id);
        DataSink sink = new DataSink(uploadFile.getAbsolutePath());
        sink.setUploadId(id);
        return this.internalDeploy(sink, deployName, extraParams, SharedModuleType.RAR);
    }

    public Map deployConnector(String rarFilePath, String deployName, Map extraParams) throws RemoteException {
        DataSink sink = new DataSink(rarFilePath);
        return this.internalDeploy(sink, deployName, extraParams, SharedModuleType.RAR);
    }

    public Map deployConnector(byte[] data, String deployName, Map extraParams) throws RemoteException {
        DataSink sink = new DataSink(data);
        return this.internalDeploy(sink, deployName, extraParams, SharedModuleType.RAR);
    }

    public Map undeploy(String appName, boolean removeFiles) throws RemoteException {
        return this.internalUndeploy(appName, removeFiles, SharedModuleType.EAR);
    }

    public Map undeployConnector(String deployName, boolean removeFiles) throws RemoteException {
        return this.internalUndeploy(deployName, removeFiles, SharedModuleType.RAR);
    }

    public void bindWebApp(String appName, String siteName) throws RemoteException {
        try {
            this.webApplicationBinder.bindWebApp(appName, siteName);
        }
        catch (Exception e) {
            throw new RemoteException("bindWebApp() failed!", e);
        }
    }

    public void bindWebApp(String appName, String webName, String siteName, String root) throws RemoteException {
        this.bindWebApp(appName, webName, siteName, root, null);
    }

    public void bindWebApp(String appName, String webName, String siteName, String root, HashMap optionalParams) throws RemoteException {
        try {
            this.webApplicationBinder.bindWebApp(appName, webName, siteName, root);
        }
        catch (Exception e) {
            throw new RemoteException("bindWebApp() failed!", e);
        }
    }

    public void updateEJBModule(byte[] data, String jarName, String appName) throws RemoteException {
        try {
            Application app = this.server.getApplication(appName);
            if (app == null) {
                throw new IllegalArgumentException("Application not found by name: " + appName);
            }
            app.updateEJBModule(jarName, data);
        }
        catch (Exception e) {
            throw new RemoteException("update failed!: ", e);
        }
    }

    private Map internalDeploy(DataSink sink, String deployName, Map extraParams, SharedModuleType type) throws RemoteException {
        try {
            DeployerIF deployer = DeployerFactory.getInstance(sink, deployName, type, extraParams);
            return deployer.execute(true);
        }
        catch (Exception e) {
            throw new RemoteException("deploy failed!: ", e);
        }
    }

    private Map internalUndeploy(String deployName, boolean removeFiles, SharedModuleType type) throws RemoteException {
        try {
            UnDeployerIF undeployer = UnDeployerFactory.getInstance(deployName, type);
            return undeployer.execute();
        }
        catch (Exception e) {
            throw new RemoteException("undeploy failed!: ", e);
        }
    }

    private byte[] extractRarFile(String earFilePath, String rarPath) throws Exception {
        File file = new File(earFilePath);
        ContentArchiveContext context = new ContentArchiveContext(file, true);
        return (byte[])context.lookup(rarPath);
    }
}

