/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server;

import com.evermind.xml.XMLConfig;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URL;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;
import oracle.oc4j.sql.config.ConnectionFactoryConfig;
import oracle.oc4j.sql.config.ConnectionPoolConfig;
import oracle.oc4j.sql.config.DataSourceConfigException;
import oracle.oc4j.sql.config.DataSourcesConfig;
import oracle.oc4j.sql.config.ManagedDataSourceConfig;
import oracle.oc4j.sql.config.NativeDataSourceConfig;
import oracle.oc4j.sql.config.PropertyConfig;
import oracle.oc4j.sql.config.XARecoveryConfig;
import oracle.oc4j.sql.config.legacy.LegacyDataSourcesConfig;
import oracle.oc4j.sql.config.legacy.LegacyOneDataSourceConfig;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class XMLDataSourcesConfig
extends XMLConfig {
    private static Logger m_logger = Logger.getLogger(XMLDataSourcesConfig.class.getName());
    public static final String LEGACY_DATA_SOURCE_NODE_NAME = "data-source";
    private static final String LEGACY_CLASS_NAME_ORION_CMT_DATASOURCE = "com.evermind.sql.OrionCMTDataSource";
    private static final String LEGACY_CLASS_NAME_ORION_POOLED_DATASOURCE = "com.evermind.sql.OrionPooledDataSource";
    private static final String LEGACY_CLASS_NAME_DRIVER_MANAGER_DATASOURCE = "com.evermind.sql.DriverManagerDataSource";
    private static final String LEGACY_CLASS_NAME_DRIVER_MANAGER_XA_DATASOURCE = "com.evermind.sql.DriverManagerXADataSource";
    private DataSourcesConfig m_dataSourcesConfig;

    public XMLDataSourcesConfig(DataSourcesConfig dataSourcesConfig) throws IllegalArgumentException {
        this.setDataSourcesConfig(dataSourcesConfig);
    }

    public XMLDataSourcesConfig(URL url) throws IOException, SAXException, InstantiationException {
        super(url);
    }

    public XMLDataSourcesConfig(LegacyDataSourcesConfig legacyConfig) throws InstantiationException {
        try {
            this.createConfigFromLegacy(legacyConfig);
        }
        catch (DataSourceConfigException e) {
            m_logger.warning("Exception creating data sources configuration from legacy configuration.  Exception is: " + e);
            throw new InstantiationException(e.toString());
        }
    }

    public void parseDeploymentMainNode(Node node) throws InstantiationException {
    }

    public DataSourcesConfig getDataSourcesConfig() {
        return this.m_dataSourcesConfig;
    }

    public void setDataSourcesConfig(DataSourcesConfig dataSourcesConfig) throws IllegalArgumentException {
        if (dataSourcesConfig == null) {
            throw new IllegalArgumentException("Error setting data sources config.  The data sources configuration object cannot be null.");
        }
        this.m_dataSourcesConfig = dataSourcesConfig;
    }

    protected void verifyDocumentType(String name) throws InstantiationException {
        if (!name.equals("data-sources")) {
            throw new InstantiationException(this.getName() + " contained a " + name + " file, not a data-sources file as expected");
        }
    }

    protected void writeConfig(PrintWriter out) throws IOException {
        this.writeXML(out);
    }

    public void writeXML(PrintWriter out) throws IOException {
        try {
            out.println(this.m_dataSourcesConfig.createXMLString());
        }
        catch (DataSourceConfigException dataSourceConfigException) {
            throw new IOException(dataSourceConfigException.getMessage());
        }
    }

    protected void parseRootNode(Node node, boolean deployment) throws InstantiationException {
        super.parseRootNode(node, deployment);
        try {
            if (this.isLegacy(node)) {
                m_logger.info("Legacy datasource detected...attempting to convert to new syntax.");
                this.createConfigFromLegacy(new LegacyDataSourcesConfig(node));
            } else {
                this.m_dataSourcesConfig = new DataSourcesConfig(node);
            }
        }
        catch (DataSourceConfigException dsce) {
            throw new InstantiationException("DataSourceConfigException: " + dsce.getMessage());
        }
    }

    private void createConfigFromLegacy(LegacyDataSourcesConfig legacyConfig) throws DataSourceConfigException {
        Hashtable connectionPools = new Hashtable();
        Hashtable nativeDataSourceConfigs = new Hashtable();
        Hashtable managedDataSourceConfigs = new Hashtable();
        LegacyOneDataSourceConfig[] legacyDataSources = legacyConfig.getDataSourceConfigs();
        for (int i = 0; i < legacyDataSources.length; ++i) {
            try {
                LegacyOneDataSourceConfig config = legacyDataSources[i];
                PropertyConfig[] propertyConfigs = this.getLegacyProperties(config);
                String className = config.getClassName();
                if (className.equals(LEGACY_CLASS_NAME_ORION_CMT_DATASOURCE)) {
                    this.createOrionCMTDataSources(config, propertyConfigs, connectionPools, managedDataSourceConfigs, nativeDataSourceConfigs, legacyDataSources);
                    continue;
                }
                if (className.equals(LEGACY_CLASS_NAME_ORION_POOLED_DATASOURCE)) {
                    this.createOrionPooledDataSources(config, connectionPools, managedDataSourceConfigs, nativeDataSourceConfigs);
                    continue;
                }
                if (className.equals(LEGACY_CLASS_NAME_DRIVER_MANAGER_DATASOURCE)) {
                    this.createDriverManagerDataSources(config, propertyConfigs, connectionPools, managedDataSourceConfigs, nativeDataSourceConfigs, legacyDataSources);
                    continue;
                }
                if (className.equals(LEGACY_CLASS_NAME_DRIVER_MANAGER_XA_DATASOURCE)) continue;
                this.create3rdPartyDataSources(config, propertyConfigs, connectionPools, managedDataSourceConfigs, nativeDataSourceConfigs, legacyDataSources);
                continue;
            }
            catch (DataSourceConfigException dse) {
                m_logger.warning("Exception processing legacy data source.  Exception: " + dse.getMessage());
                throw dse;
            }
        }
        try {
            this.m_dataSourcesConfig = new DataSourcesConfig(null, null, null);
            Hashtable compressedConnectionPools = this.compressConnectionPools(connectionPools);
            ConnectionPoolConfig[] connectionPoolArray = new ConnectionPoolConfig[compressedConnectionPools.size()];
            int i = 0;
            Iterator iter = compressedConnectionPools.values().iterator();
            while (iter.hasNext()) {
                connectionPoolArray[i++] = (ConnectionPoolConfig)iter.next();
            }
            this.m_dataSourcesConfig.setConnectionPools(connectionPoolArray);
            i = 0;
            ManagedDataSourceConfig[] managedDataSourcesArray = new ManagedDataSourceConfig[managedDataSourceConfigs.size()];
            iter = managedDataSourceConfigs.values().iterator();
            while (iter.hasNext()) {
                managedDataSourcesArray[i++] = (ManagedDataSourceConfig)iter.next();
            }
            this.m_dataSourcesConfig.setManagedDataSources(managedDataSourcesArray);
            NativeDataSourceConfig[] nativeDataSourcelArray = new NativeDataSourceConfig[nativeDataSourceConfigs.size()];
            nativeDataSourceConfigs.values().toArray(nativeDataSourcelArray);
            this.m_dataSourcesConfig.setNativeDataSources(nativeDataSourcelArray);
        }
        catch (DataSourceConfigException e) {
            m_logger.warning("DataSourceConfigException: " + e.getMessage());
        }
    }

    private Hashtable compressConnectionPools(Hashtable connectionPools) {
        Hashtable<String, ConnectionPoolConfig> returnPools = new Hashtable<String, ConnectionPoolConfig>();
        Iterator iter = connectionPools.values().iterator();
        while (iter.hasNext()) {
            ConnectionPoolConfig cpConfig = (ConnectionPoolConfig)iter.next();
            if (returnPools.get(cpConfig.getName()) != null) continue;
            returnPools.put(cpConfig.getName(), cpConfig);
        }
        return returnPools;
    }

    private PropertyConfig[] getLegacyProperties(LegacyOneDataSourceConfig legacyConfig) {
        List props = legacyConfig.getProperties();
        if (props == null || props.size() == 0) {
            return new PropertyConfig[0];
        }
        PropertyConfig[] propertyConfigs = new PropertyConfig[props.size()];
        props.toArray(propertyConfigs);
        return propertyConfigs;
    }

    private void createOrionCMTDataSources(LegacyOneDataSourceConfig config, PropertyConfig[] propertyConfigs, Hashtable connectionPools, Hashtable managedDataSourceConfigs, Hashtable nativeDataSourceConfigs, LegacyOneDataSourceConfig[] legacyDataSources) throws DataSourceConfigException {
        ConnectionPoolConfig connectionPoolConfig;
        String xaSourceLocation = config.getXASourceLocation();
        String key = this.getConnectionPoolKey(config);
        if (key == null) {
            throw new DataSourceConfigException("No location found for legacy data source.  Could not convert the datasource.");
        }
        if (xaSourceLocation == null) {
            connectionPoolConfig = this.createConnectionPoolConfig("oracle.jdbc.xa.client.OracleXADataSource", config, propertyConfigs, legacyDataSources);
            connectionPools.put(key, connectionPoolConfig);
            this.addOtherConnectionPools(config, connectionPoolConfig, connectionPools);
        } else {
            connectionPoolConfig = (ConnectionPoolConfig)connectionPools.get(key);
            if (connectionPoolConfig == null && (connectionPoolConfig = (ConnectionPoolConfig)connectionPools.get(xaSourceLocation)) == null) {
                String msg = "The XA source location does not identify an existing source.  Could not create data source.";
                throw new DataSourceConfigException(msg);
            }
        }
        ManagedDataSourceConfig mdsc = new ManagedDataSourceConfig(config.getUsername(), config.getPassword(), connectionPoolConfig.getName(), config.getLocation(), config.getDisplayName() + "_" + config.getLocation(), "global", config.getLoginTimeout(), config.getDatabaseSchemaPath(), true);
        this.addManagedDataSource(managedDataSourceConfigs, nativeDataSourceConfigs, mdsc, config.getLocation());
    }

    private void createOrionPooledDataSources(LegacyOneDataSourceConfig config, Hashtable connectionPools, Hashtable managedDataSourceConfigs, Hashtable nativeDataSourceConfigs) throws DataSourceConfigException {
        String msg = null;
        String sourceLocation = config.getSourceLocation();
        if (sourceLocation == null) {
            msg = "The sourceLocation was not specified for: " + config.getName();
            throw new DataSourceConfigException(msg);
        }
        ConnectionPoolConfig cpConfig = (ConnectionPoolConfig)connectionPools.get(sourceLocation);
        if (cpConfig == null) {
            msg = "Could not find a connection pool for location: " + sourceLocation + " for data source named: " + config.getName();
            throw new DataSourceConfigException(msg);
        }
        ManagedDataSourceConfig mdsc = new ManagedDataSourceConfig(config.getUsername(), config.getPassword(), cpConfig.getName(), config.getLocation(), config.getDisplayName() + "_" + config.getLocation(), "global", config.getLoginTimeout(), config.getDatabaseSchemaPath(), true);
        this.addManagedDataSource(managedDataSourceConfigs, nativeDataSourceConfigs, mdsc, config.getLocation());
    }

    private void createDriverManagerDataSources(LegacyOneDataSourceConfig legacyConfig, PropertyConfig[] propertyConfigs, Hashtable connectionPools, Hashtable managedDataSourceConfigs, Hashtable nativeDataSourceConfigs, LegacyOneDataSourceConfig[] legacyDataSources) throws DataSourceConfigException {
        if (legacyConfig.getURL() == null) {
            throw new DataSourceConfigException("No JDBC URL specified for " + legacyConfig.getName());
        }
        ConnectionPoolConfig cpConfig = this.createConnectionPoolConfig(legacyConfig.getConnectionDriver(), legacyConfig, propertyConfigs, legacyDataSources);
        connectionPools.put(this.getConnectionPoolKey(legacyConfig), cpConfig);
        this.addOtherConnectionPools(legacyConfig, cpConfig, connectionPools);
        ManagedDataSourceConfig mdsc = new ManagedDataSourceConfig(legacyConfig.getUsername(), legacyConfig.getPassword(), cpConfig.getName(), legacyConfig.getLocation(), legacyConfig.getDisplayName() + "_" + legacyConfig.getLocation(), "global", legacyConfig.getLoginTimeout(), legacyConfig.getDatabaseSchemaPath(), true);
        this.addManagedDataSource(managedDataSourceConfigs, nativeDataSourceConfigs, mdsc, legacyConfig.getLocation());
    }

    private void create3rdPartyDataSources(LegacyOneDataSourceConfig legacyConfig, PropertyConfig[] propertyConfigs, Hashtable connectionPools, Hashtable managedDataSourceConfigs, Hashtable nativeDataSourceConfigs, LegacyOneDataSourceConfig[] legacyDataSources) throws DataSourceConfigException {
        String className = legacyConfig.getClassName();
        try {
            NativeDataSourceConfig nativeDataSourceConfig = new NativeDataSourceConfig(legacyConfig.getUsername(), legacyConfig.getPassword(), legacyConfig.getClassName(), legacyConfig.getLocation(), legacyConfig.getDisplayName(), legacyConfig.getURL(), legacyConfig.getLoginTimeout(), propertyConfigs);
            this.addNativeDataSourceConfig(managedDataSourceConfigs, nativeDataSourceConfigs, nativeDataSourceConfig);
            ConnectionPoolConfig connectionPoolConfig = this.createConnectionPoolConfig(className, legacyConfig, propertyConfigs, legacyDataSources);
            connectionPools.put(legacyConfig.getLocation(), connectionPoolConfig);
            this.addOtherConnectionPools(legacyConfig, connectionPoolConfig, connectionPools);
        }
        catch (Exception exception) {
            String msg = "Unable to instantiate " + className + ".  Exception is: " + exception.getMessage();
            throw new DataSourceConfigException(msg, exception);
        }
    }

    private void addManagedDataSource(Hashtable managedDataSourceConfigs, Hashtable nativeDataSourceConfigs, ManagedDataSourceConfig mdsc, String location) {
        boolean multiples = false;
        ManagedDataSourceConfig obj = managedDataSourceConfigs.put(location, mdsc);
        if (obj != null) {
            multiples = true;
        } else {
            obj = nativeDataSourceConfigs.remove(location);
            if (obj != null) {
                multiples = true;
            }
        }
        if (multiples) {
            m_logger.warning("Multiple data sources are defined to be registered in JNDI at location: " + location + ".  Only the last one encountered will be registered.  Please correct data-sources.xml.");
        }
    }

    private void addNativeDataSourceConfig(Hashtable managedDataSourceConfigs, Hashtable nativeDataSourceConfigs, NativeDataSourceConfig ndsc) {
        boolean multiples = false;
        String location = ndsc.getJndiName();
        NativeDataSourceConfig obj = nativeDataSourceConfigs.put(location, ndsc);
        if (obj != null) {
            multiples = true;
        } else {
            obj = managedDataSourceConfigs.remove(location);
            if (obj != null) {
                multiples = true;
            }
        }
        if (multiples) {
            m_logger.warning("Multiple data sources are defined to be registered in JNDI at location: " + location + ".  Only the last one encountered will be registered.  Please correct data-sources.xml.");
        }
    }

    private String getConnectionPoolKey(LegacyOneDataSourceConfig config) {
        return config.getLocation();
    }

    private String getConnectionPoolName(LegacyOneDataSourceConfig config) {
        return config.getDisplayName() + "_connectionPool";
    }

    private XARecoveryConfig getRecoveryConfig(String recoveryLocation, LegacyOneDataSourceConfig[] legacyDataSources) throws DataSourceConfigException {
        if (recoveryLocation != null) {
            for (int i = 0; i < legacyDataSources.length; ++i) {
                if (!recoveryLocation.equals(legacyDataSources[i].getLocation())) continue;
                XARecoveryConfig recoveryConfig = new XARecoveryConfig(legacyDataSources[i].getUsername(), legacyDataSources[i].getPassword());
                return recoveryConfig;
            }
        }
        return null;
    }

    private ConnectionPoolConfig createConnectionPoolConfig(String className, LegacyOneDataSourceConfig config, PropertyConfig[] propertyConfigs, LegacyOneDataSourceConfig[] legacyDataSources) throws DataSourceConfigException {
        String connectionPoolName = this.getConnectionPoolName(config);
        ConnectionFactoryConfig connectionFactoryConfig = new ConnectionFactoryConfig(className, config.getUsername(), config.getPassword(), config.getURL(), config.getLoginTimeout(), propertyConfigs, null, this.getRecoveryConfig(config.getRecoveryLocation(), legacyDataSources), null, null);
        ConnectionPoolConfig connectionPoolConfig = new ConnectionPoolConfig(connectionFactoryConfig, connectionPoolName);
        int retryInterval = (int)(config.getConnectionRetryInterval() / 1000L);
        connectionPoolConfig.setConnectionRetryInterval(retryInterval);
        connectionPoolConfig.setInactivityTimeout(config.getInactivityTimeout());
        connectionPoolConfig.setMaxConnections(config.getMaxConnections());
        connectionPoolConfig.setMinConnections(config.getMinConnections());
        connectionPoolConfig.setMaxConnectAttempts(config.getMaxConnectionAttempts());
        connectionPoolConfig.setNumCachedStatements(config.getStmtCacheSize());
        connectionPoolConfig.setUsedConnectionWaitTimeout((int)config.getWaitTimeout());
        return connectionPoolConfig;
    }

    private boolean isLegacy(Node rootNode) {
        NodeList nodes = rootNode.getChildNodes();
        if (nodes != null) {
            for (int i = 0; i < nodes.getLength(); ++i) {
                Node node = nodes.item(i);
                String name = node.getNodeName();
                if (!name.equals("native-data-source") && !name.equals("managed-data-source") && !name.equals("connection-pool")) continue;
                return false;
            }
        }
        return true;
    }

    private void addOtherConnectionPools(LegacyOneDataSourceConfig config, ConnectionPoolConfig connectionPoolConfig, Hashtable connectionPools) {
        String pooledLocation;
        String ejbLocation = config.getEJBLocation();
        if (ejbLocation != null) {
            connectionPools.put(ejbLocation, connectionPoolConfig);
        }
        if ((pooledLocation = config.getPooledLocation()) != null) {
            connectionPools.put(pooledLocation, connectionPoolConfig);
        }
    }
}

