/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server;

import com.evermind.server.SubordinateXAResource;
import java.rmi.RemoteException;
import javax.transaction.Synchronization;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import oracle.as.j2ee.transaction.tpc.RMFactoryJndiLocation;
import oracle.as.j2ee.transaction.tpc.RMId;

public class SubordinateXAResourceAdapter
implements XAResource,
Synchronization,
RMId {
    private final SubordinateXAResource m_remoteResource;
    private String m_rmArgs;

    public SubordinateXAResourceAdapter(SubordinateXAResource resource, String rmArgs) {
        this.m_remoteResource = resource;
        this.m_rmArgs = rmArgs;
    }

    public int prepare(Xid xid) throws XAException {
        try {
            return this.m_remoteResource.prepare(xid);
        }
        catch (RemoteException re) {
            throw this.getRMFAIL(re);
        }
    }

    public void commit(Xid xid, boolean onePhase) throws XAException {
        try {
            this.m_remoteResource.commit(xid, onePhase);
        }
        catch (RemoteException re) {
            throw this.getRMFAIL(re);
        }
    }

    public void rollback(Xid xid) throws XAException {
        try {
            this.m_remoteResource.rollback(xid);
        }
        catch (RemoteException re) {
            throw this.getRMFAIL(re);
        }
    }

    public void forget(Xid xid) throws XAException {
        try {
            this.m_remoteResource.forget(xid);
        }
        catch (RemoteException re) {
            throw this.getRMFAIL(re);
        }
    }

    public Xid[] recover(int flag) throws XAException {
        try {
            return this.m_remoteResource.recover(flag);
        }
        catch (RemoteException re) {
            throw this.getRMFAIL(re);
        }
    }

    public void beforeCompletion() {
        try {
            this.m_remoteResource.beforeCompletion();
        }
        catch (RemoteException re) {
            throw new RemoteBeforeCompletionException(re);
        }
    }

    public boolean isSameRM(XAResource xaResource) {
        return false;
    }

    public RMFactoryJndiLocation getRMFactoryJndiLocation() {
        return new RMFactoryJndiLocation(){

            public String getJndiLocation() {
                return "oc4j:internal/serverXAResource";
            }
        };
    }

    public String getRMFactoryArg() {
        return this.m_rmArgs;
    }

    public boolean setTransactionTimeout(int timeout) {
        return false;
    }

    public int getTransactionTimeout() throws XAException {
        try {
            return this.m_remoteResource.getTransactionTimeout();
        }
        catch (RemoteException re) {
            throw this.getRMFAIL(re);
        }
    }

    public void start(Xid xid, int i) throws XAException {
    }

    public void afterCompletion(int i) {
    }

    public void end(Xid xid, int flag) throws XAException {
        if (flag == 0x4000000 || flag == 0x20000000) {
            try {
                this.m_remoteResource.end(xid, flag);
            }
            catch (RemoteException re) {
                throw this.getRMFAIL(re);
            }
        }
    }

    private XAException getRMFAIL(Exception e) {
        XAException xae = new XAException(-7);
        xae.initCause(e);
        return xae;
    }

    private class RemoteBeforeCompletionException
    extends RuntimeException {
        public RemoteBeforeCompletionException(RemoteException re) {
            super("Unable to perform beforeCompletion notification on subordinate node.", re);
        }
    }
}

