/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server;

import com.evermind.server.SubjectPropagationConfiguration;
import java.security.AccessController;
import java.security.PrivilegedAction;
import javax.security.auth.Subject;
import oracle.oc4j.common.CommonThreadState;
import oracle.oc4j.security.OC4JSecurity;

public class SubjectPropagationHandler {
    static SubjectPropagationHandler s_singleton;
    private SubjectPropagationConfiguration m_configuration;

    protected SubjectPropagationHandler() {
    }

    protected SubjectPropagationHandler(SubjectPropagationConfiguration configuration) {
        this.m_configuration = configuration;
    }

    public static SubjectPropagationHandler getInstance() {
        if (null != s_singleton) {
            return s_singleton;
        }
        s_singleton = new SubjectPropagationHandler();
        return s_singleton;
    }

    public SubjectPropagationConfiguration getConfiguration() {
        if (null != this.m_configuration) {
            return this.m_configuration;
        }
        return SubjectPropagationConfiguration.getConfiguration();
    }

    public Subject getCurrentSubject() {
        CommonThreadState cts = CommonThreadState.getCurrent();
        Subject subject = cts.getRawPropagatedSubject();
        if (null == subject) {
            subject = OC4JSecurity.isSecurityOn() ? (Subject)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return Subject.getSubject(AccessController.getContext());
                }
            }) : Subject.getSubject(AccessController.getContext());
        }
        return CommonThreadState.NO_SUBJECT == subject ? null : subject;
    }

    public void setCurrentSubject(Subject subject) {
        CommonThreadState.getCurrent().setPropagatedSubject(subject, false);
    }
}

