/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server;

import com.evermind.server.ServerConfigBase;
import com.evermind.util.AttributeContainer;
import com.evermind.util.CollectionLogger;
import com.evermind.util.LogEvent;
import com.evermind.util.Logger;
import com.evermind.util.MemoryLogger;
import java.util.HashMap;
import java.util.Map;

public class ServerBase
implements AttributeContainer {
    private ServerConfigBase config;
    protected Logger logger;
    protected static final long startTime = System.currentTimeMillis();
    protected Map attributes;
    private MemoryLogger memoryLogger = new MemoryLogger();
    protected static String version = "10.1.3.5.0";

    public LogEvent[] getLogEvents() {
        return this.memoryLogger.getEvents();
    }

    public long getStartTime() {
        return startTime;
    }

    protected void setConfig(ServerConfigBase config) {
        this.config = config;
        this.logger = config.getLogger();
        if (this.logger instanceof CollectionLogger) {
            ((CollectionLogger)this.logger).addLogger(this.memoryLogger);
        }
        this.writeStarted();
    }

    private void writeStarted() {
        String version = this.getVersion();
        this.log((version == null ? "" : version + " ") + "Started");
    }

    private String getVersion() {
        return version;
    }

    private void writeStopped(String reason) {
        String version = this.getVersion();
        this.log((version == null ? "" : version + " ") + "Stopped" + (reason == null ? "" : " (" + reason + ")"));
    }

    public void log(LogEvent event) {
        if (this.logger != null) {
            this.logger.log(event);
        }
    }

    public void log(String message) {
        if (this.logger != null) {
            this.logger.log(new LogEvent(message));
        }
    }

    public void log(String message, Throwable t) {
        if (this.logger != null) {
            this.logger.log(new LogEvent(message, t));
        }
    }

    public String getName() {
        if (this.config != null) {
            return this.config.getName();
        }
        return this.toString();
    }

    public void destroy(String reason) {
        this.writeStopped(reason);
    }

    public ServerConfigBase getServerConfig() {
        return this.config;
    }

    public void logAndPrint(String text) {
        this.log(text);
        System.out.println(text);
    }

    public void logAndPrint(String text, Throwable t) {
        this.log(text, t);
        System.out.println(text);
        t.printStackTrace();
    }

    public Map getAttributes() {
        if (this.attributes == null) {
            this.attributes = new HashMap();
        }
        return this.attributes;
    }
}

