/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server;

import com.evermind.server.Application;
import com.evermind.server.ApplicationServer;
import com.evermind.server.ApplicationServerSystemProperties;
import com.evermind.server.OC4JServiceInfo;
import com.evermind.server.ServerMessages;
import com.evermind.server.http.XMLHttpSiteConfig;
import com.evermind.util.ServerProperties;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dms.instrument.NounIntf;
import oracle.dms.instrument.StateIntf;
import oracle.dms.instrument.TransTraceIntf;
import oracle.j2ee.util.CustomerLogger;
import oracle.j2ee.util.TraceLogger;
import oracle.oc4j.admin.config.ApplicationServerConfig;
import oracle.oc4j.security.ApplicationServerProxyImpl;
import oracle.security.jazn.ApplicationServerProxy;
import oracle.security.jazn.JAZNConfig;

public class OC4JServer
extends ApplicationServer {
    public static final String INSTANCE_VM_ID = "vmId";
    public static final String INSTANCE_MULTICAST_HOST = "mcasthost";
    public static final String INSTANCE_MULTICAST_PORT = "mcastport";
    static String instanceId = null;
    private static NounIntf opmnNoun = null;
    private static StateIntf iasClusterState = null;
    private static StateIntf iasInstanceState = null;
    private static StateIntf opmnSequenceState = null;
    private static StateIntf opmnGroupState = null;
    private static StateIntf oc4jInstanceState = null;
    private static StateIntf oc4jIslandState = null;
    private static boolean OPMNEnabled = false;
    private static long _nodeId;
    static Vector overrideHttpPorts;
    private static Logger m_traceLogger;
    private static ArrayList servicesList;

    OC4JServer(boolean secure, int verbosity, ApplicationServerConfig config) throws InstantiationException {
        super(secure, verbosity, config);
    }

    public static ApplicationServer launchOC4JCommandline(String[] args) throws InstantiationException {
        String indexId;
        Vector<String> argv = new Vector<String>();
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-ports")) {
                if (++i == args.length) {
                    ServerMessages.warningMissingPortsValue();
                    continue;
                }
                OC4JServer.parsePorts(args[i]);
                continue;
            }
            if (args[i].equals("-".concat(INSTANCE_MULTICAST_HOST))) {
                System.setProperty(INSTANCE_MULTICAST_HOST, args[++i]);
                continue;
            }
            if (args[i].equals("-".concat(INSTANCE_MULTICAST_PORT))) {
                System.setProperty(INSTANCE_MULTICAST_PORT, args[++i]);
                continue;
            }
            argv.addElement(args[i]);
        }
        Object[] orionArgs = new String[argv.size()];
        if (orionArgs.length > 0) {
            argv.copyInto(orionArgs);
        }
        if (OPMNEnabled && (indexId = ServerProperties.getOracleOnsIndexID()) != null) {
            instanceId = indexId.replace('.', '_');
        }
        return OC4JServer.launchCommandline((String[])orionArgs);
    }

    static void parsePorts(String s) {
        if (ServerProperties.getOPMNServicesDebug()) {
            System.out.println("parsePorts: " + s);
        }
        StringTokenizer st = new StringTokenizer(s, ",");
        String id = null;
        String protocol = null;
        String port = null;
        while (st.hasMoreTokens()) {
            protocol = null;
            port = null;
            id = null;
            String token = st.nextToken();
            StringTokenizer serviceTokenizer = new StringTokenizer(token, ":");
            if (serviceTokenizer.hasMoreTokens()) {
                String firstToken = serviceTokenizer.nextToken();
                String secondToken = serviceTokenizer.nextToken();
                if (serviceTokenizer.hasMoreTokens()) {
                    id = firstToken;
                    protocol = secondToken;
                    port = serviceTokenizer.nextToken();
                } else {
                    protocol = firstToken;
                    port = secondToken;
                }
                if (!(port != null && port.length() == 0 || id != null && id.length() != 0 || protocol == null || protocol.length() != 0)) {
                    throw new RuntimeException("OPMN configured service protocol: " + protocol + " running on port: " + port + "is misconfigured in opmn.xml");
                }
                int intPort = Integer.valueOf(port);
                if (OC4JServiceInfo.isWebSiteProtocol(protocol)) {
                    OC4JServer.addService(id, protocol, intPort);
                    continue;
                }
                if (protocol.equals("rmi") || protocol.equals("rmis") || protocol.equals("jms")) {
                    OC4JServer.addService(id, protocol, intPort);
                    System.setProperty("port." + protocol, port);
                    continue;
                }
                System.setProperty("port." + protocol, port);
                String hostname = null;
                try {
                    hostname = InetAddress.getLocalHost().getHostName();
                }
                catch (UnknownHostException e) {
                    // empty catch block
                }
                OC4JServer.addService(protocol, protocol, hostname, intPort, protocol);
                continue;
            }
            ServerMessages.warningInvalidPortsValue(token);
        }
    }

    protected static OC4JServiceInfo addService(String id, String protocol, int port) {
        return OC4JServer.addService(id, protocol, null, port, null);
    }

    protected static void updateService(String id, String protocol, int port, String hostname) {
        OC4JServiceInfo service = OC4JServer.findService(id, protocol, port);
        if (service == null) {
            System.out.println("WARNING: OC4J Service: " + id + " with protocol: " + protocol + " and port: " + port + " was not declared in opmn.xml");
            return;
        }
        service.setHostname(hostname);
        if (ServerProperties.getOPMNServicesDebug()) {
            System.out.println("Updated service: " + service);
        }
    }

    public static OC4JServiceInfo findService(String id, String protocol, int port) {
        Iterator it = servicesList.iterator();
        while (it.hasNext()) {
            OC4JServiceInfo service = (OC4JServiceInfo)it.next();
            if (!(service.getId() == null ? service.getProtocol().equals(protocol) && service.getPort() == port : service.getId().equals(id))) continue;
            return service;
        }
        return null;
    }

    public static OC4JServiceInfo addService(String id, String protocol, String hostname, int port, String description) {
        if (servicesList == null) {
            servicesList = new ArrayList();
        }
        boolean serviceExists = false;
        OC4JServiceInfo serviceInfo = OC4JServer.findService(id, protocol, port);
        if (serviceInfo != null) {
            System.out.println("Already added service: " + serviceInfo + ". Check opmn.xml for duplicate entries");
            return serviceInfo;
        }
        serviceInfo = new OC4JServiceInfo(id, protocol, hostname, port, description);
        servicesList.add(serviceInfo);
        if (ServerProperties.getOPMNServicesDebug()) {
            System.out.println("adding service:" + serviceInfo.toString());
        }
        return serviceInfo;
    }

    protected static ArrayList getServicesList() {
        return servicesList;
    }

    public static void main(String[] args) throws InstantiationException {
        ApplicationServerSystemProperties.setRunningAsServer(true);
        JAZNConfig.setSecurityProperties();
        OPMNEnabled = ServerProperties.getRunningInIAS();
        OC4JServer.initNodeId();
        CustomerLogger.loadAllLoggers();
        try {
            OC4JServer.initConsole();
        }
        catch (Exception e) {
            ServerMessages.warningDMSInitializeFail(e);
        }
        try {
            ApplicationServerProxy.setProxy((ApplicationServerProxy)new ApplicationServerProxyImpl());
        }
        catch (Throwable t) {
            m_traceLogger.log(Level.FINE, "Error in setProxy()", t);
        }
        if (null == OC4JServer.launchOC4JCommandline(args)) {
            System.exit(-1);
        }
        if (DMS_GATE) {
            try {
                TransTraceIntf tt = dmsConsole.getTransTrace();
                String portAJP = null;
                List siteConfigs = OC4JServer.instance.httpServer.getConfig().getSiteConfigs();
                for (int i = 0; i < siteConfigs.size(); ++i) {
                    XMLHttpSiteConfig siteConfig = (XMLHttpSiteConfig)siteConfigs.get(i);
                    if (siteConfig.getProtocol() != 2) continue;
                    portAJP = String.valueOf(siteConfig.getPort());
                }
                tt.init(OC4JServer.getInstanceId(), portAJP);
            }
            catch (Exception e) {
                m_traceLogger.log(Level.FINE, "DMS TRANSTRACE: init failed: " + e.getMessage(), e);
                m_traceLogger.log(Level.FINE, "DMS TRANSTRACE: feature disabled");
            }
            if (OPMNEnabled) {
                String value = ServerProperties.getOracleOnsClusterName();
                if (value != null) {
                    iasClusterState = ApplicationServer.stateFactory().create(OC4JServer.getOpmnNoun(), "ias_cluster", "", "iAS cluster name", (Object)value);
                }
                if ((value = ServerProperties.getOracleOnsInstanceName()) != null) {
                    iasInstanceState = ApplicationServer.stateFactory().create(OC4JServer.getOpmnNoun(), "ias_instance", "", "iAS instance name", (Object)value);
                }
                if ((value = ServerProperties.getOracleOnsUID()) != null) {
                    opmnSequenceState = ApplicationServer.stateFactory().create(OC4JServer.getOpmnNoun(), "opmn_sequence", "", "OPMN Sequence id", (Object)value);
                }
                if ((value = ServerProperties.getOracleOc4jInstanceName()) != null) {
                    opmnGroupState = ApplicationServer.stateFactory().create(OC4JServer.getOpmnNoun(), "opmn_group", "", "OPMN group id", (Object)value);
                }
                if ((value = ServerProperties.getOracleOc4jInstanceName()) != null) {
                    oc4jInstanceState = ApplicationServer.stateFactory().create(OC4JServer.getOpmnNoun(), "oc4j_instance", "", "OC4J instance id", (Object)value);
                }
                if ((value = ServerProperties.getOracleOc4JIslandName()) != null) {
                    oc4jIslandState = ApplicationServer.stateFactory().create(OC4JServer.getOpmnNoun(), "oc4j_island", "", "OC4J island id", (Object)value);
                }
            }
        }
    }

    public static String getInstanceId() {
        return instanceId;
    }

    public static void embeddedMode(String[] args) throws MalformedURLException, InstantiationException {
        embeddedMode = true;
        OC4JServer.main(args);
    }

    public static boolean getOPMNEnabled() {
        return OPMNEnabled;
    }

    public static NounIntf getOpmnNoun() {
        if (opmnNoun == null) {
            opmnNoun = ApplicationServer.nounFactory().create(Application.getJ2eeNoun(), "opmnInfo", "oc4j_opmn");
        }
        return opmnNoun;
    }

    private static void initNodeId() {
        String vmidx = ServerProperties.getOracleOnsIndexID();
        String vmind = ServerProperties.getOracleOnsInstanceName();
        String idString = null;
        if (vmidx != null && vmind != null) {
            idString = vmidx + vmind;
            Integer i1 = new Integer(idString.hashCode());
            idString = i1.toString();
            _nodeId = idString.hashCode();
            if (ServerProperties.getClusterDebug()) {
                m_traceLogger.log(Level.FINEST, "+ oracle.ons.indexid=" + vmidx);
                m_traceLogger.log(Level.FINEST, "+ oracle.ons.instancename=" + vmind);
                m_traceLogger.log(Level.FINEST, "+ id=" + _nodeId);
            }
        } else {
            _nodeId = (long)(Math.random() * 32767.0) << 32;
            try {
                byte[] localAddress = InetAddress.getLocalHost().getAddress();
                _nodeId += (long)(localAddress[0] + (localAddress[1] << 8) + (localAddress[2] << 16) + (localAddress[3] << 24));
            }
            catch (UnknownHostException unknownHostException) {
                // empty catch block
            }
        }
    }

    public static long getNodeId() {
        return _nodeId;
    }

    protected static long setNodeId(long val) {
        _nodeId = val;
        return _nodeId;
    }

    static {
        overrideHttpPorts = null;
        m_traceLogger = TraceLogger.getLogger(OC4JServer.class);
        servicesList = null;
    }
}

