/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server;

import com.evermind.naming.FilterContext;
import com.evermind.naming.SubContext;
import com.evermind.server.deployment.ApplicationClientArchive;
import javax.naming.Binding;
import javax.naming.CompositeName;
import javax.naming.Context;
import javax.naming.InvalidNameException;
import javax.naming.Name;
import javax.naming.NameNotFoundException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;

public class ApplicationClientContext
extends FilterContext {
    private static final String PARENT_NAME = "java:comp";
    private static final String SUBCONTEXT_NAME = "env";
    protected Context subContext;
    protected Name boundName;
    protected String boundNameString;
    private ApplicationClientArchive m_clientArchive;
    private Binding BINDING = new Binding("env", "javax.naming.Context", this, true);

    public ApplicationClientContext(Context root, Context subContext, ApplicationClientArchive archive) throws InvalidNameException {
        super(root);
        this.subContext = subContext;
        this.boundNameString = "java:comp/env";
        this.boundName = new CompositeName(this.boundNameString);
        this.m_clientArchive = archive;
    }

    public Object lookup(Name name) throws NamingException {
        if (this.isSubcontextParent(name)) {
            return new SubContext(this, name.toString());
        }
        if (!this.isSubContextRequest(name)) {
            return super.lookup(name);
        }
        if (name.size() == this.boundName.size()) {
            return this.subContext;
        }
        return this.subContext.lookup(name.getSuffix(this.boundName.size()));
    }

    private boolean isSubContextRequest(Name name) {
        return name.size() >= this.boundName.size() && name.getPrefix(this.boundName.size()).equals(this.boundName);
    }

    public Object lookup(String name) throws NamingException {
        if (this.isSubcontextParent(name)) {
            return new SubContext(this, name);
        }
        if (!this.isSubContextRequest(name)) {
            return super.lookup(name);
        }
        if (name.length() == this.boundNameString.length()) {
            return this.subContext;
        }
        if (name.charAt(this.boundNameString.length()) == '/') {
            return this.subContext.lookup(name.substring(this.boundNameString.length() + 1));
        }
        throw new NameNotFoundException(name + " not found");
    }

    public void unbind(String name) throws NamingException {
        if (this.isSubContextRequest(name)) {
            this.subContext.unbind(name);
        } else {
            super.unbind(name);
        }
    }

    private boolean isSubContextRequest(String name) {
        return name.startsWith(this.boundNameString);
    }

    public void close() throws NamingException {
        this.getContext().close();
        this.subContext.close();
    }

    public NamingEnumeration list(Name name) throws NamingException {
        return this.isSubcontextParent(name) ? new AugmentedNamingEnumeration(this.BINDING, super.list(name)) : (!this.isSubContextRequest(name) ? super.list(name) : this.subContext.list(name.getSuffix(this.boundName.size())));
    }

    public NamingEnumeration list(String name) throws NamingException {
        return this.isSubcontextParent(name) ? new AugmentedNamingEnumeration(this.BINDING, super.list(name)) : (!this.isSubContextRequest(name) ? super.list(name) : this.subContext.list(this.nameInSubcontext(name)));
    }

    private String nameInSubcontext(String name) {
        return name.length() == this.boundNameString.length() ? "" : name.substring(this.boundNameString.length() + 1);
    }

    public NamingEnumeration listBindings(Name name) throws NamingException {
        return this.isSubcontextParent(name) ? new AugmentedNamingEnumeration(this.BINDING, super.listBindings(name)) : (!this.isSubContextRequest(name) ? super.listBindings(name) : this.subContext.listBindings(name.getSuffix(this.boundName.size())));
    }

    public NamingEnumeration listBindings(String name) throws NamingException {
        return this.isSubcontextParent(name) ? new AugmentedNamingEnumeration(this.BINDING, super.listBindings(name)) : (!this.isSubContextRequest(name) ? super.listBindings(name) : this.subContext.listBindings(this.nameInSubcontext(name)));
    }

    public ApplicationClientArchive getClientArchive() {
        return this.m_clientArchive;
    }

    private boolean isSubcontextParent(Name name) {
        return name.size() == 1 && name.get(0).equals(PARENT_NAME);
    }

    private boolean isSubcontextParent(String name) {
        return name.equals(PARENT_NAME);
    }

    static class AugmentedNamingEnumeration
    implements NamingEnumeration {
        private Object m_initialObject;
        private NamingEnumeration m_baseEnumeration;
        private boolean m_initialObjectReturned;

        public AugmentedNamingEnumeration(Object initialObject, NamingEnumeration baseEnumeration) {
            this.m_initialObject = initialObject;
            this.m_baseEnumeration = baseEnumeration;
        }

        public Object next() throws NamingException {
            Object result = this.m_initialObjectReturned ? this.m_baseEnumeration.next() : this.m_initialObject;
            this.m_initialObjectReturned = true;
            return result;
        }

        public boolean hasMore() throws NamingException {
            return !this.m_initialObjectReturned || this.m_baseEnumeration.hasMore();
        }

        public void close() throws NamingException {
            this.m_baseEnumeration.close();
        }

        public boolean hasMoreElements() {
            return !this.m_initialObjectReturned || this.m_baseEnumeration.hasMoreElements();
        }

        public Object nextElement() {
            Object result = this.m_initialObjectReturned ? this.m_baseEnumeration.nextElement() : this.m_initialObject;
            this.m_initialObjectReturned = true;
            return result;
        }
    }
}

